/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.converters;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ResolvingConverter;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.idea.maven.dom.references.MavenPathReferenceConverter;

public class MavenDependencySystemPathConverter
extends ResolvingConverter<PsiFile>
implements CustomReferenceConverter {
    public PsiFile fromString(String s, ConvertContext context) {
        if (s == null) {
            return null;
        }
        VirtualFile f = LocalFileSystem.getInstance().findFileByPath(s);
        if (f == null) {
            return null;
        }
        return context.getPsiManager().findFile(f);
    }

    public String toString(PsiFile file, ConvertContext context) {
        if (file == null) {
            return null;
        }
        return file.getVirtualFile().getPath();
    }

    public Collection<PsiFile> getVariants(ConvertContext context) {
        return Collections.emptyList();
    }

    public PsiReference[] createReferences(GenericDomValue genericDomValue, PsiElement element, ConvertContext context) {
        return MavenPathReferenceConverter.createReferences((DomElement)genericDomValue, element, new Condition<PsiFileSystemItem>(){

            public boolean value(PsiFileSystemItem item) {
                return item instanceof PsiDirectory || item.getName().endsWith(".jar");
            }
        }, true);
    }
}

