/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.hash.HashSet;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.impl.GenericDomValueReference;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.idea.maven.dom.DependencyConflictId;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.MavenPluginDomUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomDependencies;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomParent;
import org.jetbrains.idea.maven.dom.model.MavenDomPlugin;
import org.jetbrains.idea.maven.dom.model.MavenDomPlugins;
import org.jetbrains.idea.maven.dom.model.MavenDomProfile;
import org.jetbrains.idea.maven.dom.model.MavenDomProfiles;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModelBase;
import org.jetbrains.idea.maven.dom.model.MavenDomProperties;
import org.jetbrains.idea.maven.dom.model.MavenDomSettingsModel;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenParentDesc;
import org.jetbrains.idea.maven.project.MavenParentProjectFileProcessor;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class MavenDomProjectProcessorUtils {
    private MavenDomProjectProcessorUtils() {
    }

    public static Set<MavenDomProjectModel> getChildrenProjects(MavenDomProjectModel model) {
        HashSet models = new HashSet();
        MavenDomProjectProcessorUtils.collectChildrenProjects(model, (Set<MavenDomProjectModel>)models);
        return models;
    }

    private static void collectChildrenProjects(MavenDomProjectModel model, Set<MavenDomProjectModel> models) {
        MavenProject mavenProject = MavenDomUtil.findProject(model);
        if (mavenProject != null) {
            Project project = model.getManager().getProject();
            for (MavenProject inheritor : MavenProjectsManager.getInstance(project).findInheritors(mavenProject)) {
                MavenDomProjectModel inheritorProjectModel = MavenDomUtil.getMavenDomProjectModel(project, inheritor.getFile());
                if (inheritorProjectModel == null || models.contains(inheritorProjectModel)) continue;
                models.add(inheritorProjectModel);
                MavenDomProjectProcessorUtils.collectChildrenProjects(inheritorProjectModel, models);
            }
        }
    }

    public static Set<MavenDomProjectModel> collectParentProjects(MavenDomProjectModel projectDom) {
        HashSet parents = new HashSet();
        Processor<MavenDomProjectModel> collectProcessor = new Processor<MavenDomProjectModel>((Set)parents){
            final /* synthetic */ Set val$parents;
            {
                this.val$parents = set;
            }

            public boolean process(MavenDomProjectModel model) {
                this.val$parents.add(model);
                return false;
            }
        };
        MavenDomProjectProcessorUtils.processParentProjects(projectDom, collectProcessor);
        return parents;
    }

    public static void processParentProjects(MavenDomProjectModel projectDom, Processor<MavenDomProjectModel> processor) {
        HashSet processed = new HashSet();
        Project project = projectDom.getManager().getProject();
        MavenDomProjectModel parent = MavenDomProjectProcessorUtils.findParent(projectDom, project);
        while (parent != null && !processed.contains(parent)) {
            processed.add(parent);
            if (processor.process((Object)parent)) break;
            parent = MavenDomProjectProcessorUtils.findParent(parent, project);
        }
    }

    public static MavenDomProjectModel findParent(MavenDomProjectModel model, Project project) {
        return MavenDomProjectProcessorUtils.findParent(model.getMavenParent(), project);
    }

    public static MavenDomProjectModel findParent(MavenDomParent mavenDomParent, Project project) {
        if (!DomUtil.hasXml((DomElement)mavenDomParent)) {
            return null;
        }
        MavenId id = new MavenId(mavenDomParent.getGroupId().getStringValue(), mavenDomParent.getArtifactId().getStringValue(), mavenDomParent.getVersion().getStringValue());
        MavenProject mavenProject = MavenProjectsManager.getInstance(project).findProject(id);
        return mavenProject != null ? MavenDomUtil.getMavenDomProjectModel(project, mavenProject.getFile()) : null;
    }

    public static XmlTag searchProperty(final String propertyName, MavenDomProjectModel projectDom, Project project) {
        SearchProcessor<XmlTag, MavenDomProperties> searchProcessor = new SearchProcessor<XmlTag, MavenDomProperties>(){

            @Override
            protected XmlTag find(MavenDomProperties element) {
                return MavenDomProjectProcessorUtils.findProperty(element, propertyName);
            }
        };
        MavenDomProjectProcessorUtils.processProperties(projectDom, (Processor<MavenDomProperties>)searchProcessor, project);
        return (XmlTag)((SearchProcessor)searchProcessor).myResult;
    }

    public static XmlTag findProperty(MavenDomProperties mavenDomProperties, String propertyName) {
        XmlTag propertiesTag = mavenDomProperties.getXmlTag();
        if (propertiesTag == null) {
            return null;
        }
        for (XmlTag each : propertiesTag.getSubTags()) {
            if (!each.getName().equals(propertyName)) continue;
            return each;
        }
        return null;
    }

    public static Set<XmlTag> collectProperties(MavenDomProjectModel projectDom, Project project) {
        HashSet properties = new HashSet();
        Processor<MavenDomProperties> collectProcessor = new Processor<MavenDomProperties>((Set)properties){
            final /* synthetic */ Set val$properties;
            {
                this.val$properties = set;
            }

            public boolean process(MavenDomProperties mavenDomProperties) {
                XmlTag propertiesTag = mavenDomProperties.getXmlTag();
                if (propertiesTag != null) {
                    ContainerUtil.addAll((Collection)this.val$properties, (Object[])propertiesTag.getSubTags());
                }
                return false;
            }
        };
        MavenDomProjectProcessorUtils.processProperties(projectDom, collectProcessor, project);
        return properties;
    }

    public static Set<MavenDomDependency> searchDependencyUsages(MavenDomDependency dependency) {
        DependencyConflictId dependencyId;
        MavenDomProjectModel model = (MavenDomProjectModel)dependency.getParentOfType(MavenDomProjectModel.class, false);
        if (model != null && (dependencyId = DependencyConflictId.create(dependency)) != null) {
            return MavenDomProjectProcessorUtils.searchDependencyUsages(model, dependencyId, Collections.singleton(dependency));
        }
        return Collections.emptySet();
    }

    public static Set<MavenDomDependency> searchDependencyUsages(MavenDomProjectModel model, final DependencyConflictId dependencyId, final Set<MavenDomDependency> excludes) {
        Project project = model.getManager().getProject();
        HashSet usages = new HashSet();
        Processor<MavenDomProjectModel> collectProcessor = new Processor<MavenDomProjectModel>((Set)usages){
            final /* synthetic */ Set val$usages;
            {
                this.val$usages = set2;
            }

            public boolean process(MavenDomProjectModel mavenDomProjectModel) {
                for (MavenDomDependency domDependency : mavenDomProjectModel.getDependencies().getDependencies()) {
                    if (excludes.contains(domDependency) || !dependencyId.equals(DependencyConflictId.create(domDependency))) continue;
                    this.val$usages.add(domDependency);
                }
                return false;
            }
        };
        MavenDomProjectProcessorUtils.processChildrenRecursively(model, collectProcessor, project, (Set<MavenDomProjectModel>)new HashSet(), true);
        return usages;
    }

    public static Collection<MavenDomPlugin> searchManagedPluginUsages(MavenDomPlugin plugin) {
        String artifactId = plugin.getArtifactId().getStringValue();
        if (artifactId == null) {
            return Collections.emptyList();
        }
        String groupId = plugin.getGroupId().getStringValue();
        MavenDomProjectModel model = (MavenDomProjectModel)plugin.getParentOfType(MavenDomProjectModel.class, false);
        if (model == null) {
            return Collections.emptyList();
        }
        return MavenDomProjectProcessorUtils.searchManagedPluginUsages(model, groupId, artifactId);
    }

    public static Collection<MavenDomPlugin> searchManagedPluginUsages(MavenDomProjectModel model, final String groupId, final String artifactId) {
        Project project = model.getManager().getProject();
        HashSet usages = new HashSet();
        Processor<MavenDomProjectModel> collectProcessor = new Processor<MavenDomProjectModel>((Set)usages){
            final /* synthetic */ Set val$usages;
            {
                this.val$usages = set;
            }

            public boolean process(MavenDomProjectModel mavenDomProjectModel) {
                for (MavenDomPlugin domPlugin : mavenDomProjectModel.getBuild().getPlugins().getPlugins()) {
                    if (!MavenPluginDomUtil.isPlugin(domPlugin, groupId, artifactId)) continue;
                    this.val$usages.add(domPlugin);
                }
                return false;
            }
        };
        MavenDomProjectProcessorUtils.processChildrenRecursively(model, collectProcessor, project, (Set<MavenDomProjectModel>)new HashSet(), true);
        return usages;
    }

    public static void processChildrenRecursively(MavenDomProjectModel model, Processor<MavenDomProjectModel> processor) {
        MavenDomProjectProcessorUtils.processChildrenRecursively(model, processor, true);
    }

    public static void processChildrenRecursively(MavenDomProjectModel model, Processor<MavenDomProjectModel> processor, boolean processCurrentModel) {
        if (model != null) {
            MavenDomProjectProcessorUtils.processChildrenRecursively(model, processor, model.getManager().getProject(), (Set<MavenDomProjectModel>)new HashSet(), processCurrentModel);
        }
    }

    public static void processChildrenRecursively(MavenDomProjectModel model, Processor<MavenDomProjectModel> processor, Project project, Set<MavenDomProjectModel> processedModels, boolean strict) {
        if (model != null && !processedModels.contains(model)) {
            processedModels.add(model);
            if (strict && processor.process((Object)model)) {
                return;
            }
            MavenProject mavenProject = MavenDomUtil.findProject(model);
            if (mavenProject != null) {
                for (MavenProject childProject : MavenProjectsManager.getInstance(project).findInheritors(mavenProject)) {
                    MavenDomProjectModel childProjectModel = MavenDomUtil.getMavenDomProjectModel(project, childProject.getFile());
                    MavenDomProjectProcessorUtils.processChildrenRecursively(childProjectModel, processor, project, processedModels, true);
                }
            }
        }
    }

    public static MavenDomDependency searchManagingDependency(MavenDomDependency dependency) {
        return MavenDomProjectProcessorUtils.searchManagingDependency(dependency, dependency.getManager().getProject());
    }

    public static MavenDomDependency searchManagingDependency(MavenDomDependency dependency, Project project) {
        final DependencyConflictId depId = DependencyConflictId.create(dependency);
        if (depId == null) {
            return null;
        }
        MavenDomProjectModel model = (MavenDomProjectModel)dependency.getParentOfType(MavenDomProjectModel.class, false);
        if (model == null) {
            return null;
        }
        final Ref res = new Ref();
        Processor<MavenDomDependency> processor = new Processor<MavenDomDependency>(){

            public boolean process(MavenDomDependency dependency) {
                if (depId.equals(DependencyConflictId.create(dependency))) {
                    res.set((Object)dependency);
                    return true;
                }
                return false;
            }
        };
        MavenDomProjectProcessorUtils.processDependenciesInDependencyManagement(model, processor, project);
        return (MavenDomDependency)res.get();
    }

    public static MavenDomPlugin searchManagingPlugin(MavenDomPlugin plugin) {
        final String artifactId = plugin.getArtifactId().getStringValue();
        final String groupId = plugin.getGroupId().getStringValue();
        if (artifactId == null) {
            return null;
        }
        final MavenDomProjectModel model = (MavenDomProjectModel)plugin.getParentOfType(MavenDomProjectModel.class, false);
        if (model == null) {
            return null;
        }
        SearchProcessor<MavenDomPlugin, MavenDomPlugins> processor = new SearchProcessor<MavenDomPlugin, MavenDomPlugins>(){

            @Override
            protected MavenDomPlugin find(MavenDomPlugins mavenDomPlugins) {
                if (!model.equals(mavenDomPlugins.getParentOfType(MavenDomProjectModel.class, true))) {
                    for (MavenDomPlugin domPlugin : mavenDomPlugins.getPlugins()) {
                        if (!MavenPluginDomUtil.isPlugin(domPlugin, groupId, artifactId)) continue;
                        return domPlugin;
                    }
                }
                return null;
            }
        };
        Function<MavenDomProjectModelBase, MavenDomPlugins> domProfileFunction = new Function<MavenDomProjectModelBase, MavenDomPlugins>(){

            public MavenDomPlugins fun(MavenDomProjectModelBase mavenDomProfile) {
                return mavenDomProfile.getBuild().getPluginManagement().getPlugins();
            }
        };
        MavenDomProjectProcessorUtils.process(model, processor, model.getManager().getProject(), domProfileFunction, domProfileFunction);
        return (MavenDomPlugin)((SearchProcessor)processor).myResult;
    }

    public static boolean processDependenciesInDependencyManagement(MavenDomProjectModel projectDom, final Processor<MavenDomDependency> processor, Project project) {
        Processor<MavenDomDependencies> managedDependenciesListProcessor = new Processor<MavenDomDependencies>(){

            public boolean process(MavenDomDependencies dependencies) {
                SmartList importDependencies = null;
                for (MavenDomDependency domDependency : dependencies.getDependencies()) {
                    if ("import".equals(domDependency.getScope().getRawText())) {
                        if (importDependencies == null) {
                            importDependencies = new SmartList();
                        }
                        importDependencies.add((Object)domDependency);
                        continue;
                    }
                    if (!processor.process((Object)domDependency)) continue;
                    return true;
                }
                if (importDependencies != null) {
                    for (MavenDomDependency domDependency : importDependencies) {
                        MavenDomProjectModel dependModel;
                        GenericDomValueReference reference;
                        PsiElement resolve;
                        GenericDomValue<String> version = domDependency.getVersion();
                        if (version.getXmlElement() == null || !((resolve = (reference = new GenericDomValueReference(version)).resolve()) instanceof XmlFile) || (dependModel = MavenDomUtil.getMavenDomModel((PsiFile)resolve, MavenDomProjectModel.class)) == null) continue;
                        for (MavenDomDependency dep : dependModel.getDependencyManagement().getDependencies().getDependencies()) {
                            if (!processor.process((Object)dep)) continue;
                            return true;
                        }
                    }
                }
                return false;
            }
        };
        Function<MavenDomProjectModelBase, MavenDomDependencies> domFunction = new Function<MavenDomProjectModelBase, MavenDomDependencies>(){

            public MavenDomDependencies fun(MavenDomProjectModelBase mavenDomProfile) {
                return mavenDomProfile.getDependencyManagement().getDependencies();
            }
        };
        return MavenDomProjectProcessorUtils.process(projectDom, managedDependenciesListProcessor, project, domFunction, domFunction);
    }

    public static boolean processDependencies(MavenDomProjectModel projectDom, Processor<MavenDomDependencies> processor) {
        Function<MavenDomProjectModelBase, MavenDomDependencies> domFunction = new Function<MavenDomProjectModelBase, MavenDomDependencies>(){

            public MavenDomDependencies fun(MavenDomProjectModelBase mavenDomProfile) {
                return mavenDomProfile.getDependencies();
            }
        };
        return MavenDomProjectProcessorUtils.process(projectDom, processor, projectDom.getManager().getProject(), domFunction, domFunction);
    }

    public static boolean processProperties(MavenDomProjectModel projectDom, Processor<MavenDomProperties> processor, Project project) {
        Function<MavenDomProjectModelBase, MavenDomProperties> domFunction = new Function<MavenDomProjectModelBase, MavenDomProperties>(){

            public MavenDomProperties fun(MavenDomProjectModelBase mavenDomProfile) {
                return mavenDomProfile.getProperties();
            }
        };
        return MavenDomProjectProcessorUtils.process(projectDom, processor, project, domFunction, domFunction);
    }

    public static <T> boolean process(MavenDomProjectModel projectDom, Processor<T> processor, Project project, Function<? super MavenDomProfile, T> domProfileFunction, Function<? super MavenDomProjectModel, T> projectDomFunction) {
        return MavenDomProjectProcessorUtils.process(projectDom, processor, project, domProfileFunction, projectDomFunction, (Set<MavenDomProjectModel>)new HashSet());
    }

    public static <T> boolean process(MavenDomProjectModel projectDom, Processor<T> processor, Project project, Function<? super MavenDomProfile, T> domProfileFunction, Function<? super MavenDomProjectModel, T> projectDomFunction, Set<MavenDomProjectModel> processed) {
        if (processed.contains(projectDom)) {
            return true;
        }
        processed.add(projectDom);
        MavenProject mavenProjectOrNull = MavenDomUtil.findProject(projectDom);
        if (MavenDomProjectProcessorUtils.processSettingsXml(mavenProjectOrNull, processor, project, domProfileFunction)) {
            return true;
        }
        if (MavenDomProjectProcessorUtils.processProject(projectDom, mavenProjectOrNull, processor, project, domProfileFunction, projectDomFunction)) {
            return true;
        }
        return MavenDomProjectProcessorUtils.processParentProjectFile(projectDom, processor, project, domProfileFunction, projectDomFunction, processed);
    }

    private static <T> boolean processParentProjectFile(MavenDomProjectModel projectDom, final Processor<T> processor, final Project project, final Function<? super MavenDomProfile, T> domProfileFunction, final Function<? super MavenDomProjectModel, T> projectDomFunction, final Set<MavenDomProjectModel> processed) {
        Boolean aBoolean = (Boolean)new DomParentProjectFileProcessor<Boolean>(MavenProjectsManager.getInstance(project)){

            @Override
            protected Boolean doProcessParent(VirtualFile parentFile) {
                MavenDomProjectModel parentProjectDom = MavenDomUtil.getMavenDomProjectModel(project, parentFile);
                if (parentProjectDom == null) {
                    return false;
                }
                return MavenDomProjectProcessorUtils.process(parentProjectDom, processor, project, domProfileFunction, projectDomFunction, processed);
            }
        }.process(projectDom);
        return aBoolean == null ? false : aBoolean;
    }

    private static <T> boolean processSettingsXml(MavenProject mavenProject, Processor<T> processor, Project project, Function<? super MavenDomProfile, T> domProfileFunction) {
        MavenGeneralSettings settings = MavenProjectsManager.getInstance(project).getGeneralSettings();
        for (VirtualFile each : settings.getEffectiveSettingsFiles()) {
            MavenDomSettingsModel settingsDom = MavenDomUtil.getMavenDomModel(project, each, MavenDomSettingsModel.class);
            if (settingsDom == null || !MavenDomProjectProcessorUtils.processProfiles(settingsDom.getProfiles(), mavenProject, processor, domProfileFunction)) continue;
            return true;
        }
        return false;
    }

    private static <T> boolean processProject(MavenDomProjectModel projectDom, MavenProject mavenProjectOrNull, Processor<T> processor, Project project, Function<? super MavenDomProfile, T> domProfileFunction, Function<? super MavenDomProjectModel, T> projectDomFunction) {
        if (MavenDomProjectProcessorUtils.processProfilesXml(MavenDomUtil.getVirtualFile(projectDom), mavenProjectOrNull, processor, project, domProfileFunction)) {
            return true;
        }
        if (MavenDomProjectProcessorUtils.processProfiles(projectDom.getProfiles(), mavenProjectOrNull, processor, domProfileFunction)) {
            return true;
        }
        Object t = projectDomFunction.fun((Object)projectDom);
        return t == null ? false : processor.process(t);
    }

    private static <T> boolean processProfilesXml(VirtualFile projectFile, MavenProject mavenProjectOrNull, Processor<T> processor, Project project, Function<? super MavenDomProfile, T> f) {
        VirtualFile profilesFile = MavenUtil.findProfilesXmlFile(projectFile);
        if (profilesFile == null) {
            return false;
        }
        MavenDomProfiles profiles = MavenDomUtil.getMavenDomProfilesModel(project, profilesFile);
        if (profiles == null) {
            return false;
        }
        return MavenDomProjectProcessorUtils.processProfiles(profiles, mavenProjectOrNull, processor, f);
    }

    private static <T> boolean processProfiles(MavenDomProfiles profilesDom, MavenProject mavenProjectOrNull, Processor<T> processor, Function<? super MavenDomProfile, T> f) {
        Collection activeProfiles = mavenProjectOrNull == null ? null : mavenProjectOrNull.getActivatedProfilesIds().getEnabledProfiles();
        for (MavenDomProfile each : profilesDom.getProfiles()) {
            XmlTag idTag = each.getId().getXmlTag();
            if (idTag == null || activeProfiles != null && !activeProfiles.contains(idTag.getValue().getTrimmedText()) || !MavenDomProjectProcessorUtils.processProfile(each, processor, f)) continue;
            return true;
        }
        return false;
    }

    private static <T> boolean processProfile(MavenDomProfile profileDom, Processor<T> processor, Function<? super MavenDomProfile, T> f) {
        Object t = f.fun((Object)profileDom);
        return t != null && processor.process(t);
    }

    public static abstract class SearchProcessor<R, T>
    implements Processor<T> {
        private R myResult;

        public final boolean process(T t) {
            R res = this.find(t);
            if (res != null) {
                this.myResult = res;
                return true;
            }
            return false;
        }

        protected abstract R find(T var1);

        public R getResult() {
            return this.myResult;
        }
    }

    public static abstract class DomParentProjectFileProcessor<T>
    extends MavenParentProjectFileProcessor<T> {
        private final MavenProjectsManager myManager;

        public DomParentProjectFileProcessor(MavenProjectsManager manager) {
            this.myManager = manager;
        }

        @Override
        protected VirtualFile findManagedFile(MavenId id) {
            MavenProject project = this.myManager.findProject(id);
            return project == null ? null : project.getFile();
        }

        public T process(MavenDomProjectModel projectDom) {
            MavenDomParent parent = projectDom.getMavenParent();
            MavenParentDesc parentDesc = null;
            if (DomUtil.hasXml((DomElement)parent)) {
                String parentGroupId = parent.getGroupId().getStringValue();
                String parentArtifactId = parent.getArtifactId().getStringValue();
                String parentVersion = parent.getVersion().getStringValue();
                String parentRelativePath = parent.getRelativePath().getStringValue();
                if (StringUtil.isEmptyOrSpaces((String)parentRelativePath)) {
                    parentRelativePath = "../pom.xml";
                }
                MavenId parentId = new MavenId(parentGroupId, parentArtifactId, parentVersion);
                parentDesc = new MavenParentDesc(parentId, parentRelativePath);
            }
            return (T)this.process(this.myManager.getGeneralSettings(), MavenDomUtil.getVirtualFile(projectDom), parentDesc);
        }
    }
}

