/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom;

import com.intellij.javaee.ExternalResourceManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.impl.schema.XmlNSDescriptorImpl;
import gnu.trove.THashMap;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;
import org.jetbrains.idea.maven.dom.MavenDomUtil;

public class MavenDomElementDescriptorHolder {
    private static final Logger LOG = Logger.getInstance(MavenDomElementDescriptorHolder.class);
    private final Project myProject;
    private final Map<FileKind, CachedValue<XmlNSDescriptorImpl>> myDescriptorsMap = new THashMap();

    public MavenDomElementDescriptorHolder(Project project) {
        this.myProject = project;
    }

    public static MavenDomElementDescriptorHolder getInstance(Project project) {
        return (MavenDomElementDescriptorHolder)ServiceManager.getService((Project)project, MavenDomElementDescriptorHolder.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XmlElementDescriptor getDescriptor(XmlTag tag) {
        XmlNSDescriptorImpl desc;
        FileKind kind = MavenDomElementDescriptorHolder.getFileKind(tag.getContainingFile());
        if (kind == null) {
            return null;
        }
        MavenDomElementDescriptorHolder mavenDomElementDescriptorHolder = this;
        synchronized (mavenDomElementDescriptorHolder) {
            desc = this.tryGetOrCreateDescriptor(kind);
            if (desc == null) {
                return null;
            }
        }
        LOG.assertTrue(tag.isValid());
        LOG.assertTrue(desc.isValid());
        return desc.getElementDescriptor(tag.getName(), desc.getDefaultNamespace());
    }

    private XmlNSDescriptorImpl tryGetOrCreateDescriptor(final FileKind kind) {
        CachedValue result = this.myDescriptorsMap.get((Object)kind);
        if (result == null) {
            result = CachedValuesManager.getManager((Project)this.myProject).createCachedValue((CachedValueProvider)new CachedValueProvider<XmlNSDescriptorImpl>(){

                public CachedValueProvider.Result<XmlNSDescriptorImpl> compute() {
                    return CachedValueProvider.Result.create((Object)MavenDomElementDescriptorHolder.this.doCreateDescriptor(kind), (Object[])new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
                }
            }, false);
            this.myDescriptorsMap.put(kind, (CachedValue<XmlNSDescriptorImpl>)result);
        }
        return (XmlNSDescriptorImpl)result.getValue();
    }

    private XmlNSDescriptorImpl doCreateDescriptor(FileKind kind) {
        VirtualFile schema;
        String location;
        String schemaUrl = kind.getSchemaUrl();
        if (schemaUrl.equals(location = ExternalResourceManager.getInstance().getResourceLocation(schemaUrl))) {
            return null;
        }
        try {
            schema = VfsUtil.findFileByURL((URL)new URL(location));
        }
        catch (MalformedURLException ignore) {
            return null;
        }
        if (schema == null) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(schema);
        if (!(psiFile instanceof XmlFile)) {
            return null;
        }
        XmlNSDescriptorImpl result = new XmlNSDescriptorImpl();
        result.init((PsiElement)psiFile);
        return result;
    }

    private static FileKind getFileKind(PsiFile file) {
        if (MavenDomUtil.isProjectFile(file)) {
            return FileKind.PROJECT_FILE;
        }
        if (MavenDomUtil.isProfilesFile(file)) {
            return FileKind.PROFILES_FILE;
        }
        if (MavenDomUtil.isSettingsFile(file)) {
            return FileKind.SETTINGS_FILE;
        }
        return null;
    }

    private static enum FileKind {
        PROJECT_FILE{

            @Override
            public String getSchemaUrl() {
                return "http://maven.apache.org/xsd/maven-4.0.0.xsd";
            }
        }
        ,
        PROFILES_FILE{

            @Override
            public String getSchemaUrl() {
                return "http://maven.apache.org/xsd/profiles-1.0.0.xsd";
            }
        }
        ,
        SETTINGS_FILE{

            @Override
            public String getSchemaUrl() {
                return "http://maven.apache.org/xsd/settings-1.0.0.xsd";
            }
        };


        public abstract String getSchemaUrl();
    }
}

