/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.util;

import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.plugins.github.util.GithubSettings;

public class GithubAuthData {
    private final AuthType myAuthType;
    private final String myHost;
    private final BasicAuth myBasicAuth;
    private final TokenAuth myTokenAuth;
    private final boolean myUseProxy;

    private GithubAuthData(AuthType authType, String host, BasicAuth basicAuth, TokenAuth tokenAuth, boolean useProxy) {
        this.myAuthType = authType;
        this.myHost = host;
        this.myBasicAuth = basicAuth;
        this.myTokenAuth = tokenAuth;
        this.myUseProxy = useProxy;
    }

    public static GithubAuthData createFromSettings() {
        return GithubSettings.getInstance().getAuthData();
    }

    public static GithubAuthData createAnonymous() {
        return GithubAuthData.createAnonymous("github.com");
    }

    public static GithubAuthData createAnonymous(String host) {
        return new GithubAuthData(AuthType.ANONYMOUS, host, null, null, true);
    }

    public static GithubAuthData createBasicAuth(String host, String login, String password) {
        return new GithubAuthData(AuthType.BASIC, host, new BasicAuth(login, password), null, true);
    }

    public static GithubAuthData createBasicAuthTF(String host, String login, String password, String code) {
        return new GithubAuthData(AuthType.BASIC, host, new BasicAuth(login, password, code), null, true);
    }

    public static GithubAuthData createTokenAuth(String host, String token) {
        return new GithubAuthData(AuthType.TOKEN, host, null, new TokenAuth(token), true);
    }

    public static GithubAuthData createTokenAuth(String host, String token, boolean useProxy) {
        return new GithubAuthData(AuthType.TOKEN, host, null, new TokenAuth(token), useProxy);
    }

    public AuthType getAuthType() {
        return this.myAuthType;
    }

    public String getHost() {
        return this.myHost;
    }

    public BasicAuth getBasicAuth() {
        return this.myBasicAuth;
    }

    public TokenAuth getTokenAuth() {
        return this.myTokenAuth;
    }

    public boolean isUseProxy() {
        return this.myUseProxy;
    }

    public GithubAuthData copyWithTwoFactorCode(String code) {
        if (this.myBasicAuth == null) {
            throw new IllegalStateException("Two factor authentication can be used only with Login/Password");
        }
        return GithubAuthData.createBasicAuthTF(this.getHost(), this.myBasicAuth.getLogin(), this.myBasicAuth.getPassword(), code);
    }

    public static class TokenAuth {
        private final String myToken;

        private TokenAuth(String token) {
            this.myToken = StringUtil.trim((String)token);
        }

        public String getToken() {
            return this.myToken;
        }
    }

    public static class BasicAuth {
        private final String myLogin;
        private final String myPassword;
        private final String myCode;

        private BasicAuth(String login, String password) {
            this(login, password, (String)null);
        }

        private BasicAuth(String login, String password, String code) {
            this.myLogin = login;
            this.myPassword = password;
            this.myCode = code;
        }

        public String getLogin() {
            return this.myLogin;
        }

        public String getPassword() {
            return this.myPassword;
        }

        public String getCode() {
            return this.myCode;
        }
    }

    public static enum AuthType {
        BASIC,
        TOKEN,
        ANONYMOUS;

    }
}

