/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.tasks;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.PasswordUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.Comment;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskRepositoryType;
import com.intellij.tasks.TaskState;
import com.intellij.tasks.TaskType;
import com.intellij.tasks.impl.BaseRepository;
import com.intellij.tasks.impl.BaseRepositoryImpl;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import icons.TasksIcons;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.plugins.github.api.GithubApiUtil;
import org.jetbrains.plugins.github.api.GithubConnection;
import org.jetbrains.plugins.github.api.GithubIssue;
import org.jetbrains.plugins.github.api.GithubIssueComment;
import org.jetbrains.plugins.github.exceptions.GithubAuthenticationException;
import org.jetbrains.plugins.github.exceptions.GithubJsonException;
import org.jetbrains.plugins.github.exceptions.GithubOperationCanceledException;
import org.jetbrains.plugins.github.exceptions.GithubRateLimitExceededException;
import org.jetbrains.plugins.github.exceptions.GithubStatusCodeException;
import org.jetbrains.plugins.github.tasks.GithubComment;
import org.jetbrains.plugins.github.tasks.GithubRepositoryType;
import org.jetbrains.plugins.github.util.GithubAuthData;
import org.jetbrains.plugins.github.util.GithubUtil;

@Tag(value="GitHub")
public class GithubRepository
extends BaseRepositoryImpl {
    private static final Logger LOG = GithubUtil.LOG;
    private Pattern myPattern = Pattern.compile("($^)");
    private String myRepoAuthor = "";
    private String myRepoName = "";
    private String myUser = "";
    private String myToken = "";

    public GithubRepository() {
    }

    public GithubRepository(GithubRepository other) {
        super((BaseRepositoryImpl)other);
        this.setRepoName(other.myRepoName);
        this.setRepoAuthor(other.myRepoAuthor);
        this.setToken(other.myToken);
    }

    public GithubRepository(GithubRepositoryType type) {
        super((TaskRepositoryType)type);
        this.setUrl("https://github.com");
    }

    public TaskRepository.CancellableConnection createCancellableConnection() {
        return new TaskRepository.CancellableConnection(){
            private final GithubConnection myConnection;
            {
                this.myConnection = new GithubConnection(GithubRepository.this.getAuthData(), false);
            }

            protected void doTest() throws Exception {
                try {
                    GithubApiUtil.getIssuesQueried(this.myConnection, GithubRepository.this.getRepoAuthor(), GithubRepository.this.getRepoName(), "", false);
                }
                catch (GithubOperationCanceledException githubOperationCanceledException) {
                    // empty catch block
                }
            }

            public void cancel() {
                this.myConnection.abort();
            }
        };
    }

    public boolean isConfigured() {
        return super.isConfigured() && !StringUtil.isEmptyOrSpaces((String)this.getRepoAuthor()) && !StringUtil.isEmptyOrSpaces((String)this.getRepoName()) && !StringUtil.isEmptyOrSpaces((String)this.getToken());
    }

    public String getPresentableName() {
        String name = super.getPresentableName();
        return name + (!StringUtil.isEmpty((String)this.getRepoAuthor()) ? "/" + this.getRepoAuthor() : "") + (!StringUtil.isEmpty((String)this.getRepoName()) ? "/" + this.getRepoName() : "");
    }

    public Task[] getIssues(String query, int offset, int limit, boolean withClosed) throws Exception {
        try {
            return this.getIssues(query, offset + limit, withClosed);
        }
        catch (GithubRateLimitExceededException e) {
            return new Task[0];
        }
        catch (GithubAuthenticationException e) {
            throw new Exception(e.getMessage(), e);
        }
        catch (GithubStatusCodeException e) {
            throw new Exception(e.getMessage(), e);
        }
        catch (GithubJsonException e) {
            throw new Exception("Bad response format", e);
        }
    }

    public Task[] getIssues(String query, int offset, int limit, boolean withClosed, ProgressIndicator cancelled) throws Exception {
        return this.getIssues(query, offset, limit, withClosed);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Task[] getIssues(String query, int max, boolean withClosed) throws Exception {
        GithubConnection connection = this.getConnection();
        try {
            List<GithubIssue> issues;
            if (StringUtil.isEmptyOrSpaces((String)query)) {
                if (StringUtil.isEmptyOrSpaces((String)this.myUser)) {
                    this.myUser = GithubApiUtil.getCurrentUser(connection).getLogin();
                }
                issues = GithubApiUtil.getIssuesAssigned(connection, this.getRepoAuthor(), this.getRepoName(), this.myUser, max, withClosed);
            } else {
                issues = GithubApiUtil.getIssuesQueried(connection, this.getRepoAuthor(), this.getRepoName(), query, withClosed);
            }
            Task[] taskArray = (Task[])ContainerUtil.map2Array(issues, Task.class, (Function)new Function<GithubIssue, Task>(){

                public Task fun(GithubIssue issue) {
                    return GithubRepository.this.createTask(issue);
                }
            });
            return taskArray;
        }
        finally {
            connection.close();
        }
    }

    private Task createTask(final GithubIssue issue) {
        return new Task(){
            String myRepoName;
            {
                this.myRepoName = GithubRepository.this.getRepoName();
            }

            public boolean isIssue() {
                return true;
            }

            public String getIssueUrl() {
                return issue.getHtmlUrl();
            }

            public String getId() {
                return this.myRepoName + "-" + issue.getNumber();
            }

            public String getSummary() {
                return issue.getTitle();
            }

            public String getDescription() {
                return issue.getBody();
            }

            public Comment[] getComments() {
                try {
                    return GithubRepository.this.fetchComments(issue.getNumber());
                }
                catch (Exception e) {
                    LOG.warn("Error fetching comments for " + issue.getNumber(), (Throwable)e);
                    return Comment.EMPTY_ARRAY;
                }
            }

            public Icon getIcon() {
                return TasksIcons.Github;
            }

            public TaskType getType() {
                return TaskType.BUG;
            }

            public Date getUpdated() {
                return issue.getUpdatedAt();
            }

            public Date getCreated() {
                return issue.getCreatedAt();
            }

            public boolean isClosed() {
                return !"open".equals(issue.getState());
            }

            public TaskRepository getRepository() {
                return GithubRepository.this;
            }

            public String getPresentableName() {
                return this.getId() + ": " + this.getSummary();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Comment[] fetchComments(long id) throws Exception {
        GithubConnection connection = this.getConnection();
        try {
            List<GithubIssueComment> result = GithubApiUtil.getIssueComments(connection, this.getRepoAuthor(), this.getRepoName(), id);
            Comment[] commentArray = (Comment[])ContainerUtil.map2Array(result, Comment.class, (Function)new Function<GithubIssueComment, Comment>(){

                public Comment fun(GithubIssueComment comment) {
                    return new GithubComment(comment.getCreatedAt(), comment.getUser().getLogin(), comment.getBodyHtml(), comment.getUser().getAvatarUrl(), comment.getUser().getHtmlUrl());
                }
            });
            return commentArray;
        }
        finally {
            connection.close();
        }
    }

    public String extractId(String taskName) {
        Matcher matcher = this.myPattern.matcher(taskName);
        return matcher.find() ? matcher.group(1) : null;
    }

    public Task findTask(String id) throws Exception {
        int index = id.lastIndexOf("-");
        if (index < 0) {
            return null;
        }
        String numericId = id.substring(index + 1);
        GithubConnection connection = this.getConnection();
        try {
            Task task = this.createTask(GithubApiUtil.getIssue(connection, this.getRepoAuthor(), this.getRepoName(), numericId));
            return task;
        }
        catch (GithubStatusCodeException e) {
            if (e.getStatusCode() == 404) {
                Task task = null;
                return task;
            }
            throw e;
        }
        finally {
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTaskState(Task task, TaskState state) throws Exception {
        GithubConnection connection = this.getConnection();
        try {
            boolean isOpen;
            switch (state) {
                case OPEN: {
                    isOpen = true;
                    break;
                }
                case RESOLVED: {
                    isOpen = false;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown state: " + state);
                }
            }
            GithubApiUtil.setIssueState(connection, this.getRepoAuthor(), this.getRepoName(), task.getNumber(), isOpen);
        }
        finally {
            connection.close();
        }
    }

    public BaseRepository clone() {
        return new GithubRepository(this);
    }

    public String getRepoName() {
        return this.myRepoName;
    }

    public void setRepoName(String repoName) {
        this.myRepoName = repoName;
        this.myPattern = Pattern.compile("(" + StringUtil.escapeToRegexp((String)repoName) + "\\-\\d+)");
    }

    public String getRepoAuthor() {
        return this.myRepoAuthor;
    }

    public void setRepoAuthor(String repoAuthor) {
        this.myRepoAuthor = repoAuthor;
    }

    public String getUser() {
        return this.myUser;
    }

    public void setUser(String user) {
        this.myUser = user;
    }

    @Transient
    public String getToken() {
        return this.myToken;
    }

    public void setToken(String token) {
        this.myToken = token;
        this.setUser("");
    }

    @Tag(value="token")
    public String getEncodedToken() {
        return PasswordUtil.encodePassword((String)this.getToken());
    }

    public void setEncodedToken(String password) {
        try {
            this.setToken(PasswordUtil.decodePassword((String)password));
        }
        catch (NumberFormatException e) {
            LOG.warn("Can't decode token", (Throwable)e);
        }
    }

    private GithubAuthData getAuthData() {
        return GithubAuthData.createTokenAuth(this.getUrl(), this.getToken(), this.isUseProxy());
    }

    private GithubConnection getConnection() {
        return new GithubConnection(this.getAuthData(), true);
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof GithubRepository)) {
            return false;
        }
        GithubRepository that = (GithubRepository)((Object)o);
        if (!Comparing.equal((String)this.getRepoAuthor(), (String)that.getRepoAuthor())) {
            return false;
        }
        if (!Comparing.equal((String)this.getRepoName(), (String)that.getRepoName())) {
            return false;
        }
        return Comparing.equal((String)this.getToken(), (String)that.getToken());
    }

    protected int getFeatures() {
        return super.getFeatures() | 8;
    }
}

