/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api;

import com.intellij.openapi.util.text.StringUtil;
import java.util.Date;
import org.jetbrains.plugins.github.api.GithubRepo;
import org.jetbrains.plugins.github.api.GithubUser;

public class GithubPullRequest {
    private final long myNumber;
    private final String myState;
    private final String myTitle;
    private final String myBodyHtml;
    private final String myHtmlUrl;
    private final String myDiffUrl;
    private final String myPatchUrl;
    private final String myIssueUrl;
    private final Date myCreatedAt;
    private final Date myUpdatedAt;
    private final Date myClosedAt;
    private final Date myMergedAt;
    private final GithubUser myUser;
    private final Link myHead;
    private final Link myBase;

    public GithubPullRequest(long number, String state, String title, String bodyHtml, String htmlUrl, String diffUrl, String patchUrl, String issueUrl, Date createdAt, Date updatedAt, Date closedAt, Date mergedAt, GithubUser user, Link head, Link base) {
        this.myNumber = number;
        this.myState = state;
        this.myTitle = title;
        this.myBodyHtml = StringUtil.notNullize((String)bodyHtml);
        this.myHtmlUrl = htmlUrl;
        this.myDiffUrl = diffUrl;
        this.myPatchUrl = patchUrl;
        this.myIssueUrl = issueUrl;
        this.myCreatedAt = createdAt;
        this.myUpdatedAt = updatedAt;
        this.myClosedAt = closedAt;
        this.myMergedAt = mergedAt;
        this.myUser = user;
        this.myHead = head;
        this.myBase = base;
    }

    public long getNumber() {
        return this.myNumber;
    }

    public String getState() {
        return this.myState;
    }

    public String getTitle() {
        return this.myTitle;
    }

    public String getBodyHtml() {
        return this.myBodyHtml;
    }

    public String getHtmlUrl() {
        return this.myHtmlUrl;
    }

    public String getDiffUrl() {
        return this.myDiffUrl;
    }

    public String getPatchUrl() {
        return this.myPatchUrl;
    }

    public String getIssueUrl() {
        return this.myIssueUrl;
    }

    public Date getCreatedAt() {
        return this.myCreatedAt;
    }

    public Date getUpdatedAt() {
        return this.myUpdatedAt;
    }

    public Date getClosedAt() {
        return this.myClosedAt;
    }

    public Date getMergedAt() {
        return this.myMergedAt;
    }

    public GithubUser getUser() {
        return this.myUser;
    }

    public Link getHead() {
        return this.myHead;
    }

    public Link getBase() {
        return this.myBase;
    }

    public static class Link {
        private final String myLabel;
        private final String myRef;
        private final String mySha;
        private final GithubRepo myRepo;
        private final GithubUser myUser;

        public Link(String label, String ref, String sha, GithubRepo repo, GithubUser user) {
            this.myLabel = label;
            this.myRef = ref;
            this.mySha = sha;
            this.myRepo = repo;
            this.myUser = user;
        }

        public String getLabel() {
            return this.myLabel;
        }

        public String getRef() {
            return this.myRef;
        }

        public String getSha() {
            return this.mySha;
        }

        public GithubRepo getRepo() {
            return this.myRepo;
        }

        public GithubUser getUser() {
            return this.myUser;
        }
    }
}

