/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api;

import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.plugins.github.api.GithubUser;

public class GithubGist {
    private final String myId;
    private final String myDescription;
    private final boolean myIsPublic;
    private final String myHtmlUrl;
    private final List<GistFile> myFiles;
    private final GithubUser myUser;

    public List<FileContent> getContent() {
        ArrayList<FileContent> ret = new ArrayList<FileContent>();
        for (GistFile file : this.getFiles()) {
            ret.add(new FileContent(file.getFilename(), file.getContent()));
        }
        return ret;
    }

    public GithubGist(String id, String description, boolean isPublic, String htmlUrl, List<GistFile> files, GithubUser user) {
        this.myId = id;
        this.myDescription = StringUtil.notNullize((String)description);
        this.myIsPublic = isPublic;
        this.myHtmlUrl = htmlUrl;
        this.myFiles = files;
        this.myUser = user;
    }

    public String getId() {
        return this.myId;
    }

    public String getDescription() {
        return this.myDescription;
    }

    public boolean isPublic() {
        return this.myIsPublic;
    }

    public String getHtmlUrl() {
        return this.myHtmlUrl;
    }

    public List<GistFile> getFiles() {
        return this.myFiles;
    }

    public GithubUser getUser() {
        return this.myUser;
    }

    public static class FileContent {
        private final String myFileName;
        private final String myContent;

        public FileContent(String fileName, String content) {
            this.myFileName = fileName;
            this.myContent = content;
        }

        public String getFileName() {
            return this.myFileName;
        }

        public String getContent() {
            return this.myContent;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FileContent that = (FileContent)o;
            if (!this.myContent.equals(that.myContent)) {
                return false;
            }
            return this.myFileName.equals(that.myFileName);
        }

        public int hashCode() {
            int result = this.myFileName.hashCode();
            result = 31 * result + this.myContent.hashCode();
            return result;
        }
    }

    public static class GistFile {
        private final String myFilename;
        private final String myContent;
        private final String myRawUrl;

        public GistFile(String filename, String content, String rawUrl) {
            this.myFilename = filename;
            this.myContent = content;
            this.myRawUrl = rawUrl;
        }

        public String getFilename() {
            return this.myFilename;
        }

        public String getContent() {
            return this.myContent;
        }

        public String getRawUrl() {
            return this.myRawUrl;
        }
    }
}

