/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.module.impl;

import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.sdk.JpsSdkReference;
import org.jetbrains.jps.model.library.sdk.JpsSdkType;
import org.jetbrains.jps.model.module.JpsSdkDependency;
import org.jetbrains.jps.model.module.impl.JpsDependencyElementBase;

public class JpsSdkDependencyImpl
extends JpsDependencyElementBase<JpsSdkDependencyImpl>
implements JpsSdkDependency {
    private final JpsSdkType<?> mySdkType;

    public JpsSdkDependencyImpl(JpsSdkType<?> sdkType) {
        this.mySdkType = sdkType;
    }

    public JpsSdkDependencyImpl(JpsSdkDependencyImpl original) {
        super(original);
        this.mySdkType = original.mySdkType;
    }

    public JpsSdkDependencyImpl createCopy() {
        return new JpsSdkDependencyImpl(this);
    }

    public JpsSdkType<?> getSdkType() {
        return this.mySdkType;
    }

    public JpsLibrary resolveSdk() {
        JpsSdkReference<?> reference = this.getSdkReference();
        if (reference == null) {
            return null;
        }
        return (JpsLibrary)reference.resolve();
    }

    public JpsSdkReference<?> getSdkReference() {
        return this.getContainingModule().getSdkReference(this.mySdkType);
    }

    public boolean isInherited() {
        return false;
    }

    public String toString() {
        return "sdk dep [" + this.mySdkType + "]";
    }
}

