/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.library.impl;

import java.util.List;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementCollection;
import org.jetbrains.jps.model.JpsElementTypeWithDefaultProperties;
import org.jetbrains.jps.model.library.JpsLibrary;
import org.jetbrains.jps.model.library.JpsLibraryCollection;
import org.jetbrains.jps.model.library.JpsLibraryType;
import org.jetbrains.jps.model.library.JpsTypedLibrary;
import org.jetbrains.jps.model.library.impl.JpsLibraryImpl;

public class JpsLibraryCollectionImpl
implements JpsLibraryCollection {
    private final JpsElementCollection<JpsLibrary> myCollection;

    public JpsLibraryCollectionImpl(JpsElementCollection<JpsLibrary> collection) {
        this.myCollection = collection;
    }

    public <P extends JpsElement, LibraryType extends JpsLibraryType<P> & JpsElementTypeWithDefaultProperties<P>> JpsLibrary addLibrary(String name, LibraryType type) {
        return this.addLibrary(name, type, (P)((JpsElement)((JpsElementTypeWithDefaultProperties<P>)type).createDefaultProperties()));
    }

    public <P extends JpsElement> JpsTypedLibrary<P> addLibrary(String name, JpsLibraryType<P> type, P properties) {
        return (JpsTypedLibrary)this.myCollection.addChild(new JpsLibraryImpl<P>(name, type, properties));
    }

    public List<JpsLibrary> getLibraries() {
        return this.myCollection.getElements();
    }

    public <P extends JpsElement> Iterable<JpsTypedLibrary<P>> getLibraries(JpsLibraryType<P> type) {
        return this.myCollection.getElementsOfType(type);
    }

    public void addLibrary(JpsLibrary library) {
        this.myCollection.addChild((JpsElement)library);
    }

    public JpsLibrary findLibrary(String name) {
        for (JpsLibrary library : this.getLibraries()) {
            if (!name.equals(library.getName())) continue;
            return library;
        }
        return null;
    }

    public <E extends JpsElement> JpsTypedLibrary<E> findLibrary(String name, JpsLibraryType<E> type) {
        for (JpsTypedLibrary<E> library : this.getLibraries(type)) {
            if (!name.equals(library.getName())) continue;
            return library;
        }
        return null;
    }
}

