/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.impl;

import org.jetbrains.jps.model.JpsElementReference;
import org.jetbrains.jps.model.JpsEventDispatcher;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.impl.JpsGlobalImpl;
import org.jetbrains.jps.model.impl.JpsProjectImpl;

public class JpsModelImpl
implements JpsModel {
    private JpsProjectImpl myProject;
    private JpsGlobalImpl myGlobal;
    private JpsModelImpl myOriginalModel;
    private final JpsEventDispatcher myEventDispatcher;

    public JpsModelImpl(JpsEventDispatcher eventDispatcher) {
        this.myEventDispatcher = eventDispatcher;
        this.myProject = new JpsProjectImpl(this, eventDispatcher);
        this.myGlobal = new JpsGlobalImpl(this, eventDispatcher);
    }

    private JpsModelImpl(JpsModelImpl original, JpsEventDispatcher eventDispatcher) {
        this.myOriginalModel = original;
        this.myEventDispatcher = eventDispatcher;
        this.myProject = new JpsProjectImpl(original.myProject, (JpsModel)this, eventDispatcher);
        this.myGlobal = new JpsGlobalImpl(original.myGlobal, (JpsModel)this, eventDispatcher);
    }

    public JpsProjectImpl getProject() {
        return this.myProject;
    }

    public JpsGlobalImpl getGlobal() {
        return this.myGlobal;
    }

    public JpsModel createModifiableModel(JpsEventDispatcher eventDispatcher) {
        return new JpsModelImpl(this, eventDispatcher);
    }

    public void registerExternalReference(JpsElementReference<?> reference) {
        this.myProject.addExternalReference(reference);
    }

    public void commit() {
        this.myOriginalModel.applyChanges(this);
    }

    private void applyChanges(JpsModelImpl modifiedCopy) {
        this.myProject.applyChanges(modifiedCopy.myProject);
        this.myGlobal.applyChanges(modifiedCopy.myGlobal);
    }
}

