/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.artifact.impl;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.JpsElementChildRole;
import org.jetbrains.jps.model.artifact.JpsArtifact;
import org.jetbrains.jps.model.artifact.JpsArtifactType;
import org.jetbrains.jps.model.artifact.elements.JpsArchivePackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsCompositePackagingElement;
import org.jetbrains.jps.model.artifact.impl.JpsArtifactReferenceImpl;
import org.jetbrains.jps.model.ex.JpsElementChildRoleBase;
import org.jetbrains.jps.model.ex.JpsNamedCompositeElementBase;

public class JpsArtifactImpl<P extends JpsElement>
extends JpsNamedCompositeElementBase<JpsArtifactImpl<P>>
implements JpsArtifact {
    private static final JpsElementChildRole<JpsCompositePackagingElement> ROOT_ELEMENT_CHILD_ROLE = JpsElementChildRoleBase.create((String)"root element");
    private final JpsArtifactType<P> myArtifactType;
    private String myOutputPath;
    private boolean myBuildOnMake;

    public JpsArtifactImpl(String name, JpsCompositePackagingElement rootElement, JpsArtifactType<P> type, P properties) {
        super(name);
        this.myArtifactType = type;
        this.myContainer.setChild(ROOT_ELEMENT_CHILD_ROLE, (JpsElement)rootElement);
        this.myContainer.setChild(type.getPropertiesRole(), properties);
    }

    private JpsArtifactImpl(JpsArtifactImpl<P> original) {
        super(original);
        this.myArtifactType = original.myArtifactType;
        this.myOutputPath = original.myOutputPath;
    }

    public JpsArtifactImpl<P> createCopy() {
        return new JpsArtifactImpl<P>(this);
    }

    public String getOutputPath() {
        return this.myOutputPath;
    }

    public void setOutputPath(String outputPath) {
        if (!Comparing.equal((String)this.myOutputPath, (String)outputPath)) {
            this.myOutputPath = outputPath;
            this.fireElementChanged();
        }
    }

    public String getOutputFilePath() {
        if (StringUtil.isEmpty((String)this.myOutputPath)) {
            return null;
        }
        JpsCompositePackagingElement root = this.getRootElement();
        return root instanceof JpsArchivePackagingElement ? this.myOutputPath + "/" + ((JpsArchivePackagingElement)root).getArchiveName() : this.myOutputPath;
    }

    public JpsArtifactType<P> getArtifactType() {
        return this.myArtifactType;
    }

    public JpsArtifactReferenceImpl createReference() {
        return new JpsArtifactReferenceImpl(this.getName());
    }

    public JpsCompositePackagingElement getRootElement() {
        return (JpsCompositePackagingElement)this.myContainer.getChild(ROOT_ELEMENT_CHILD_ROLE);
    }

    public void setRootElement(JpsCompositePackagingElement rootElement) {
        this.myContainer.setChild(ROOT_ELEMENT_CHILD_ROLE, (JpsElement)rootElement);
    }

    public P getProperties() {
        return (P)this.myContainer.getChild(this.myArtifactType.getPropertiesRole());
    }

    public boolean isBuildOnMake() {
        return this.myBuildOnMake;
    }

    public void setBuildOnMake(boolean buildOnMake) {
        if (this.myBuildOnMake != buildOnMake) {
            this.myBuildOnMake = buildOnMake;
            this.fireElementChanged();
        }
    }
}

