/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileTypes.impl;

import com.intellij.openapi.fileTypes.impl.FileTypeAssocTable;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.jetbrains.jps.model.fileTypes.FileNameMatcherFactory;

public class IgnoredPatternSet {
    private final Set<String> myMasks = new LinkedHashSet<String>();
    private final FileTypeAssocTable<Boolean> myIgnorePatterns = new FileTypeAssocTable().copy();

    Set<String> getIgnoreMasks() {
        return Collections.unmodifiableSet(this.myMasks);
    }

    public void setIgnoreMasks(String list) {
        this.clearPatterns();
        StringTokenizer tokenizer = new StringTokenizer(list, ";");
        while (tokenizer.hasMoreTokens()) {
            String ignoredFile = tokenizer.nextToken();
            if (ignoredFile == null) continue;
            this.addIgnoreMask(ignoredFile);
        }
    }

    void addIgnoreMask(String ignoredFile) {
        if (this.myIgnorePatterns.findAssociatedFileType(ignoredFile) == null) {
            this.myMasks.add(ignoredFile);
            this.myIgnorePatterns.addAssociation(FileNameMatcherFactory.getInstance().createMatcher(ignoredFile), Boolean.TRUE);
        }
    }

    public boolean isIgnored(String fileName) {
        if (this.myIgnorePatterns.findAssociatedFileType(fileName) == Boolean.TRUE) {
            return true;
        }
        return fileName.endsWith(".__del__");
    }

    public void clearPatterns() {
        this.myMasks.clear();
        this.myIgnorePatterns.removeAllAssociations(Boolean.TRUE);
    }
}

