/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.context.java;

import com.intellij.debugger.DebuggerManager;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.tasks.context.WorkingContextProvider;
import java.util.List;
import org.jdom.Element;

public class BreakpointsContextProvider
extends WorkingContextProvider {
    private final DebuggerManager myDebuggerManager;

    public BreakpointsContextProvider(DebuggerManager debuggerManager) {
        this.myDebuggerManager = debuggerManager;
    }

    public String getId() {
        return "javaDebugger";
    }

    public String getDescription() {
        return "Java Debugger breakpoints";
    }

    public void saveContext(Element toElement) throws WriteExternalException {
        ((DebuggerManagerEx)this.myDebuggerManager).getBreakpointManager().writeExternal(toElement);
    }

    public void loadContext(Element fromElement) throws InvalidDataException {
        ((PersistentStateComponent)this.myDebuggerManager).loadState((Object)fromElement);
    }

    public void clearContext() {
        final BreakpointManager breakpointManager = ((DebuggerManagerEx)this.myDebuggerManager).getBreakpointManager();
        List breakpoints = breakpointManager.getBreakpoints();
        for (final Breakpoint breakpoint : breakpoints) {
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    breakpointManager.removeBreakpoint(breakpoint);
                }
            });
        }
    }
}

