#!/usr/bin/php
<?php

$gOratab = '/etc/oratab';

// ---------------------------------------------------------------------
function printUsage()
// ---------------------------------------------------------------------
{
  global $gMyName;

  print "
Usage: $gMyName {start | stop | status} [<SID>]

Examples:

  $gMyName status agent97b

  $gMyName status

  $gMyName start agent97a

";
}

// ---------------------------------------------------------------------
function getOratab( $pOratab )
// ---------------------------------------------------------------------
{
  $rc = 0;
  $aOratab = array();

  $fh = @fopen($pOratab, 'r');
  if ( ! $fh ) {
    $rc = 4;
    fprintf(STDERR, "ERROR: Cannot open file $pOratab (rc=$rc).\n");
    return array($rc, $aOratab);
  }

  while ( ($buffer = fgets($fh, 4096)) !== false ) {
    array_push($aOratab, trim($buffer));
  }
  if ( ! feof($fh) ) {
    $rc = 5;
    fprintf(STDERR, "ERROR: Unexpected fgets() fail (rc=$rc).\n");
    return array($rc, $aOratab);
  }
  fclose($fh);

  return array($rc, $aOratab);
}

// ---------------------------------------------------------------------
function getAgents( $aOratab )
// ---------------------------------------------------------------------
{
  $rc = 0;
  $aAgents = array();

  foreach ( $aOratab as $line ) {

    // Match line with agent and Dummy
    // There are possibly several agents
    if ( preg_match('/^agent.*:D$/', $line) ) {
      $a = explode(':', $line);
      array_push($aAgents,
        array( 'name' => $a[0]
             , 'ORACLE_HOME' => $a[1]
             , 'type' => $a[2]
             )
      );
    }
  }

  // No agent found
  if ( count($aAgents) == 0 ) {
    $rc = 6;
  }

  return array($rc, $aAgents);
}

// ---------------------------------------------------------------------
function startAgent( $aAgent )
// ---------------------------------------------------------------------
{
  $rc = 0;
  $msg = '';

  $emctl = $aAgent['ORACLE_HOME'] . '/bin/emctl';
  if ( is_executable($emctl) ) {
    $cmd = $emctl . ' start agent';
    $stdout = exec($cmd, $output, $rc);
  }
  else {
    fprintf(STDERR, "ERROR: $emctl is not executable (rc=$rc).\n");
    $rc = 10;
  }

  return array($rc, $msg);
}

// ---------------------------------------------------------------------
function stopAgent( $aAgent )
// ---------------------------------------------------------------------
{
  $rc = 0;
  $msg = '';

  $emctl = $aAgent['ORACLE_HOME'] . '/bin/emctl';
  if ( is_executable($emctl) ) {
    $cmd = $emctl . ' stop agent';
    $stdout = exec($cmd, $output, $rc);
  }
  else {
    fprintf(STDERR, "ERROR: $emctl is not executable (rc=$rc).\n");
    $rc = 9;
  }

  return array($rc, $msg);
}

// ---------------------------------------------------------------------
function getAgentStatus( $aAgent )
// ---------------------------------------------------------------------
{
  $rc = 0;
  $msg = '';

  $emctl = $aAgent['ORACLE_HOME'] . '/bin/emctl';
  if ( is_executable($emctl) ) {
    $cmd = $emctl . ' status agent';
    $stdout = exec($cmd, $output, $rc);
  }
  else {
    $rc = 1;
  }

  // Agent is Running and Ready
  $state = '';
  if ( $rc == 0 ) {
    $state = 'up';
  }
  // Agent is Not Running
  else {
    $rc = 3;
    $state = 'down';
  }
  printf("Agent %-12s: %-7s %s\n", $aAgent['name'], $state, $aAgent['ORACLE_HOME']);

  return array($rc, $msg);
}

// ---------------------------------------------------------------------
// MAIN
// ---------------------------------------------------------------------

$rc = 0;

$gMyName = basename($argv[0]);

if ( $argc == 1 ) {
  $option   = 'status';
  $instance = '';
}
elseif ( $argc == 2 ) {
  $option   = $argv[1];
  $instance = '';
}
elseif ( $argc == 3 ) {
  $option   = $argv[1];
  $instance = $argv[2];
}
else {
  $rc = 7;
  printUsage();
  exit($rc);
}

// Check values
if ( ($option == 'start') || ($option == 'stop') ) {
  if ( $instance == '' ) {
    $rc = 8;
    fprintf(STDERR, "Instance name cannot be empty (rc=$rc).\n");
    printUsage();
    exit($rc);
  }
}

list($rc, $aOratab) = getOratab($gOratab);
// print_r($aOratab);
if ( $rc != 0 ) {
  exit($rc);
}
list($rc, $aAgents) = getAgents($aOratab);
// print_r($aAgents);
if ( $rc != 0 ) {
  fprintf(STDERR, "No agent found (rc=$rc).\n");
  exit($rc);
}

if ( $option == 'status' ) {
  foreach ( $aAgents as $agent ) {
    // if instance is empty show all
    // otherwise only the wanted one
    if ( ($instance == '')
      || ($instance == $agent['name']) ) {
      list($ret, $msg) = getAgentStatus($agent);
    }
  }
}
elseif ( $option == 'start' ) {
  foreach ( $aAgents as $agent ) {
    // if instance is empty start all
    // otherwise only the wanted one
    if ( ($instance == '')
      || ($instance == $agent['name']) ) {
      list($ret, $msg) = startAgent($aAgents);
    }
  }
}
elseif ( $option == 'stop' ) {
  foreach ( $aAgents as $agent ) {
    // if instance is empty stop all
    // otherwise only the wanted one
    if ( ($instance == '')
      || ($instance == $agent['name']) ) {
      list($ret, $msg) = stopAgent($aAgents);
    }
  }
}
else {
  $rc = 2;
  fprintf(STDERR, "Option $option does not exists (rc=$rc).\n");
  printUsage();
  exit($rc);
}

?>
