#!/usr/bin/php
<?php

$rc = 0;

// Caution $_ENV variables are not be known here yet when variables_order
// does NOT contain E!!!
if ( isset($_ENV['MYENV_BASE']) ) {
  $basedir = strval($_ENV['MYENV_BASE']);
}
// We have to guess:
else {
  $basedir = dirname(dirname(__FILE__));
}

require_once($basedir . '/lib/myEnv.inc');

if ( checkMyEnvRequirements() == ERR ) {
  $rc = 235;
  exit($rc);
}

// The first is possibly a bug!!!
$lHome     = $_ENV['HOME'] . '/product';
$lHome     = '/home/mysql' . '/product';

$lDebug    = isset($_ENV['MYENV_DEBUG']) ? $_ENV['MYENV_DEBUG'] : 0;
$basedir   = $_ENV['MYENV_BASE'];

$lConfigurationFile = '/etc/myenv/myenv.conf';
if ( ! is_file($lConfigurationFile) ) {
  $rc = 234;
  print "Warning: Configuration file $lConfigurationFile does not exist!\n";
  print "         Please create or copy from $lConfigurationFile.template (rc=$rc).\n";
  exit($rc);
}

$aConfiguration = getConfiguration($lConfigurationFile);
$aDbNames = getSectionTitles($aConfiguration);

// Get available release versions

$aReleaseVersion = array();
foreach ( glob("$lHome/*", GLOB_ONLYDIR) as $dir ) {
  array_push($aReleaseVersion, extractVersion($dir));
}
$aReleaseVersion = array_unique($aReleaseVersion, SORT_REGULAR);

if ( $lDebug != '' ) {
  var_dump($aReleaseVersion);
}

// Get version of each instance
foreach ( $aConfiguration as $db => $value ) {

  if ( $db != 'default' ) {
    $aConfiguration[$db]['version'] = extractVersion($aConfiguration[$db]['basedir']);
  }
}

// Get number of columns of screen:
$lNumberOfColumns = trim(`tput cols`);

// Releases does not make sense anymore with all the differnce forks
//print "\n";
//print "Releases : " . implode(' ', $aReleaseVersion) . "\n";
print "\n";

// Display up and down instances

$aUp   = array();
$aDown = array();
foreach ( $aDbNames as $db ) {

  if ( count($aConfiguration[$db]) == 0 ) {
    $rc = 239;
    print "ERROR #$rc\n";
    continue;
  }

  $ret = checkDatabase($aConfiguration[$db]);

  if ( $ret != 0 ) {
    $aDown[$db] = "$db (" . $aConfiguration[$db]['version'] . ")";
  }
  else {
    $aUp[$db]   = "$db (" . $aConfiguration[$db]['version'] . ")";
  }
}

if ( $lDebug != '' ) {
  var_dump($aUp);
  var_dump($aDown);
}

// Print Up line
$cnt = 1;
foreach ( split("\n", wordwrap(implode(' ', $aUp), $lNumberOfColumns-12)) as $line ) {

  if ( $cnt == 1 ) {
    print "Up       : " . $line . "\n";
  }
  else {
    print "           " . $line . "\n";
  }
  $cnt++;
}
print "\n";

// Print Down line
$cnt = 1;
foreach ( split("\n", wordwrap(implode(' ', $aDown), $lNumberOfColumns-12)) as $line ) {

  if ( $cnt == 1 ) {
    print "Down     : " . $line . "\n";
  }
  else {
    print "           " . $line . "\n";
  }
  $cnt++;
}
print "\n";

foreach ( $aDbNames as $db ) {

  $aSchema = getSchemaNames($aConfiguration[$db]['datadir']);
  $tohide = '';

  // hide schema, e.g mysql, ndbinfo, test, performance_schema, pbxt
  if ( array_key_exists('hideschema', $aConfiguration[$db]) ) {

    foreach ( explode(',', $aConfiguration[$db]['hideschema']) as $tohide ) {
      unset($aSchema[array_search($tohide, $aSchema)]);
    }
  }

  printf("%-24s (%5d) : %s\n", $db, $aConfiguration[$db]['port'], implode(' ', $aSchema));
}
print "\n";


// Interface/hook  for customer scripts/plugins

debug('Plugins to execute:');
$cnt = 0;

$lMyNameBase = basename($argv[0], '.php');
foreach ( glob($basedir . '/plg/' . $lMyNameBase . '/*') as $plugin ) {

  debug(' ' . $plugin);
  if ( is_executable($plugin) !== TRUE ) {
    print "ERROR: $plugin is NOT executable.\n";
  }
  else {

    $cmd = $plugin;
    exec($cmd, $output, $ret);
    foreach ( $output as $line ) {
      print "$line\n";
    }

    if ( $ret != 0 ) {
      $rc = $ret;
    }
  }
  $cnt++;
}
if ( $cnt > 0 ) {
  print "\n";
}

exit($rc);
?>
