#!/usr/bin/php
<?php

$rc = 0;

if ( $argc != 6 + 1 ) {
  $rc = 3;
  print "Not enough arguments (rc=$rc).\n";
  exit($rc);
}

// print $argc . "\n";
// var_dump($argv);

$pUser     = $argv[1];
$pPassword = $argv[2];
$pHost     = $argv[3];
$pPort     = $argv[4];
$pSchema   = $argv[5];
$pTable    = $argv[6];
$pSocket   = '/tmp/mysql-33006.sock';

$mysqli = new mysqli($pHost, $pUser, $pPassword, null, $pPort, $pSocket);

if ( mysqli_connect_error() ) {
  $rc = 1;
  printf("ERROR: Connect failed: (%d) %s (rc=$rc).\n", mysqli_connect_errno(), mysqli_connect_error());
  exit($rc);
}
$mysqli->query('SET NAMES utf8');

$sql = sprintf("
SELECT partition_name, MAX(partition_ordinal_position) AS ptn
  FROM information_schema.partitions
 WHERE table_schema = '%s'
   AND table_name = '%s'
   AND partition_name IS NOT NULL
 GROUP BY partition_name
 ORDER BY ptn DESC
LIMIT 1", $pSchema, $pTable);

// print $sql . "\n";


if ( ! $result = $mysqli->query($sql) ) {
  $rc = 2;
  print "ERROR: Invalid query: $sql, " . $mysqli->error . " (rc=$rc)\n";
  exit($rc);
}
$record = $result->fetch_array(MYSQLI_ASSOC);
// var_dump($record);


# Do some calculations
$ts  = date('Y-m-d') . ' 00:00:00';
$ptn = 'p' . date('Y') . '_kw' . date('W');

$sql = sprintf("
ALTER TABLE %s.%s
REORGANIZE PARTITION %s
INTO (
  PARTITION %s VALUES LESS THAN (unix_timestamp('%s'))
, PARTITION %s VALUES LESS THAN (MAXVALUE)
)", $pSchema, $pTable, $record['partition_name'], $record['partition_name'], $ts, $ptn);

print $sql . "\n";

if ( ! $mysqli->query($sql) ) {
  $rc = 4;
  printf("ERROR: %s %s : %s (rc=$rc).\n", $mysqli->sqlstate, $mysqli->errno, $mysqli->error);
}

$mysqli->close();
exit($rc);

?>
