#!/usr/bin/php
<?php

$rc = 0;

$to      = '"FromDual Support" <support@fromdual.com>';
$headers = 'From: "Server" <admin@server.xxx.com>' . PHP_EOL
         . 'X-Mailer: PHP-' . phpversion() . PHP_EOL;

$lServer   = '127.0.0.1';
$lUser     = 'root';
$lPassword = '';
$lDatabase = '';
$lPort     = 3306;
$lSocket   = null;

# Send only test mail
if ( isset($argv[1]) && ($argv[1] == 'test') ) {

  $subject = 'MySQL Slave Monitoring test. Status: OK';
  $message = 'MySQL Slave monitoring works.' . PHP_EOL;

  echo $subject . "\n";
  echo $message . "\n";
  if ( mail($to, $subject, $message, $headers) ) {
    $rc = 0;
    echo "Mail success.\n";
  }
  else {
    $rc = 1;
    echo "Mail failed.\n";
  }
  exit($rc);
}
else {
  echo "Slave works.\n";
}

# Here starts the MySQL part

$dbh = mysqli_connect($lServer, $lUser, $lPassword, $lDatabase, $lPort, $lSocket);

// This error is so serious that we do not return at all!
if ( ! $dbh ) {

  $rc = 1;
  $subject = 'MySQL Slave Monitoring. Status: ERROR';
  $message = "Read connection failed: " . mysqli_connect_error() . PHP_EOL;

  echo $subject . "\n";
  echo $message . "\n";
  if ( mail($to, $subject, $message, $headers) ) {
    echo "Mail success.\n";
  }
  else {
    echo "Mail failed.\n";
  }
  exit($rc);
}

$dbh->query('SET CHARACTER SET utf8');

$sql = 'SHOW SLAVE STATUS';
if ( ! $result = $dbh->query($sql) ) {
  $rc = 1;
  echo "ERROR: Invalid query: $sql, " . $dbh->error . "\n";
  exit($rc);
}
$record = $result->fetch_array(MYSQLI_ASSOC);
# var_dump($record);

# Either IO or SQL Thread is not running!
if ( ($record['Slave_IO_Running'] != 'Yes') || ($record['Slave_SQL_Running'] != 'Yes') ) {

  $subject = 'MySQL Slave Monitoring. Status: ERROR';
  $message = 'MySQL Replication has a problem.' . PHP_EOL
           . 'Error is ' . $record['Last_Errno'] . ' / ' . $record['Last_Error'] . PHP_EOL
           . 'Last_SQL_Error: ' . $record['Last_SQL_Errno'] . ' / ' . $record['Last_SQL_Error'] . PHP_EOL
           . 'Last_IO_Error: ' . $record['Last_IO_Errno'] . ' / ' . $record['Last_IO_Error'] . PHP_EOL;

  echo $subject . "\n";
  echo $message . "\n";
  if ( mail($to, $subject, $message, $headers) ) {
    $rc = 0;
    echo "Mail success.\n";
  }
  else {
    $rc = 1;
    echo "Mail failed.\n";
  }
  exit($rc);
}

$dbh->close();
exit($rc);

?>
