#!/bin/bash
#
# /root/mysql_bin_backup.sh
#

export PATH=/home/mysql/product/xtrabackup/bin:$PATH
INNOBACKUPEX=$(which innobackupex)
BACKUP_DIR=/backup/mysql_backup_$(date '+%Y-%m-%d_%H-%M-%S')
USER=root
PASSWORD=abcdrs3
PARALLEL=2
MYCNF="/home/mysql/data/mysql-5.5.27/my.cnf"

# Backup phase
cmd="$INNOBACKUPEX --defaults-file=$MYCNF --user=$USER --password=$PASSWORD --use-memory=512M --safe-slave-backup --parallel=$PARALLEL $BACKUP_DIR --no-timestamp"
echo $cmd
eval $cmd
if [ $? -ne 0 ] ; then
  echo "Error in prepare phase."
  exit $?
fi

# Prepare phase
cmd="$INNOBACKUPEX --apply-log --use-memory=512M $BACKUP_DIR"
echo $cmd
eval $cmd
if [ $? -ne 0 ] ; then
  echo "Error in apply phase."
  exit $?
fi

# Copy my.cnf
cmd="cp $MYCNF $BACKUP_DIR"
echo $cmd
eval $cmd
if [ $? -ne 0 ] ; then
  echo "Error in my.cnf copy phase."
  exit $?
fi

# pbzip
cmd="cd $BACKUP_DIR && tar cf $BACKUP_DIR.tar.bz2 --use-compress-prog=pbzip2 . && cd .."
echo $cmd
eval $cmd
if [ $? -ne 0 ] ; then
  echo "Error in compress phase."
  exit $?
fi

# Move to tape location
cmd="mv $BACKUP_DIR.tar.bz2 /tmp"
echo $cmd
eval $cmd
if [ $? -ne 0 ] ; then
  echo "Error in move to tape location phase."
  exit $?
fi

