#!/usr/bin/php
<?php

$rc = 0;

if ( $argc != 7 + 1 ) {
  $rc = 3;
  print "Not enough arguments (rc=$rc).\n";
  exit($rc);
}

// print $argc . "\n";
// var_dump($argv);

$pUser     = $argv[1];
$pPassword = $argv[2];
$pHost     = $argv[3];
$pPort     = $argv[4];
$pSchema   = $argv[5];
$pTable    = $argv[6];
$pNumber   = $argv[7];
$pSocket   = '/tmp/mysql-33006.sock';

$mysqli = new mysqli($pHost, $pUser, $pPassword, null, $pPort, $pSocket);

if ( mysqli_connect_error() ) {
  $rc = 1;
  printf("ERROR: Connect failed: (%d) %s (rc=$rc).\n", mysqli_connect_errno(), mysqli_connect_error());
  exit($rc);
}
$mysqli->query('SET NAMES utf8');

$sql = sprintf("
SELECT partition_name
  FROM information_schema.partitions
 WHERE table_schema = '%s'
   AND table_name = '%s'
   AND partition_name IS NOT NULL
 ORDER BY partition_ordinal_position DESC
 LIMIT %d, 10", $pSchema, $pTable, $pNumber);
// print $sql . "\n";

if ( ! $result = $mysqli->query($sql) ) {
  $rc = 2;
  print "ERROR: Invalid query: $sql, " . $mysqli->error . " (rc=$rc)\n";
  exit($rc);
}

while ( $record = $result->fetch_array(MYSQLI_ASSOC) ) {

  // var_dump($record);

  $sql = sprintf("
ALTER TABLE %s.%s
DROP PARTITION %s", $pSchema, $pTable, $record['partition_name']);

  print $sql . "\n";

  if ( ! $mysqli->query($sql) ) {
    $rc = 4;
    printf("ERROR: %s %s : %s (rc=$rc).\n", $mysqli->sqlstate, $mysqli->errno, $mysqli->error);
  }
}

$mysqli->close();
exit($rc);

?>
