#!/bin/bash -eu

#
# /etc/mysql/conf.d/wsrep.cnf
#
# [mysqld]
# wsrep_notify_cmd = /usr/local/bin/block_galera_node.sh
#
#
# /etc/sudoers
#
#includedir /etc/sudoers.d
#
# /etc/sudoers.d/mysql (chmod 0440)
#
# mysql ALL = (root) NOPASSWD: /sbin/iptables
#

LOG='/tmp/block_galera_node.log'
DATE=$(date '+%Y-%m-%d %H:%M:%S')
STATUS=''

rc=0

function rule_exists()
{
  # REJECT     tcp  --  anywhere             anywhere             tcp dpt:mysql reject-with icmp-port-unreachable

  cmd="sudo /sbin/iptables --list | grep -c 'REJECT .* tcp dpt:mysql reject-with icmp-port-unreachable'"
  echo "$cmd" >>$LOG
  eval "$cmd"
}


echo $DATE >>$LOG

while [ $# -gt 0 ] ; do

  case $1 in
  --status)
    STATUS=$2
    shift
    ;;
  --uuid)
    CLUSTER_UUID=$2
    shift
    ;;
  --primary)
    PRIMARY=$2
    shift
    ;;
  --index)
    INDEX=$2
    shift
    ;;
  --members)
    MEMBERS=$2
    shift
    ;;
  esac
  shift
done

# echo $* >> $LOG
echo 'status: '$STATUS >> $LOG
if [ "$STATUS" == '' ] ; then
  echo "No status defined." >> $LOG
  exit 1
fi

# Undefined means node is shutting down
# Synced means node is ready again
if [ "$STATUS" == "Synced" ] ; then

  if [ `rule_exists` -eq 1 ] ; then
    cmd="sudo /sbin/iptables --delete INPUT --protocol tcp --dport mysql -j REJECT"
    echo $cmd >>$LOG
    eval $cmd >>$LOG 2>&1
    rc=$?
  fi
else
  # Check if rule exists
  # iptables exits with exit_group(1) which also terminates this script
  # which is possibly a bit overkill. So we do not use the --check but
  # a grep as suggested otherwise...
  # cmd="sudo /sbin/iptables --check INPUT --protocol tcp --dport mysql -j REJECT"
  if [ `rule_exists` -ne 1 ] ; then
    cmd="sudo /sbin/iptables --append INPUT --protocol tcp --dport mysql -j REJECT"
    echo $cmd >>$LOG
    eval $cmd >>$LOG 2>&1
    rc=$?
  else
    echo "Rule already exists." >> $LOG
  fi
fi

echo "ret=$rc" >>$LOG
exit $rc
