#!/usr/bin/php
<?php

$rc = 0;

// Caution $_ENV variables are not be known here yet when variables_order
// does NOT contain E!!!
if ( isset($_ENV['MYENV_BASE']) ) {
  $basedir = strval($_ENV['MYENV_BASE']);
}
// We have to guess:
else {
  $basedir = dirname(dirname(__FILE__));
}

require_once($basedir . '/lib/myEnv.inc');

if ( checkMyEnvRequirements() == 2 ) {
  $rc = 240;
  exit($rc);
}

$PHP        = "/usr/bin/php";
$lDebug     = isset($_ENV['MYENV_DEBUG']) ? strval($_ENV['MYENV_DEBUG']) : '';
$MyBasename = basename(__FILE__, '.php');

if ( $lDebug ) {
  echo "basename = $MyBasename\n";
}

if ( $basedir == '' ) {
  echo "Basedir is not set.\n";
  $rc = 241;
  exit($rc);
}

if ( $lDebug ) {
  echo "MYENV_BASE = $basedir\n";
}

$LogFile    = "$basedir/log/$MyBasename.log";
$handle = fopen($LogFile, 'a');
if ( ! $handle ) {
  echo "Cannot log to file $LogFile\n";
  $rc = 242;
  exit($rc);
}

switch ( $argv[1] ) {
case 'start':
  fputs($handle, date("Y-m-d H:i:s") . " Starting $MyBasename\n");
  // find all databases
  $databases = printStartingDatabases();
  if ( $databases == '' ) {
    fputs($handle, date("Y-m-d H:i:s") . " No databases to start.\n");
  }
  else {
    fputs($handle, date("Y-m-d H:i:s") . " Starting databases: " . implode(' ', $databases) . "\n");

    foreach ( $databases as $db ) {
      fputs($handle, date("Y-m-d H:i:s") . " Starting database: $db\n");
      $stdout = array();
      exec("$PHP -f $basedir/bin/database.php $db " . $argv[1] . " 2>&1", &$stdout, &$rc);
      fputs($handle, date("Y-m-d H:i:s") . ' ' . implode("\n", $stdout) . "\n");
    }
    // Should be done for all
    fputs($handle, date("Y-m-d H:i:s") . " Finished $MyBasename (rc=$rc).\n");
  }
break;
case 'stop':

  fputs($handle, date("Y-m-d H:i:s") . " Stopping $MyBasename\n");
  // find all started databases and stop them (better to stop all started db,
  // that are still running or even all running dbs?)
  $databases = printStartingDatabases();
  if ( $databases == '' ) {
    fputs($handle, date("Y-m-d H:i:s") . " No databases to start.\n");
  }
  else {
    fputs($handle, date("Y-m-d H:i:s") . " Stopping databases: " . implode(' ' , $databases) . "\n");
    foreach ( $databases as $db ) {
      fputs($handle, date("Y-m-d H:i:s") . " Stopping database: $db\n");
      $stdout = array();
      exec("$PHP -f $basedir/bin/database.php $db " . $argv[1] . " 2>&1", &$stdout, &$rc);
      fputs($handle, date("Y-m-d H:i:s") . ' ' . implode("\n", $stdout) . "\n");
    }
    // Should be done for all
    fputs($handle, date("Y-m-d H:i:s") . " Finished $MyBasename (rc=$rc).\n");
  }
break;
default:
  fputs($handle, date("Y-m-d H:i:s") . " Usage: $MyBasename {start|stop}\n");
}

fclose($handle);
exit($rc);

?>
