package writeDataToCacheFile;

# %LICENSE%

use strict;
use warnings;
use File::stat;

# check if HTTP::Request::Common and LWP::Simple; exists and if not do a warning!!!

# http://www.perl.com/pub/2002/08/20/perlandlwp.html
# http://perl.active-venture.com/lib/HTTP/Request/Common.html
# http://stackoverflow.com/questions/3836526/how-do-i-send-post-data-with-lwp

# use LWP 5.64;
# use HTTP::Request::Common qw{ POST };
# use Getopt::Long;
# use File::Basename;

use FromDualMySQLagent ':stooges';

sub writeDataToCacheFile
{
  my $values_ref = shift;
  my $list_ref = shift;

  my $rc = 0;

  if ( $main::gParameter{'Debug'} >= INFO ) { &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, INFO, '      ' . (caller(0))[3]); }

  # Check if Cache File exists, if not create it
  if ( ! -e $main::gParameter{'CacheFile'} ) {

    $rc = &FromDualMySQLagent::clearCacheFile($main::gParameter{'CacheFile'});
    if ( $rc != 0 ) {
      $rc = 1905;
      &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, ERR, " Cannot clear file $main::gParameter{'CacheFile'} (rc=$rc)!");
      return $rc;
    }
  }
  # If ChacheFile exists, check that it is writable
  else {

    if ( ! -w $main::gParameter{'CacheFile'} ) {
      $rc = 1904;
      &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, ERR, " Cannot write to file $main::gParameter{'CacheFile'} (rc=$rc)!");
      return $rc;
    }
  }

  # We had some cases on our systems where a too big cache files let
  # the system collapse or at least it was not sending data.
  # Thus check for size ( > 10M) and shrink file before
  my $size = stat($main::gParameter{'CacheFile'})->size;
  my $max_size = 10 * 1024 * 1024;
  if ( $size > $max_size ) {
    $rc = 1901;
    # truncate did not help. Because we had good experience with rm we
    # use unlink here
    unlink $main::gParameter{'CacheFile'};
    &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, WARN, "    Cache file $main::gCacheFile is too big ($size). Removing it (rc=$rc).");
  }

  my $lDomain = $main::gParameter{'Domain'};
  # some stuff in server module requires no domain
  if ( $lDomain ne '' ) {
    $lDomain .= '.';
  }
  my $lTimestamp = time();

  if ( $main::gParameter{'TimeShift'} != 0.0 ) {
    $lTimestamp = $lTimestamp + int($main::gParameter{'TimeShift'} * 3600);
  }

  # Write data to cache file first. We assume this is more efficent than
  # calling zabbix sender zillions of times
  if ( ! open(DAT, ">>$main::gParameter{'CacheFile'}") ) {
    $rc = 1900;
    &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, ERR, "    Cannot open file $main::gCacheFile (rc=$rc).\n$!\n");
    return $rc;
  }

  foreach my $key ( keys %$values_ref ) {

    # check if key is in ToSend array
    if ( grep $_ eq $key, @$list_ref ) {
      printf(DAT "%s %s %d %s\n", $main::gParameter{'Hostname'}, $lDomain.$key, $lTimestamp, $$values_ref{$key});
      if ( $main::gParameter{'Debug'} >= DBG ) { &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, DBG, '        ' . sprintf("%s %s %d %s", $main::gParameter{'Hostname'}, $lDomain.$key, $lTimestamp, $$values_ref{$key})); }
    }
  }   # foreach
  close(DAT);
  return $rc;
}

1;
__END__
