package uploadData;

#
# Copyright (C) 2010, 2011, 2012 FromDual GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 2 of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.
# If not, see <http://www.gnu.org/licenses/>.
#

use strict;
use warnings;

use LWP 5.64;
use HTTP::Request::Common qw{ POST };
use File::stat;

use FromDualMySQLagent ':stooges';

sub uploadData
{
  my $rc = 0;

  if ( $main::gParameter{'Debug'} >= INFO ) { &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, INFO, '      ' . (caller(0))[3]); }

  if ( ! -r $main::gParameter{'CacheFile'} ) {
    $rc = 1404;
    &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, ERR, "Cannot read file $main::gParameter{'CacheFile'} (rc=$rc).");
    return $rc;
  }

  # We had some cases on our systems where a too big cache files let
  # the system collapse or at least it was not sending data.
  # Thus check for size ( > 10M) and shrink file before
  my $size = stat($main::gParameter{'CacheFile'})->size;
  my $max_size = 10 * 1024 * 1024;
  if ( $size > $max_size ) {
    $rc = 1405;
    # truncate did not help. Because we had good experience with rm we
    # use unlink here
    unlink $main::gParameter{'CacheFile'};
    &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, WARN, "    Cache file $main::gCacheFile is too big ($size). Removing it (rc=$rc).");
  }

  my $browser = LWP::UserAgent->new;
  # Some customers use Proxies for sending data to us
  $browser->env_proxy;

  ### The following command does sometimes abort
  ### thus we do not remove the lock file!!!
  ### no clue why! It can happen at least in the modules slave and mpm
  ### Could be caused by zabbix_server timeout after 10 seconds because
  ### it happens only with zabbix_server call but not with crontab!

  my $response = $browser->request(POST $main::gParameter{'Url'},
    Content_Type => 'form-data',
    Content      => [ hash      => $main::gParameter{'Hash'},
                      filename  => [$main::gParameter{'CacheFile'}],
                    ]);   # ->as_string()

  if ( ! $response->is_success ) {
    $rc = 1401;
    &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, ERR, '      ' . $main::gParameter{'Url'} . " error: " . $response->status_line . " (rc=$rc)");
    return $rc;
  }

  if ( $response->content_type ne 'text/html' ) {
    $rc = 1402;
    &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, ERR, "      Weird content type at " . $main::gParameter{'Url'} . ": " . $response->content_type . " (rc=$rc)");
    return $rc;
  }

  # Data loaded
  if ( $response->content =~ /Data loaded successful/ ) {
    if ( $main::gParameter{'Debug'} == DBG ) { &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, DBG, "        Data loaded."); }
  }
  # Data load failed
  else {
    $rc = 1403;
    &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, ERR, "      Data upload failed. (rc=$rc)");
    &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, ERR, '      ' . $response->content);
    # Do clean-up already here because of problem from 2012-03-14
    &FromDualMySQLagent::clearCacheFile($main::gParameter{'CacheFile'});
    return $rc;
  }

  if ( $main::gParameter{'Debug'} >= INFO ) { &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, INFO, "      Data uploaded successfully."); }
  &FromDualMySQLagent::clearCacheFile($main::gParameter{'CacheFile'});

  return $rc;
}

1;
__END__
