package sendData;

# %LICENSE%

use strict;
use warnings;

# check if HTTP::Request::Common and LWP::Simple; exists and if not do a warning!!!

# http://www.perl.com/pub/2002/08/20/perlandlwp.html
# http://perl.active-venture.com/lib/HTTP/Request/Common.html
# http://stackoverflow.com/questions/3836526/how-do-i-send-post-data-with-lwp

# use LWP 5.64;
# use HTTP::Request::Common qw{ POST };
# use Getopt::Long;
# use File::Basename;

use FromDualMySQLagent ':stooges';
use writeDataToCacheFile;
use sendCachedData;

sub sendData
{
  my $values_ref = shift;
  my $list_ref = shift;

  my $rc = 0;

  if ( $main::gParameter{'Debug'} >= INFO ) { &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, INFO, '    ' . (caller(0))[3]); }

  &writeDataToCacheFile::writeDataToCacheFile($values_ref, $list_ref);

  # MPM can be run in 2 modes now: locally or MaaS
  # We run MPM locally
  if ( lc($main::gParameter{'MaaS'}) ne 'on' ) {

    $rc = &FromDualMySQLagent::checkConnectionToZabbixServer($main::gParameter{'ZabbixServer'}, $main::gParameter{'ZabbixServerPort'}, $main::gParameter{'Hostname'});

    # Connection to zabbix server seems OK
    if ( $rc == 0 ) {

      if ( $main::gParameter{'Debug'} == DBG ) { &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, DBG, "      Connection to zabbix server seems OK."); }
      $rc = &sendCachedData::sendCachedData($main::gParameter{'ZabbixServer'}, $main::gParameter{'ZabbixServerPort'});
    }
    # No success connecting to zabbix server
    else {
      $rc = 1305;
      &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, WARN, '      ' . $main::gParameter{'ZabbixServer'}. ', ' . $main::gParameter{'ZabbixServerPort'} . ', ' . $main::gParameter{'Hostname'});
      &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, WARN, "      Connection to zabbix server failed (rc=$rc)!");
    }
  }
  # We run MPM as MaaS
  else {

    if ( (lc($main::gParameter{'Methode'}) eq 'http')
      || (lc($main::gParameter{'Methode'}) eq 'https')
       ) {
        $rc = &uploadData::uploadData();
    }
    else {
      $rc = 1313;
      &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, ERR, '      Could NOT upload data to MaaS Server. Unknown methode: ' . $main::gParameter{'Methode'} . " (rc=$rc).");
    }
  }

  return $rc;
}

1;
__END__
