package sendCachedData;

# %LICENSE%

use strict;
use warnings;

use FromDualMySQLagent ':stooges';

# check if HTTP::Request::Common and LWP::Simple; exists and if not do a warning!!!

# http://www.perl.com/pub/2002/08/20/perlandlwp.html
# http://perl.active-venture.com/lib/HTTP/Request/Common.html
# http://stackoverflow.com/questions/3836526/how-do-i-send-post-data-with-lwp

use LWP 5.64;
use HTTP::Request::Common qw{ POST };
use Getopt::Long;
use File::Basename;
use File::Which;
use FromDualMySQLagent ':stooges';

sub sendCachedData
{
  my $pServer = $_[0];
  my $pPort   = $_[1];

  my $rc = 0;

  if ( $main::gParameter{'Debug'} >= INFO ) { &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, INFO, '    ' . (caller(0))[3]); }
  if ( $main::gParameter{'Debug'} == DBG ) { &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, DBG, "      Sending cache file to zabbix server."); }

  # File exists and is NOT empty
  if ( -f $main::gParameter{'CacheFile'} ) {

    if ( $main::gParameter{'Debug'} == DBG ) { &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, DBG, "      Cache file found."); }

    my $exe = 'zabbix_sender';
    $exe = which($exe);
    if ( ! defined($exe) ) {
      $rc = 1318;
      &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, ERR, "Cannot find program $exe.");
    }

    my $cmd = "$exe --zabbix-server $pServer --port $pPort --input-file $main::gParameter{'CacheFile'} --with-timestamps";
    if ( $main::gParameter{'Debug'} == DBG ) {
      $cmd .= ' -vv';
      &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, DBG, "      $cmd");
    }

    if ( $main::gParameter{'Debug'} == DBG ) {
      system("$cmd >>" . $main::gParameter{'LogFile'} . " 2>&1");
    }
    else {
      system("$cmd >/dev/null 2>&1");
    }
    my $ret = $?;
    $rc = 1301;
    if ( $main::gParameter{'Debug'} == DBG ) { &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, DBG, "      (ret=$ret / rc=$rc)."); }

		if ( (($ret >> 8) == 0)
		  || (($ret >> 8) == 2) ) {
      # Do not delete Cache File but just set it back to zero again
      &FromDualMySQLagent::clearCacheFile($main::gParameter{'CacheFile'});
    }
    else {
      &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, ERR, "      Load of cache file failed. rc=$rc");
    }
  }
  else {
    if ( $main::gParameter{'Debug'} == DBG ) { &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, DBG, "      No cache file " . $main::gParameter{'CacheFile'} . " found."); }
  }
}

1;
__END__
