package SecurityInformation;

# %LICENSE%

use strict;
use warnings;

# use File::Copy;
# use Digest::SHA;
# use File::Which;

use FromDualMySQLagent ':stooges';
use writeDataToCacheFile;

# ---------------------------------------------------------------------
sub getSecurityInformation
# ---------------------------------------------------------------------
{
  my $dbh = shift;
  my $status_ref = shift;

  my $rc = 0;

  my ($sql, $sth);

  if ( $main::gParameter{'Debug'} >= INFO ) { &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, INFO, '    ' . (caller(0))[3]); }

  # Root user from remote
  chomp(my $hostname = `hostname`);
  $sql = 'SELECT GROUP_CONCAT(CONCAT(user, "@", host) SEPARATOR ", ") AS user FROM mysql.user WHERE user = "root" AND host NOT IN ("localhost", "127.0.0.1", "::1", "' . $hostname . '")';
  $sth = $dbh->prepare($sql);
  if ( $sth->execute() ) {
    if ( my $ref = $sth->fetchrow_hashref() ) {
      $$status_ref{'root_from_remote'} = defined($ref->{'user'}) ? $ref->{'user'} : "''";
    }
    $sth->finish();
  }

  # Empty user
  $sql = 'SELECT GROUP_CONCAT(CONCAT(user, "@", host) SEPARATOR ", ") AS user FROM mysql.user WHERE user = ""';
  $sth = $dbh->prepare($sql);
  if ( $sth->execute() ) {
    if ( my $ref = $sth->fetchrow_hashref() ) {
      $$status_ref{'empty_user'} = defined($ref->{'user'}) ? $ref->{'user'} : "''";
    }
    $sth->finish();
  }

  # Test database
  $sql = 'SELECT GROUP_CONCAT(schema_name SEPARATOR ", ") AS "database" FROM information_schema.schemata WHERE schema_name like "test%"';
  $sth = $dbh->prepare($sql);
  if ( $sth->execute() ) {
    if ( my $ref = $sth->fetchrow_hashref() ) {
      $$status_ref{'test_database'} = defined($ref->{'database'}) ? $ref->{'database'} : "''";
    }
    $sth->finish();
  }

  # User with GRANT privilege
  $sql = 'SELECT GROUP_CONCAT(CONCAT(user, "@", host) SEPARATOR ", ") AS user FROM mysql.user WHERE user != "root" AND grant_priv = "Y"';
  $sth = $dbh->prepare($sql);
  if ( $sth->execute() ) {
    if ( my $ref = $sth->fetchrow_hashref() ) {
      $$status_ref{'user_with_grant_privilege'} = defined($ref->{'user'}) ? $ref->{'user'} : "''";
    }
    $sth->finish();
  }

  # User with SUPER privilege
  $sql = 'SELECT GROUP_CONCAT(CONCAT(user, "@", host) SEPARATOR ", ") AS user FROM mysql.user WHERE user != "root" AND super_priv = "Y"';
  $sth = $dbh->prepare($sql);
  if ( $sth->execute() ) {
    if ( my $ref = $sth->fetchrow_hashref() ) {
      $$status_ref{'user_with_super_privilege'} = defined($ref->{'user'}) ? $ref->{'user'} : "''";
    }
    $sth->finish();
  }

  # User with CREATE USER privilege
  $sql = 'SELECT GROUP_CONCAT(CONCAT(user, "@", host) SEPARATOR ", ") AS user FROM mysql.user WHERE user != "root" AND create_user_priv = "Y"';
  $sth = $dbh->prepare($sql);
  if ( $sth->execute() ) {
    if ( my $ref = $sth->fetchrow_hashref() ) {
      $$status_ref{'user_with_create_user_privilege'} = defined($ref->{'user'}) ? $ref->{'user'} : "''";
    }
    $sth->finish();
  }

  if ( $main::gParameter{'Debug'} == DBG ) {
    &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, DBG, '    Security Information:');
    foreach my $key ( keys %$status_ref ) {
      &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, DBG, "      key: $key, value: $$status_ref{$key}");
    }
  }

  return $rc;
}

1;
__END__
