package FromDualMySQLslave;

#
# Copyright (C) 2010, 2011, 2012 FromDual GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 2 of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.
# If not, see <http://www.gnu.org/licenses/>.
#

use strict;
use warnings;

use FromDualMySQLagent ':stooges';
use sendData;

sub getSlaveStatus
{
  my $dbh = shift;
  my $status_ref = shift;

  if ( $main::gParameter{'Debug'} >= INFO ) { &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, INFO, '    ' . (caller(0))[3]); }

  #       Master_Log_File:
  #   Read_Master_Log_Pos: 4
  #
  #        Relay_Log_File: master-relay-bin.000001
  #         Relay_Log_Pos: 4
  #
  # Relay_Master_Log_File:
  #   Exec_Master_Log_Pos: 0
  #
  #      Slave_IO_Running: No
  #     Slave_SQL_Running: No
  #
  # Seconds_Behind_Master: NULL

  $$status_ref{'Read_Master_Log_Pos'}   = '0';
  $$status_ref{'Relay_Log_Pos'}         = '0';
  $$status_ref{'Exec_Master_Log_Pos'}   = '0';
  $$status_ref{'Slave_IO_Running'}      = '0';
  $$status_ref{'Slave_SQL_Running'}     = '0';
  $$status_ref{'Seconds_Behind_Master'} = '0';

  my $sql = 'SHOW SLAVE STATUS';
  my $sth = $dbh->prepare($sql);
  if ( $sth->execute() )
  {
    if ( my $ref = $sth->fetchrow_hashref() )
    {
      $$status_ref{'Read_Master_Log_Pos'}   = $ref->{'Read_Master_Log_Pos'};
      $$status_ref{'Relay_Log_Pos'}         = $ref->{'Relay_Log_Pos'};
      $$status_ref{'Exec_Master_Log_Pos'}   = $ref->{'Exec_Master_Log_Pos'};
      $$status_ref{'Slave_IO_Running'}      = $ref->{'Slave_IO_Running'};
      $$status_ref{'Slave_SQL_Running'}     = $ref->{'Slave_SQL_Running'};
      $$status_ref{'Seconds_Behind_Master'} = defined($ref->{'Seconds_Behind_Master'}) ? $ref->{'Seconds_Behind_Master'} : 9999;
    }
    $sth->finish();
  }

  $$status_ref{'Slave_IO_Running'} = $$status_ref{'Slave_IO_Running'} eq 'Yes' ? 1 : 0;
  $$status_ref{'Slave_SQL_Running'} = $$status_ref{'Slave_SQL_Running'} eq 'Yes' ? 1 : 0;

  if ( $main::gParameter{'Debug'} == DBG )
  {
    &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, DBG, 'Slave Status:');
    foreach my $key ( keys %$status_ref )
    {
      &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, DBG, "key: $key, value: $$status_ref{$key}");
    }
  }
}

sub processSlaveInformation
{
  my $rc = 0;

  if ( $main::gParameter{'Debug'} >= INFO ) { &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, INFO, '    ' . (caller(0))[3]); }

  my %hSlaveStatus;
  my %hGlobalVariables;

  my @aSlaveStatusToSend = (
    'Exec_Master_Log_Pos'
  , 'Read_Master_Log_Pos'
  , 'Relay_Log_Pos'
  , 'Seconds_Behind_Master'
  , 'Slave_IO_Running'
  , 'Slave_SQL_Running'
  );

  my @aGlobalVariablesToSend = (
    'read_only'
  , 'slave_skip_errors'
  , 'sync_relay_log'
  , 'sync_relay_log_info'
  );

  &FromDualMySQLagent::initValues(\%hSlaveStatus, \@aSlaveStatusToSend);
  &FromDualMySQLagent::initValues(\%hGlobalVariables, \@aGlobalVariablesToSend);

  my $dbh = &FromDualMySQLagent::getDatabaseConnection(%main::gParameter);

  if ( ! defined($dbh) ) {
    $rc = 2100;
    if ( $main::gParameter{'Debug'} >= ERR ) { &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, DBG, "    Database connection failed (rc=$rc)."); }
    return $rc;
  }

  &getSlaveStatus($dbh, \%hSlaveStatus);
  &FromDualMySQLagent::getGlobalVariables($dbh, \%hGlobalVariables);

  &FromDualMySQLagent::releaseDatabaseConnection($dbh);

  # Do some post calculations

  &sendData::sendData(\%hSlaveStatus, \@aSlaveStatusToSend);
  &sendData::sendData(\%hGlobalVariables, \@aGlobalVariablesToSend);

  return $rc;
}

1;
__END__
