package FromDualMySQLserver;

#
# Copyright (C) 2010, 2011, 2012 FromDual GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 2 of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.
# If not, see <http://www.gnu.org/licenses/>.
#

use strict;
use warnings;

use Config;

use FromDualMySQLagent ':stooges';
use sendData;

sub getNetworkInformationLinux
{
  if ( $main::gParameter{'Debug'} >= INFO ) { &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, INFO, '      ' . (caller(0))[3]); }
  my $rc = 0;

  my %aNetworkInfo;

  # Inter-|   Receive                                                |  Transmit
  #  face |bytes    packets errs drop fifo frame compressed multicast|bytes    packets errs drop fifo colls carrier compressed
  #     lo: 2776770   11307    0    0    0     0          0         0  2776770   11307    0    0    0     0       0          0
  #   eth0: 1215645    2751    0    0    0     0          0         0  1782404    4324    0    0    0   427       0          0
  # or
  #     lo:138923130045 107515369    0    0    0     0          0         0 138923130045 107515369    0    0    0     0       0          0
  #   eth0:960408648343 3436113164  267  267    0   267          0    257958 6771695068 14193375    0    0    0     0       0          0


  my $file = '/proc/net/dev';
  if ( ! open(NET, '<', $file) ) {
    $rc = 1603;
    &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, ERR, "   Cannot open file $file (rc=$rc).\n$!\n");
    return ($rc, %aNetworkInfo);
  }

  my $net = '';
  while ( <NET> ) {

    chomp($_);
    if ( $_ =~ m/^\s*(\w+)\s*:\s*(\d+)\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)$/ ) {

      $aNetworkInfo{'network[' . $1 . ',bytes_rx]'} = $2;
      $aNetworkInfo{'network[' . $1 . ',pckts_rx]'} = $3;
      $aNetworkInfo{'network[' . $1 . ',err_rx]'} = $4;
      $aNetworkInfo{'network[' . $1 . ',drop_rx]'} = $5;
      $aNetworkInfo{'network[' . $1 . ',bytes_tx]'} = $10;
      $aNetworkInfo{'network[' . $1 . ',pckts_tx]'} = $11;
      $aNetworkInfo{'network[' . $1 . ',err_tx]'} = $12;
      $aNetworkInfo{'network[' . $1 . ',drop_tx]'} = $13;
    }
  }
  close NET;

  return ($rc, %aNetworkInfo);
}

sub getCpuInformationLinux
{
  if ( $main::gParameter{'Debug'} >= INFO ) { &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, INFO, '      ' . (caller(0))[3]); }
  my $rc = 0;

  my %aCpuInfo;

  # in USER_HZ (0.01 s)
  # user mode
  # nice mode
  # system
  # idle
  # iowait
  # irq
  # softirq
  # steal
  # guest

  # This is probably wrong! We have to take 2 snapshots?

  my $file = '/proc/stat';
  if ( ! open(CPU, '<', $file) ) {
    $rc = 1604;
    &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, ERR, "   Cannot open file $file (rc=$rc).\n$!\n");
    return ($rc, %aCpuInfo);
  }
  my $cpu = '';
  while ( <CPU> ) {

    chomp;
    if ( $_ =~ m/^cpu(\d*)\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)\s*(\d+)?\s*(\d+)?\s*(\d+)?\s*(\d+)?\s*(\d+)?\s*(\d+)?$/ ) {

      if ( $1 eq '' ) {
        $cpu = 'total';
      }
      else {
        $cpu = $1;
      }
      my $v2  = defined($2) ? $2 : 0;
      my $v3  = defined($3) ? $3 : 0;
      my $v4  = defined($4) ? $4 : 0;
      my $v5  = defined($5) ? $5 : 0;
      my $v6  = defined($6) ? $6 : 0;
      my $v7  = defined($7) ? $7 : 0;
      my $v8  = defined($8) ? $8 : 0;
      my $v9  = defined($9) ? $9 : 0;
      my $v10 = defined($10) ? $10 : 0;
#       my $v11 = defined($11) ? $11 : 0;

      $aCpuInfo{'cpu[' . $cpu . ',user]'}   = $v2;
      $aCpuInfo{'cpu[' . $cpu . ',nice]'}   = $v3;
      $aCpuInfo{'cpu[' . $cpu . ',system]'} = $v4;
      $aCpuInfo{'cpu[' . $cpu . ',idle]'}   = $v5;
      $aCpuInfo{'cpu[' . $cpu . ',iowait]'} = $v6;
      $aCpuInfo{'cpu[' . $cpu . ',irq]'}    = $v7;
      $aCpuInfo{'cpu[' . $cpu . ',soft]'}   = $v8;
      $aCpuInfo{'cpu[' . $cpu . ',steal]'}  = $v9;
      $aCpuInfo{'cpu[' . $cpu . ',guest]'}  = $v10;
#       $aCpuInfo{'cpu[' . $cpu . ',unknown]'} = $v11;
    }
    elsif ( $_ =~ /^ctxt\s*(\d*)/ ) {
      $aCpuInfo{'cpu_ctxt'} = $1;
    }
    elsif ( $_ =~ /^processes\s*(\d*)/ ) {
      $aCpuInfo{'cpu_proc'} = $1;
    }
    elsif ( $_ =~ /^intr\s*(\d*)/ ) {
      $aCpuInfo{'cpu_intr'} = $1;
    }
    elsif ( $_ =~ /^procs_running\s*(\d*)/ ) {
      $aCpuInfo{'cpu_proc_r'} = $1;
    }
    elsif ( $_ =~ /^procs_blocked\s*(\d*)/ ) {
      $aCpuInfo{'cpu_proc_b'} = $1;
    }
  }
  close CPU;

  return ($rc, %aCpuInfo);
}

sub getDiskSpaceInformationLinux
{
  if ( $main::gParameter{'Debug'} >= INFO ) { &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, INFO, '      ' . (caller(0))[3]); }
  my $rc = 0;

  my $cmd = 'df -k';
  my $output = `$cmd`;

  my %aDiskSpace;

  my @aLines = split(/\n/, $output);
  foreach my $i ( 0..$#aLines ) {

    chomp($aLines[$i]);

    #   Filesystem           1K-blocks      Used Available Use% Mounted on
    #   none                   8209112       248   8208864   1% /dev
    #   none                   8215980      4164   8211816   1% /dev/shm
    #   none                   8215980       224   8215756   1% /var/run
    #   none                   8215980         0   8215980   0% /var/lock
    if ( $aLines[$i] =~ m/^none\s+\d+/ ) {
      next;
    }

    #   Filesystem           1K-blocks      Used Available Use% Mounted on
    if ( $aLines[$i] =~ m/^Filesystem\s+/ ) {
      next;
    }

    # removed, see belov
    if ( $aLines[$i] =~ m/^removed$/ ) {
      next;
    }

    # Concatenate lines
    # /dev/mapper/vg01-root
    #                      121888740  63151980  52445560  55% /
    # fas2040a:/vol/sv_os/sv_s35_os_root
    #                      5368709120 1601446272 3767262848  30% /mnt/ossv_backup
    # mgt2:/nfs_exports/s35_home_lun
    #                      123052544  68847936  47852896  59% /cyon_backup/home-backup

    if ( $aLines[$i] =~ m/^\S+$/ ) {

      $aLines[$i] .= $aLines[$i+1];
      chomp($aLines[$i]);
      $aLines[$i+1] = 'removed';
    }

    #   Filesystem           1K-blocks      Used Available Use% Mounted on
    #   /dev/sdb1            461229088 216425820 221374200  50% /
    #   /dev/sda1             62486392  45949340  16537052  74% /home/mysql/data

    if ( $aLines[$i] =~ m/(\S+)\s+(\d+)\s+(\d+)\s+(\d+)\s+\d+%\s+(.*)$/ ) {

      $aDiskSpace{'disk_space[' . $1 . ',total]'} = $2;
      $aDiskSpace{'disk_space[' . $1 . ',used]'}  = $3;
      $aDiskSpace{'disk_space[' . $1 . ',pused]'}  = ($3 / $2 * 100);
      $aDiskSpace{'disk_space[' . $1 . ',free]'}  = $4;
      $aDiskSpace{'disk_space[' . $1 . ',pfree]'}  = ($4 / $2 * 100);

      $aDiskSpace{'disk_space[' . $5 . ',total]'} = $2;
      $aDiskSpace{'disk_space[' . $5 . ',used]'}  = $3;
      $aDiskSpace{'disk_space[' . $5 . ',pused]'}  = ($3 / $2 * 100);
      $aDiskSpace{'disk_space[' . $5 . ',free]'}  = $4;
      $aDiskSpace{'disk_space[' . $5 . ',pfree]'}  = ($4 / $2 * 100);
      next;
    }

    # Show all the rest we could not parse
    if ( $main::gParameter{'Debug'} >= ERR ) { &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, INFO, '      ' . $aLines[$i]); }
    $rc = 1600;
  }

  return ($rc, %aDiskSpace);
}

sub getMemoryInformationLinux
{
  if ( $main::gParameter{'Debug'} >= INFO ) { &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, INFO, '      ' . (caller(0))[3]); }
  my %aMemory;
  my $rc = 0;

  my $file = '/proc/meminfo';
  if ( ! -r $file ) {
    $rc = 1602;
    if ( $main::gParameter{'Debug'} >= ERR ) { &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, INFO, '    ' . "Cannot read $file (rc=$rc)."); }
    return ($rc, %aMemory);

    # We could try to read free instead
    # free
    #              total       used       free     shared    buffers     cached
    # Mem:      16431968    7775540    8656428          0     392500    2607192
    # -/+ buffers/cache:    4775848   11656120
    # Swap:     19802108          0   19802108
  }

  # man proc
  # http://unixfoo.blogspot.com/2008/02/know-about-procmeminfo.html
  # vmstat -s
  #
  # MemTotal:       16431968 kB *
  # MemFree:         8655484 kB *
  # Buffers:          392512 kB *
  # Cached:          2607312 kB *
  # SwapTotal:      19802108 kB *
  # SwapFree:       19802108 kB *
  $aMemory{'vm_memory_total_kb'} = 0;
  $aMemory{'vm_memory_free_kb'} = 0;
  $aMemory{'vm_buffers_kb'} = 0;
  $aMemory{'vm_cached_kb'} = 0;
  $aMemory{'vm_swap_total_kb'} = 0;
  $aMemory{'vm_swap_free_kb'} = 0;
#   $aMemory{'vm_swap_used_kb'} = 0;
#   $aMemory{'vm_used_free_kb'} = 0;

  if ( ! open(FILE, "<", $file) ) {
    $rc = 1605;
    &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, ERR, "   Cannot open file $file (rc=$rc).\n$!\n");
    return ($rc, %aMemory);
  }

  while ( <FILE> ) {
    chomp $_;
    if ( $_ =~ m/^MemTotal:\s+(\d+)\s+kB/ ) {
      $aMemory{'vm_memory_total_kb'} = $1;
    }
    elsif ( $_ =~ m/^MemFree:\s+(\d+)\s+kB/ ) {
      $aMemory{'vm_memory_free_kb'} = $1;
    }
    elsif ( $_ =~ m/^Buffers:\s+(\d+)\s+kB/ ) {
      $aMemory{'vm_memory_buffers_kb'} = $1;
    }
    elsif ( $_ =~ m/^Cached:\s+(\d+)\s+kB/ ) {
      $aMemory{'vm_memory_cached_kb'} = $1;
    }
    elsif ( $_ =~ m/^SwapTotal:\s+(\d+)\s+kB/ ) {
      $aMemory{'vm_swap_total_kb'} = $1;
    }
    elsif ( $_ =~ m/^SwapFree:\s+(\d+)\s+kB/ ) {
      $aMemory{'vm_swap_free_kb'} = $1;
    }
  }
  close FILE;

  # Do some calculations
  $aMemory{'vm_swap_used_kb'} = $aMemory{'vm_swap_total_kb'} - $aMemory{'vm_swap_free_kb'};
  $aMemory{'vm_memory_used_kb'} = $aMemory{'vm_memory_total_kb'} - $aMemory{'vm_memory_cached_kb'} - $aMemory{'vm_memory_buffers_kb'} - $aMemory{'vm_memory_free_kb'};

  return ($rc, %aMemory);
}

sub getDiskStatsLinux
{
  if ( $main::gParameter{'Debug'} >= INFO ) { &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, INFO, '      ' . (caller(0))[3]); }
  my $rc = 0;

  my %aDiskStats;

  my $file = '/proc/diskstats';
  if ( ! open(STAT, '<', $file) ) {
    $rc = 1606;
    &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, ERR, "   Cannot open file $file (rc=$rc).\n$!\n");
    return ($rc, %aDiskStats);
  }

  while ( <STAT> ) {
    chomp $_;

    if ( $_ =~ /^\s+\d+\s+\d+\s+(\w+)\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)\s+(\d+)/ ) {

      # skip ram and loop
      if ( ($1 =~ /^ram/) || ($1 =~ /^loop/) || ($1 =~ /^sr/) ) {
        next;
      }

      $aDiskStats{'disk.reads_completed[' . $1 . ']'} = $2;
      $aDiskStats{'disk.reads_merged[' . $1 . ']'} = $3;
      $aDiskStats{'disk.sectors_read[' . $1 . ']'} = $4;
      $aDiskStats{'disk.ms_spent_reading[' . $1 . ']'} = $5;
      $aDiskStats{'disk.writes_completed[' . $1 . ']'} = $6;
      $aDiskStats{'disk.writes_merged[' . $1 . ']'} = $7;
      $aDiskStats{'disk.sectors_written[' . $1 . ']'} = $8;
      $aDiskStats{'disk.ms_spent_writing[' . $1 . ']'} = $9;
      $aDiskStats{'disk.io_in_progress[' . $1 . ']'} = $10;
      $aDiskStats{'disk.ms_spent_doing_io[' . $1 . ']'} = $11;

      # This field is incremented at each I/O start, I/O completion, I/O
      # merge, or read of these stats by the number of I/Os in progress
      # (field 9) times the number of milliseconds spent doing I/O since the
      # last update of this field.  This can provide an easy measure of both
      # I/O completion time and the backlog that may be accumulating.
      $aDiskStats{'disk.wighted_nbr_ms_spent_doing_io[' . $1 . ']'} = $12;
    }
  }
  close(STAT);

  return ($rc, %aDiskStats);
}

sub processServerInformation
{
  if ( $main::gParameter{'Debug'} >= INFO ) { &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, INFO, '    ' . (caller(0))[3]); }
  my $rc = 0;

  my %hServerStatus;

  my @aServerStatusToSend = (
  );

  &FromDualMySQLagent::initValues(\%hServerStatus, \@aServerStatusToSend);

  # print Dumper(\%Config);
  if ( $Config{'osname'} eq 'linux' ) {

    # ----
    # Disk statistics
    # ----
    ($rc, my %aDiskStats) = &getDiskStatsLinux();
    while ( my ($key, $value) = each(%aDiskStats) ) {
      push(@aServerStatusToSend, $key);
      $hServerStatus{$key} = $value;
    }

    # ----
    # Get Virtual Memory information
    # ----
    ($rc, my %aMemory) = &getMemoryInformationLinux();
    # print $rc, %aMemory;

    while ( my ($key, $value) = each(%aMemory) ) {
      push(@aServerStatusToSend, $key);
      $hServerStatus{$key} = $value;
    }

    # ----
    # Get Disk Space information
    # ----
    ($rc, my %aDiskSpace) = &getDiskSpaceInformationLinux();
    # print Dumper($rc, \%aDiskSpace);
    while ( my ($key, $value) = each(%aDiskSpace) ) {
      push(@aServerStatusToSend, $key);
      $hServerStatus{$key} = $value;
    }

    # ----
    # CPU Information
    # ----
    ($rc, my %aCpuInfo1) = &FromDualMySQLserver::getCpuInformationLinux();
    sleep(1);
    ($rc, my %aCpuInfo2) = &FromDualMySQLserver::getCpuInformationLinux();

    # Build sum to calculate %
    foreach ( keys %aCpuInfo2 ) {

      # Filter out all unless cpu[...]
      if ( $_ =~ /cpu\[(.*),(.*)\]/ ) {
        if ( ! defined($aCpuInfo2{"cpu[$1,total]"} ) ) {
          $aCpuInfo2{"cpu[$1,total]"} = 0.0;
        }
        # Sum of delta of now and one second ago
        $aCpuInfo2{"cpu[$1,total]"} += ($aCpuInfo2{$_} - $aCpuInfo1{$_});
      }
    }

    # Calculate %
    foreach ( keys %aCpuInfo2 ) {

      if ( $_ =~ /cpu\[(.*),(.*)]/ ) {
        if ( $2 ne 'total' ) {
          push(@aServerStatusToSend, $_);
          if ( $aCpuInfo2{"cpu[$1,total]"} != 0 ) {
            $hServerStatus{$_} = ($aCpuInfo2{$_} - $aCpuInfo1{$_}) / $aCpuInfo2{"cpu[$1,total]"} * 100;
          }
          else {
            $aCpuInfo2{"cpu[$1,total]"} = 0;
          }
        }
      }
      else {
        push(@aServerStatusToSend, $_);
        $hServerStatus{$_} = $aCpuInfo2{$_};
      }
    }

    # ----
    # Network Information
    # ----
    ($rc, my %aNetworkInfo) = &getNetworkInformationLinux();
    while ( my ($key, $value) = each(%aNetworkInfo) ) {
      push(@aServerStatusToSend, $key);
      $hServerStatus{$key} = $value;
    }
  }
  # Other operating systems than Linux
  else {
    $rc = 1601;
    if ( $main::gParameter{'Debug'} >= WARN ) { &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, WARN, '    ' . "Other operating systems than Linux are currently NOT supported (rc=$rc)."); }
  }

  # Do some post calculations

  # $hServerStatus{'xxx'} = $hServerStatus{'xxx'} == 0 ? 0 : $hServerStatus{'xxx'} / $hServerStatus{'xxx'};

  # NO domain in this case!
  # Ugly hack
  my $domain = $main::gDomain;
  $main::gDomain = '';
  &sendData::sendData(\%hServerStatus, \@aServerStatusToSend);
  $main::gDomain = $domain;
}

1;
__END__
