package FromDualMySQLsecurity;

# %LICENSE%

use strict;
use warnings;

use FromDualMySQLagent ':stooges';


use SecurityInformation;
use sendData;

# ---------------------------------------------------------------------
sub processSecurityInformation
# ---------------------------------------------------------------------
{
  if ( $main::gParameter{'Debug'} >= INFO ) { &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, INFO, '    ' . (caller(0))[3]); }

  my $rc = 0;

  my %hGlobalVariables;
  my %hSecurityInformation;

  my @aGlobalVariablesToSend = (
    'local_infile'
  , 'old_passwords'
  , 'skip_external_locking'
);

  my @aSecurityInformationToSend = (
    'empty_user'
  , 'test_database'
  , 'root_from_remote'
  , 'user_with_grant_privilege'
  , 'user_with_super_privilege'
  , 'user_with_create_user_privilege'
  );

  &FromDualMySQLagent::initValues(\%hGlobalVariables, \@aGlobalVariablesToSend);
  &FromDualMySQLagent::initValues(\%hSecurityInformation, \@aSecurityInformationToSend);

  # Set defaults
#   $hGlobalVariables{'innodb_io_capacity'}           = 200;

  my $dbh = &FromDualMySQLagent::getDatabaseConnection(%main::gParameter);

  if ( ! defined($dbh) ) {
    $rc = 26001;
    if ( $main::gParameter{'Debug'} >= ERR ) { &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, DBG, "    Database connection failed (rc=$rc)."); }
    return $rc;
  }

  &FromDualMySQLagent::getGlobalVariables($dbh, \%hGlobalVariables);
  &SecurityInformation::getSecurityInformation($dbh, \%hSecurityInformation);

  &FromDualMySQLagent::releaseDatabaseConnection($dbh);

  &sendData::sendData(\%hGlobalVariables, \@aGlobalVariablesToSend);
  &sendData::sendData(\%hSecurityInformation, \@aSecurityInformationToSend);

  return $rc;
}

1;
__END__
