package FromDualMySQLprocess;

#
# Copyright (C) 2010, 2011, 2012 FromDual GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 2 of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.
# If not, see <http://www.gnu.org/licenses/>.
#

use strict;
use warnings;

use Config;

use FromDualMySQLagent ':stooges';
use sendData;
use FromDualMySQLserver qw(getMemoryInformationLinux);

sub getMysqlPid
{
  my $pid_file = $_[0];

  my $pid = 0;
  # cat $pid_file
  if ( open(FILE, '<' . $pid_file) ) {
    $pid = <FILE>;
    chomp($pid);
    close(FILE);
  }

  return $pid;
}

sub getMysqlClusterPid
{
  my $pid_file = $_[0];

  my $rc = 0;

  my $ppid = 0;
  chomp($ppid = `cat $pid_file`);
  my $ret = $?;

  my @stdout = `ps -ef | grep $ppid`;

  # root      5388  9857  0 15:35 pts/1    00:00:00 grep 25353
  # root     25353     1  0 06:52 ?        00:00:00 ./ndbd
  # root     25354 25353  0 06:52 ?        00:01:35 ./ndbd

  my $pid = 0;
  foreach my $line ( @stdout ) {
    if ( $line =~ /^\w+?\s+(\d+)\s+(\d+).*$/ ) {
      if ( $2 == $ppid ) {
        $pid = $1;
        last;
      }
    }
  }
  return $pid;
}

sub getNumberOfFileDescriptors
{
  my $pid = $_[0];

  my @files = </proc/$pid/fd/*>;
  my $count = @files;
  return $count;
}

sub getStat
{
  my $pid = $_[0];

  if ( $main::gParameter{'Debug'} >= INFO ) { &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, INFO, '    ' . (caller(0))[3]); }

  my %hProcessStatistics;
  $hProcessStatistics{'check'} = 1;

  # status = stat + statm
  # Get heap/stack size of process
  # see man proc
  my @stdout = split(/\s/, `cat /proc/$pid/stat`);

  # 2524 (mysqld) S 2441 2438 2319 34817 24274 4202496 4583 0 162 0 1268 100 0 0 20 0 10 0 16938 112553984 580 4294967295
  # 0                         5                             10               15          20
  # 134512640 141534372 3214400624 3214399800 5821474 0 552967 4102 26345 4294967295 0 0 17 0 0 0 0 0 0
  # 25                                                30                             35         40

  #  0 pid %d                      The process ID.
  #  1 comm %s                     The filename of the executable, in parentheses.
  #  2 state %c                    One  character from the string.
  #  3 ppid %d                     The PID of the parent.
  #  4 pgrp %d                     The process group ID of the process.
  #  5 session %d                  The session ID of the process.
  #  6 tty_nr %d                   The controlling terminal of the process.
  #  7 tpgid %d                    The ID of the foreground process group of the controlling terminal of the process.
  #  8 flags %u                    The kernel flags word of the process.
  #  9 minflt %lu                  The number of minor faults the process has made which have not required loading a memory page from disk.
  $hProcessStatistics{'minor_faults'} = $stdout[9];
  # 10 cminflt %lu                 The number of minor faults that the process's waited-for children have made.
  $hProcessStatistics{'children_minor_faults'} = $stdout[10];
  # 11 majflt %lu                  The number of major faults the process has made which have required loading a memory page from disk.
  $hProcessStatistics{'major_faults'} = $stdout[11];
  # 12 cmajflt %lu                 The number of major faults that the process's waited-for children have made.
  $hProcessStatistics{'children_major_faults'} = $stdout[12];
  # 13 utime %lu                   Amount of time that this process has been scheduled in user mode (in clock ticks).
  $hProcessStatistics{'user_time'} = $stdout[13];
  # 14 stime %lu                   Amount of time that this process has been scheduled in kernel mode (in clock ticks).
  $hProcessStatistics{'system_time'} = $stdout[14];
  # 15 cutime %ld                  Amount of time that this process's waited-for children have been scheduled in user mode (in clock ticks).
  $hProcessStatistics{'children_user_time'} = $stdout[15];
  # 16 cstime %ld                  Amount of time that this process's waited-for children have been scheduled in kernel mode (in clock ticks).
  $hProcessStatistics{'children_system_time'} = $stdout[16];
  # 17 priority %ld                Scheduling priority.
  $hProcessStatistics{'scheduling_priortiy'} = $stdout[17];
  # 18 nice %ld                    The nice value, a value in the range 19 (low priority) to -20 (high priority).
  $hProcessStatistics{'nice_value'} = $stdout[18];
  # 19 num_threads %ld             Number of threads in this process.
  $hProcessStatistics{'number_of_threads'} = $stdout[19];
  # 20 itrealvalue %ld
  # 21 starttime %llu
  # 22 vsize %lu                   Virtual memory size in bytes.
  $hProcessStatistics{'virtual_memory_size'} = $stdout[22];
  # 23 rss %ld                     Resident Set Size: number of pages the process has in real memory (text, data, stack). NOT not demand-loaded or swapped out.
  $hProcessStatistics{'resident_memory_size'} = $stdout[23];
  # 24 rsslim %lu                  Current soft limit in bytes on the rss of the process.
  #$hProcessStatistics{'rss_soft_limit'} = $stdout[24];
  # 25 startcode %lu               The address above which program text can run.
  # 26 endcode %lu                 The address below which program text can run.
  # 27 startstack %lu              The address of the start of the stack.
  # 28 kstkesp %lu                 The current value of ESP (stack pointer).
  # 29 kstkeip %lu                 The current EIP (instruction pointer).
  # 30 signal %lu                  The bitmap of pending signals, displayed as a decimal number
  # 31 blocked %lu                 The  bitmap  of  blocked  signals, displayed as a decimal number.
  # 32 sigignore %lu               The bitmap of ignored signals, displayed as a decimal number.
  # 33 sigcatch %lu                The  bitmap  of  caught  signals,  displayed as a decimal number.
  # 34 wchan %lu                   This is the "channel" in which the process is waiting.
  # 35 nswap %lu                   Number of pages swapped (not maintained).
  # 36 cnswap %lu                  Cumulative nswap for child processes (not maintained).
  # 37 exit_signal %d              Signal to be sent to parent when we die.
  # 38 processor %d                CPU number last executed on.
  $hProcessStatistics{'last_cpu_number'} = $stdout[38];
  # 39 rt_priority %u              Real-time  scheduling  priority,  a  number  in  the  range  1  to  99  for  processes scheduled under a real-time policy, or 0, for non-real-time processes.
  $hProcessStatistics{'rt_priority'} = $stdout[39];
  # 40 policy %u                   Scheduling policy.
  $hProcessStatistics{'scheduling_policy'} = $stdout[40];
  # 41 delayacct_blkio_ticks %llu  Aggregated block I/O delays, measured in clock ticks (centiseconds).
  $hProcessStatistics{'block_io_delays'} = $stdout[41];
  # 42 guest_time %lu              Guest time of the process (time spent running a virtual CPU for a guest operating system), (in clock ticks).
  $hProcessStatistics{'guest_time'} = defined $stdout[42] ? $stdout[42] : 0;
  # 43 cguest_time %ld             Guest time of the process's children, (in clock ticks).
  $hProcessStatistics{'children_guest_time'} = defined $stdout[43] ? $stdout[43] : 0;

  @stdout = `cat /proc/$pid/status`;

  foreach my $line ( @stdout ) {
    if ( $line =~ /^(\w+):\s+(.*)$/ ) {

      if ( "$1" eq 'FDSize' ) {
        $hProcessStatistics{'FDSize'} = $2;
      }
      if ( "$1" eq 'VmPeak' ) {
        $hProcessStatistics{'VmPeak'} = $2;
        $hProcessStatistics{'VmPeak'} =~ s/\ kB//;
        $hProcessStatistics{'VmPeak'} *= 1024;
      }
      if ( "$1" eq 'VmSize' ) {
        $hProcessStatistics{'VmSize'} = $2;
        $hProcessStatistics{'VmSize'} =~ s/\ kB//;
        $hProcessStatistics{'VmSize'} *= 1024;
      }
      if ( "$1" eq 'VmLck' ) {
        $hProcessStatistics{'VmLck'} = $2;
        $hProcessStatistics{'VmLck'} =~ s/\ kB//;
        $hProcessStatistics{'VmLck'} *= 1024;
      }
      if ( "$1" eq 'VmHWM' ) {
        $hProcessStatistics{'VmHWM'} = $2;
        $hProcessStatistics{'VmHWM'} =~ s/\ kB//;
        $hProcessStatistics{'VmHWM'} *= 1024;
      }
      if ( "$1" eq 'VmRSS' ) {
        $hProcessStatistics{'VmRSS'} = $2;
        $hProcessStatistics{'VmRSS'} =~ s/\ kB//;
        $hProcessStatistics{'VmRSS'} *= 1024;
      }
      if ( "$1" eq 'VmData' ) {
        $hProcessStatistics{'VmData'} = $2;
        $hProcessStatistics{'VmData'} =~ s/\ kB//;
        $hProcessStatistics{'VmData'} *= 1024;
      }
      if ( "$1" eq 'VmStk' ) {
        $hProcessStatistics{'VmStk'} = $2;
        $hProcessStatistics{'VmStk'} =~ s/\ kB//;
        $hProcessStatistics{'VmStk'} *= 1024;
      }
      if ( "$1" eq 'VmExe' ) {
        $hProcessStatistics{'VmExe'} = $2;
        $hProcessStatistics{'VmExe'} =~ s/\ kB//;
        $hProcessStatistics{'VmExe'} *= 1024;
      }
      if ( "$1" eq 'VmLib' ) {
        $hProcessStatistics{'VmLib'} = $2;
        $hProcessStatistics{'VmLib'} =~ s/\ kB//;
        $hProcessStatistics{'VmLib'} *= 1024;
      }
      if ( "$1" eq 'VmPTE' ) {
        $hProcessStatistics{'VmPTE'} = $2;
        $hProcessStatistics{'VmPTE'} =~ s/\ kB//;
        $hProcessStatistics{'VmPTE'} *= 1024;
      }
      if ( "$1" eq 'Threads' ) {
        $hProcessStatistics{'Threads'} = $2;
      }
      if ( "$1" eq 'voluntary_ctxt_switches' ) {
        $hProcessStatistics{'voluntary_ctxt_switches'} = $2;
      }
      if ( "$1" eq 'nonvoluntary_ctxt_switches' ) {
        $hProcessStatistics{'nonvoluntary_ctxt_switches'} = $2;
      }
    }
  }

  $hProcessStatistics{'number_of_file_descriptors'} = &getNumberOfFileDescriptors($pid);
  return %hProcessStatistics;
}

sub processProcessInformation
{
  if ( $main::gParameter{'Debug'} >= INFO ) { &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, INFO, '    ' . (caller(0))[3]); }

  my $rc = 0;

  my %hProcess;
  $hProcess{'check'} = 0;

  if ( (! defined $main::gParameter{'PidFile'}) || ($main::gParameter{'PidFile'} eq '') ) {
    &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, ERR, 'PID file is not defined or empty.');
    return %hProcess;
  }

  if ( (! -f $main::gParameter{'PidFile'}) || (! -r $main::gParameter{'PidFile'}) ) {
    &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, ERR, "Cannot read PID file " . $main::gParameter{'PidFile'} . ". Either file does not exist or I have no read permissions. Are you sure the process is running?");
    return %hProcess;
  }

  my $pid = 0;
  if ( $main::gParameter{'Type'} eq 'mysqld' ) {

    # SHOW GLOBAL VARIABLES LIKE 'pid_file'
    # The PID is the one of the mysqld (not mysqld_safe)!

    $pid = &getMysqlPid($main::gParameter{'PidFile'});
  }
  elsif ( $main::gParameter{'Type'} eq 'ndbd' ) {

    # It is located in the DataDir (config.ini)
    # The PID is the one of the ndbd angel process, NOT of the ndbd itself!

    $pid = &getMysqlClusterPid($main::gParameter{'PidFile'});
  }
  else {
    &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, WARN, "Unknown section type " . $main::gParameter{'Type'});
  }

  if ( $pid == 0 ) {
    $rc = 1501;
    &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, ERR, 'PID of ' . $main::gParameter{'PidFile'} . " is $pid. Something went wrong (rc=$rc).");
    return %hProcess;
  }

  %hProcess = &getStat($pid);

  my @array = keys(%hProcess);
  if ( @array == 0 ) {
    $rc = 1502;
    &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, ERR, "Error getting process information (rc=$rc).");
    return $rc;
  }

  my @aProcessToSend = (
    'minor_faults'
  , 'children_minor_faults'
  , 'major_faults'
  , 'children_major_faults'
  , 'user_time'
  , 'children_user_time'
  , 'system_time'
  , 'children_system_time'
  , 'guest_time'
  , 'children_guest_time'
  , 'virtual_memory_size'
  , 'resident_memory_size'
  , 'scheduling_priortiy'
  , 'nice_value'
  , 'number_of_threads'
  , 'last_cpu_number'
  , 'rt_priority'
  , 'scheduling_policy'
  , 'block_io_delays'
  , 'Threads'
  , 'voluntary_ctxt_switches'
  , 'nonvoluntary_ctxt_switches'
  , 'number_of_file_descriptors'
  , 'FDSize'
  , 'VmPeak'
  , 'VmSize'
  , 'VmHWM'
  , 'VmRSS'
  , 'check'
);

  # Get memory for RSS/VZS graph
  if ( $Config{'osname'} eq 'linux' ) {
    ($rc, my %aMemory) = &FromDualMySQLserver::getMemoryInformationLinux();
    # print $rc, %aMemory;

    push(@aProcessToSend, 'vm_memory_total_kb');
    $hProcess{'vm_memory_total_kb'} = $aMemory{'vm_memory_total_kb'};
  }

  &sendData::sendData(\%hProcess, \@aProcessToSend);
  return $rc;
}

1;
__END__
