package FromDualMySQLpbxt;

#
# Copyright (C) 2010, 2011, 2012 FromDual GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 2 of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.
# If not, see <http://www.gnu.org/licenses/>.
#

use strict;
use warnings;

use FromDualMySQLagent ':stooges';
use sendData;

sub getPbxtInformation {

  my $dbh = shift;
  my $variables_ref = shift;

  if ( $main::gParameter{'Debug'} >= INFO ) { &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, INFO, '    ' . (caller(0))[3]); }

  my $sql = "SELECT REPLACE(Name, ' ', '_') AS Name, Value FROM INFORMATION_SCHEMA.PBXT_STATISTICS";
  my $sth = $dbh->prepare($sql);
  if ( $sth->execute() ) {
    while ( my $ref = $sth->fetchrow_hashref() ) {
      $$variables_ref{$ref->{'Name'}} = $ref->{'Value'};
    }
    $sth->finish();
  }

  if ( $main::gParameter{'Debug'} >= DBG ) {
    &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, DBG, 'PBXT Information:');
    foreach my $key ( keys %$variables_ref ) {
      &FromDualMySQLagent::mylog($main::gParameterf{'LogFile'}, DBG, "key: $key, value: $$variables_ref{$key}");
    }
  }
}

sub processPbxtInformation
{
  my $rc = 0;
  if ( $main::gParameter{'Debug'} >= INFO ) { &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, INFO, '    ' . (caller(0))[3]); }

  my %hGlobalVariables;
  my %hGlobalStatus;
  my %hPbxtInformation;

  my @aGlobalVariablesToSend = (
    'pbxt_transaction_buffer_size'
  , 'pbxt_record_cache_size'
  , 'pbxt_index_cache_size'
  , 'pbxt_log_buffer_size'
  , 'pbxt_log_cache_size'
  , 'pbxt_log_file_threshold'
  , 'pbxt_row_file_grow_size'
  , 'pbxt_checkpoint_frequency'
  , 'pbxt_data_file_grow_size'
  , 'pbxt_data_log_threshold'
  , 'pbxt_garbage_threshold'
  );

  my @aPbxtInformationToSend = (
    'Commit_Count'
  , 'Rollback_Count'
  , 'Wait_for_Xact_Count'
  , 'Dirty_Xact_Count'
  , 'Read_Statements'
  , 'Write_Statements'
  , 'Record_Bytes_Read'
  , 'Record_Bytes_Written'
  , 'Record_File_Flushes'
  , 'Record_Flush_Time'
  , 'Record_Cache_Hits'
  , 'Record_Cache_Misses'
  , 'Record_Cache_Frees'
  , 'Record_Cache_Usage'
  , 'Index_Bytes_Read'
  , 'Index_Bytes_Written'
  , 'Index_File_Flushes'
  , 'Index_Flush_Time'
  , 'Index_Cache_Hits'
  , 'Index_Cache_Misses'
  , 'Index_Cache_Usage'
  , 'Index_Log_Bytes_In'
  , 'Index_Log_Bytes_Out'
  , 'Index_Log_File_Syncs'
  , 'Index_Log_Sync_Time'
  , 'Xact_Log_Bytes_In'
  , 'Xact_Log_Bytes_Out'
  , 'Xact_Log_File_Syncs'
  , 'Xact_Log_Sync_Time'
  , 'Xact_Log_Cache_Hits'
  , 'Xact_Log_Cache_Misses'
  , 'Xact_Log_Cache_Usage'
  , 'Data_Log_Bytes_In'
  , 'Data_Log_Bytes_Out'
  , 'Data_Log_File_Syncs'
  , 'Data_Log_Sync_Time'
  , 'Bytes_to_Checkpoint'
  , 'Log_Bytes_to_Write'
  , 'Log_Bytes_to_Sweep'
  , 'Index_Scan_Count'
  , 'Table_Scan_Count'
  , 'Select_Row_Count'
  , 'Insert_Row_Count'
  , 'Update_Row_Count'
  , 'Delete_Row_Count'
  , 'Rows_Per_Select'
  , 'Row_rw_ratio'
  , 'Statement_Rw_Ratio'
  , 'Statements_Per_Xact'
  );

  &FromDualMySQLagent::initValues(\%hGlobalVariables, \@aGlobalVariablesToSend);
  &FromDualMySQLagent::initValues(\%hPbxtInformation, \@aPbxtInformationToSend);

  my $dbh = &FromDualMySQLagent::getDatabaseConnection(%main::gParameter);

  if ( ! defined($dbh) ) {
    $rc = 2200;
    if ( $main::gParameter{'Debug'} >= ERR ) { &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, DBG, "    Database connection failed (rc=$rc)."); }
    return $rc;
  }

  &FromDualMySQLagent::getGlobalVariables($dbh, \%hGlobalVariables);
  &getPbxtInformation($dbh, \%hPbxtInformation);

  &FromDualMySQLagent::releaseDatabaseConnection($dbh);

  # Do some post calculations
  # Removing of the MB/K at the end
  $hGlobalVariables{'pbxt_log_file_threshold'}      =~ s/MB?//i; $hGlobalVariables{'pbxt_log_file_threshold'} *= 1024*1024;
  $hGlobalVariables{'pbxt_log_cache_size'}          =~ s/MB?//i; $hGlobalVariables{'pbxt_log_cache_size'} *= 1024*1024;
  $hGlobalVariables{'pbxt_record_cache_size'}       =~ s/MB?//i; $hGlobalVariables{'pbxt_record_cache_size'} *= 1024*1024;
  $hGlobalVariables{'pbxt_index_cache_size'}        =~ s/MB?//i; $hGlobalVariables{'pbxt_index_cache_size'} *= 1024*1024;
  $hGlobalVariables{'pbxt_checkpoint_frequency'}    =~ s/MB?//i; $hGlobalVariables{'pbxt_checkpoint_frequency'} *= 1024*1024;
  $hGlobalVariables{'pbxt_data_file_grow_size'}     =~ s/MB?//i; $hGlobalVariables{'pbxt_data_file_grow_size'} *= 1024*1024;
  $hGlobalVariables{'pbxt_row_file_grow_size'}      =~ s/K//i; $hGlobalVariables{'pbxt_row_file_grow_size'} *= 1024;
  $hGlobalVariables{'pbxt_data_log_threshold'}      =~ s/MB?//i; $hGlobalVariables{'pbxt_data_log_threshold'} *= 1024*1024;
  $hGlobalVariables{'pbxt_transaction_buffer_size'} =~ s/MB?//i; $hGlobalVariables{'pbxt_transaction_buffer_size'} *= 1024*1024;
  $hGlobalVariables{'pbxt_log_buffer_size'}         =~ s/K//i; $hGlobalVariables{'pbxt_log_buffer_size'} *= 1024;

  if ( $hPbxtInformation{'Read_Statements'} > 0 ) {
    $hPbxtInformation{'Rows_Per_Select'} = $hPbxtInformation{'Select_Row_Count'} / $hPbxtInformation{'Read_Statements'};
  }
  else {
    $hPbxtInformation{'Rows_Per_Select'} = 0;
  }

  my $diu = $hPbxtInformation{'Delete_Row_Count'} + $hPbxtInformation{'Insert_Row_Count'} + $hPbxtInformation{'Update_Row_Count'};
  if ( $diu > 0 ) {
    $hPbxtInformation{'Row_rw_ratio'} = $hPbxtInformation{'Select_Row_Count'} / $diu;
  }
  else {
    $hPbxtInformation{'Row_rw_ratio'} = 0;
  }

  if ( $hPbxtInformation{'Write_Statements'} > 0 ) {
    $hPbxtInformation{'Statement_Rw_Ratio'} = $hPbxtInformation{'Read_Statements'} / $hPbxtInformation{'Write_Statements'};
  }
  else {
    $hPbxtInformation{'Statement_Rw_Ratio'} = 0;
  }

  my $cr = $hPbxtInformation{'Commit_Count'} + $hPbxtInformation{'Rollback_Count'};
  if ( $cr > 0 ) {
    $hPbxtInformation{'Statements_Per_Xact'} = ($hPbxtInformation{'Read_Statements'} + $hPbxtInformation{'Write_Statements'}) / $cr;
  }
  else {
    $hPbxtInformation{'Statements_Per_Xact'} = 0;
  }

  &sendData::sendData(\%hGlobalVariables, \@aGlobalVariablesToSend);
  &sendData::sendData(\%hPbxtInformation, \@aPbxtInformationToSend);

  return $rc;
}

1;
__END__

