package FromDualMySQLndb;

#
# Copyright (C) 2010, 2011, 2012 FromDual GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 2 of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.
# If not, see <http://www.gnu.org/licenses/>.
#

use strict;
use warnings;

use FromDualMySQLagent ':stooges';
use sendData;

sub getNdbInfo {

  my $dbh        = shift;
  my $status_ref = shift;

  if ( $main::gParameter{'Debug'} >= INFO ) { &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, INFO, '    ' . (caller(0))[3]); }

  my %result;
  my $sql;
  my $sth;

  $sql = 'SELECT counter_name, SUM(val) AS val FROM ndbinfo.counters GROUP BY counter_name';
  $sth = $dbh->prepare($sql);
  if ( $sth->execute() ) {
    while ( my $ref = $sth->fetchrow_hashref() ) {
      $result{'NDB_' . $ref->{'counter_name'}} = $ref->{'val'};
    }
    $sth->finish();
  }

  $sql = 'SELECT MAX(total) AS total, MAX(used) AS used FROM ndbinfo.logbuffers';
  $sth = $dbh->prepare($sql);
  if ( $sth->execute() ) {
    if ( my $ref = $sth->fetchrow_hashref() ) {
      $result{'NDB_LOGBUFFERS_TOTAL'} = $ref->{'total'};
      $result{'NDB_LOGBUFFERS_USED'}  = $ref->{'used'};
    }
    $sth->finish();
  }

  $sql = 'SELECT SUM(total) AS total, SUM(used) AS used FROM ndbinfo.logspaces';
  $sth = $dbh->prepare($sql);
  if ( $sth->execute() ) {
    if ( my $ref = $sth->fetchrow_hashref() ) {
      $result{'NDB_LOGSPACES_TOTAL'} = $ref->{'total'};
      $result{'NDB_LOGSPACES_USED'}  = $ref->{'used'};
    }
    $sth->finish();
  }

  $sql = 'SELECT memory_type, SUM(used) AS used, SUM(total) AS total FROM ndbinfo.memoryusage GROUP BY memory_type';
  $sth = $dbh->prepare($sql);
  if ( $sth->execute() ) {
    while ( my $ref = $sth->fetchrow_hashref() ) {
      $result{'NDB_' . $ref->{'memory_type'} . ' used'}  = $ref->{'used'};
      $result{'NDB_' . $ref->{'memory_type'} . ' total'} = $ref->{'total'};
    }
    $sth->finish();
  }

  $sql = 'SELECT ROUND(AVG(uptime), 0) AS uptime, SUM(start_phase) AS start_phase FROM ndbinfo.nodes';
  $sth = $dbh->prepare($sql);
  if ( $sth->execute() ) {
    while ( my $ref = $sth->fetchrow_hashref() ) {
      $result{'NDB_UPTIME'} = $ref->{'uptime'};
      $result{'NDB_START_PASE'}  = $ref->{'start_phase'};
    }
    $sth->finish();
  }

  $sql = 'SELECT resource_name, SUM(reserved) AS reserved, SUM(used) AS used, SUM(max) AS max FROM ndbinfo.resources GROUP BY resource_name';
  $sth = $dbh->prepare($sql);
  if ( $sth->execute() ) {
    while ( my $ref = $sth->fetchrow_hashref() ) {
      $result{'NDB_RESOURCES_' . $ref->{'resource_name'} . '_RESERVED'} = $ref->{'reserved'};
      $result{'NDB_RESOURCES_' . $ref->{'resource_name'} . '_USED'}     = $ref->{'used'};
      $result{'NDB_RESOURCES_' . $ref->{'resource_name'} . '_MAX'}      = $ref->{'max'};
    }
    $sth->finish();
  }

  $sql = 'SELECT status, COUNT(status) AS cnt FROM ndbinfo.transporters GROUP BY status';
  $sth = $dbh->prepare($sql);
  if ( $sth->execute() ) {
    while ( my $ref = $sth->fetchrow_hashref() ) {
      $result{'NDB_TRANSPORTER_' . $ref->{'status'}} = $ref->{'cnt'};
    }
    $sth->finish();
  }

  # Now adjust the naming
  $$status_ref{'Ndb_index_memory_used'}                      = defined($result{'NDB_Index memory used'}) ? $result{'NDB_Index memory used'} : 0;
  $$status_ref{'Ndb_index_memory_total'}                     = defined($result{'NDB_Index memory total'}) ? $result{'NDB_Index memory total'} : 0;
  $$status_ref{'Ndb_data_memory_total'}                      = defined($result{'NDB_Data memory total'}) ? $result{'NDB_Data memory total'} : 0;
  $$status_ref{'Ndb_data_memory_used'}                       = defined($result{'NDB_Data memory used'}) ? $result{'NDB_Data memory used'} : 0;

  $$status_ref{'Ndb_abort_count'}                            = defined($result{'NDB_ABORTS'}) ? $result{'NDB_ABORTS'} : 0;
  $$status_ref{'Ndb_range_scans'}                            = defined($result{'NDB_RANGE_SCANS'}) ? $result{'NDB_RANGE_SCANS'} : 0;
  $$status_ref{'Ndb_scans'}                                  = defined($result{'NDB_TABLE_SCANS'}) ? $result{'NDB_TABLE_SCANS'} : 0;
  $$status_ref{'Ndb_write_count'}                            = defined($result{'NDB_WRITES'}) ? $result{'NDB_WRITES'} : 0;
  $$status_ref{'Ndb_commit_count'}                           = defined($result{'NDB_COMMITS'}) ? $result{'NDB_COMMITS'} : 0;
  $$status_ref{'Ndb_read_count'}                             = defined($result{'NDB_READS'}) ? $result{'NDB_READS'} : 0;
  $$status_ref{'Ndb_simple_read_count'}                      = defined($result{'NDB_SIMPLE_READS'}) ? $result{'NDB_SIMPLE_READS'} : 0;
  $$status_ref{'Ndb_trans_count'}                            = defined($result{'NDB_TRANSACTIONS'}) ? $result{'NDB_TRANSACTIONS'} : 0;
  $$status_ref{'Ndb_operations'}                             = defined($result{'NDB_OPERATIONS'}) ? $result{'NDB_OPERATIONS'} : 0;
  $$status_ref{'Ndb_attr_info_count'}                        = defined($result{'NDB_ATTRINFO'}) ? $result{'NDB_ATTRINFO'} : 0;
  $$status_ref{'Ndb_concurrent_operations'}                  = 0;

  $$status_ref{'Ndb_logbuffers_used'}                        = defined($result{'NDB_LOGBUFFERS_USED'}) ? $result{'NDB_LOGBUFFERS_USED'} : 0;
  $$status_ref{'Ndb_logbuffers_total'}                       = defined($result{'NDB_LOGBUFFERS_TOTAL'}) ? $result{'NDB_LOGBUFFERS_TOTAL'} : 0;

  $$status_ref{'Ndb_logspaces_used'}                         = defined($result{'NDB_LOGSPACES_USED'}) ? $result{'NDB_LOGSPACES_USED'} : 0;
  $$status_ref{'Ndb_logspaces_total'}                        = defined($result{'NDB_LOGSPACES_TOTAL'}) ? $result{'NDB_LOGSPACES_TOTAL'} : 0;

  $$status_ref{'Ndb_uptime'}                                 = defined($result{'NDB_UPTIME'}) ? $result{'NDB_UPTIME'} : 0;
  $$status_ref{'Ndb_start_pase'}                             = defined($result{'NDB_START_PASE'}) ? $result{'NDB_START_PASE'} : 0;

  $$status_ref{'Ndb_resources_data_memory_used'}             = defined($result{'NDB_RESOURCES_DATA_MEMORY_USED'}) ? $result{'NDB_RESOURCES_DATA_MEMORY_USED'} : 0;
  $$status_ref{'Ndb_resources_data_memory_reserved'}         = defined($result{'NDB_RESOURCES_DATA_MEMORY_RESERVED'}) ? $result{'NDB_RESOURCES_DATA_MEMORY_RESERVED'} : 0;
  $$status_ref{'Ndb_resources_data_memory_max'}              = defined($result{'NDB_RESOURCES_DATA_MEMORY_MAX'}) ? $result{'NDB_RESOURCES_DATA_MEMORY_MAX'} : 0;
  $$status_ref{'Ndb_resources_file_buffers_reserved'}        = defined($result{'NDB_RESOURCES_FILE_BUFFERS_RESERVED'}) ? $result{'NDB_RESOURCES_FILE_BUFFERS_RESERVED'} : 0;
  $$status_ref{'Ndb_resources_file_buffers_max'}             = defined($result{'NDB_RESOURCES_FILE_BUFFERS_MAX'}) ? $result{'NDB_RESOURCES_FILE_BUFFERS_MAX'} : 0;
  $$status_ref{'Ndb_resources_file_buffers_used'}            = defined($result{'NDB_RESOURCES_FILE_BUFFERS_USED'}) ? $result{'NDB_RESOURCES_FILE_BUFFERS_USED'} : 0;
  $$status_ref{'Ndb_resources_transporter_buffers_reserved'} = defined($result{'NDB_RESOURCES_TRANSPORTER_BUFFERS_RESERVED'}) ? $result{'NDB_RESOURCES_TRANSPORTER_BUFFERS_RESERVED'} : 0;
  $$status_ref{'Ndb_resources_transporter_buffers_max'}      = defined($result{'NDB_RESOURCES_TRANSPORTER_BUFFERS_MAX'} ) ? $result{'NDB_RESOURCES_TRANSPORTER_BUFFERS_MAX'} : 0;
  $$status_ref{'Ndb_resources_transporter_buffers_used'}     = defined($result{'NDB_RESOURCES_TRANSPORTER_BUFFERS_USED'}) ? $result{'NDB_RESOURCES_TRANSPORTER_BUFFERS_USED'} : 0;
  $$status_ref{'Ndb_resources_disk_records_used'}            = defined($result{'NDB_RESOURCES_DISK_RECORDS_USED'}) ? $result{'NDB_RESOURCES_DISK_RECORDS_USED'} : 0;
  $$status_ref{'Ndb_resources_disk_records_max'}             = defined($result{'NDB_RESOURCES_DISK_RECORDS_MAX'}) ? $result{'NDB_RESOURCES_DISK_RECORDS_MAX'} : 0;
  $$status_ref{'Ndb_resources_disk_records_reserved'}        = defined($result{'NDB_RESOURCES_DISK_RECORDS_RESERVED'}) ? $result{'NDB_RESOURCES_DISK_RECORDS_RESERVED'} : 0;
  $$status_ref{'Ndb_resources_disk_operations_reserved'}     = defined($result{'NDB_RESOURCES_DISK_OPERATIONS_RESERVED'}) ? $result{'NDB_RESOURCES_DISK_OPERATIONS_RESERVED'} : 0;
  $$status_ref{'Ndb_resources_disk_operations_used'}         = defined($result{'NDB_RESOURCES_DISK_OPERATIONS_USED'}) ? $result{'NDB_RESOURCES_DISK_OPERATIONS_USED'} : 0;
  $$status_ref{'Ndb_resources_disk_operations_max'}          = defined($result{'NDB_RESOURCES_DISK_OPERATIONS_MAX'}) ? $result{'NDB_RESOURCES_DISK_OPERATIONS_MAX'} : 0;
  $$status_ref{'Ndb_resources_reserved_max'}                 = defined($result{'NDB_RESOURCES_RESERVED_MAX'}) ? $result{'NDB_RESOURCES_RESERVED_MAX'} : 0;
  $$status_ref{'Ndb_resources_reserved_used'}                = defined($result{'NDB_RESOURCES_RESERVED_USED'}) ? $result{'NDB_RESOURCES_RESERVED_USED'} : 0;
  $$status_ref{'Ndb_resources_reserved_reserved'}            = defined($result{'NDB_RESOURCES_RESERVED_RESERVED'}) ? $result{'NDB_RESOURCES_RESERVED_RESERVED'} : 0;
  $$status_ref{'Ndb_resources_jobbuffer_max'}                = defined($result{'NDB_RESOURCES_JOBBUFFER_MAX'}) ? $result{'NDB_RESOURCES_JOBBUFFER_MAX'} : 0;
  $$status_ref{'Ndb_resources_jobbuffer_reserved'}           = defined($result{'NDB_RESOURCES_JOBBUFFER_RESERVED'}) ? $result{'NDB_RESOURCES_JOBBUFFER_RESERVED'} : 0;
  $$status_ref{'Ndb_resources_jobbuffer_used'}               = defined($result{'NDB_RESOURCES_JOBBUFFER_USED'}) ? $result{'NDB_RESOURCES_JOBBUFFER_USED'} : 0;

  $$status_ref{'Ndb_transporter_disconnected'}               = defined($result{'NDB_TRANSPORTER_DISCONNECTED'}) ? $result{'NDB_TRANSPORTER_DISCONNECTED'} : 0;
  $$status_ref{'Ndb_transporter_connected'}                  = defined($result{'NDB_TRANSPORTER_CONNECTED'}) ? $result{'NDB_TRANSPORTER_CONNECTED'} : 0;
  $$status_ref{'Ndb_transporter_connecting'}                 = defined($result{'NDB_TRANSPORTER_CONNECTING'}) ? $result{'NDB_TRANSPORTER_CONNECTING'} : 0;

  if ( $main::gParameter{'Debug'} == DBG )
  {
    foreach my $key ( keys %$status_ref )
    {
      &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, DBG, "key: $key, value: $$status_ref{$key}");
    }
  }
}

sub getShowEngineNdbStatus {

  my $dbh        = shift;
  my $status_ref = shift;

  my %result;
  $result{'NdbTransaction'}        = 'created=0, free=0,';
  $result{'NdbOperation'}          = 'created=0, free=0,';
  $result{'NdbIndexScanOperation'} = 'created=0, free=0,';
  $result{'NdbIndexOperation'}     = 'created=0, free=0,';
  $result{'NdbRecAttr'}            = 'created=0, free=0,';
  $result{'NdbApiSignal'}          = 'created=0, free=0,';
  $result{'NdbLabel'}              = 'created=0, free=0,';
  $result{'NdbApiSignal'}          = 'created=0, free=0,';
  $result{'NdbBranch'}             = 'created=0, free=0,';
  $result{'NdbSubroutine'}         = 'created=0, free=0,';
  $result{'NdbCall'}               = 'created=0, free=0,';
  $result{'NdbBlob'}               = 'created=0, free=0,';
  $result{'NdbReceiver'}           = 'created=0, free=0,';

  my $sql = 'SHOW ENGINE NDB STATUS';
  my $sth = $dbh->prepare($sql);
  if ( $sth->execute() ) {
    while ( my $ref = $sth->fetchrow_hashref() ) {
      $result{$ref->{'Name'}} = $ref->{'Status'};
    }
    $sth->finish();
  }

  # Now parse the result
  if ( $result{'NdbTransaction'} =~ m/^created=(\d+),\s+free=(\d+),/ ) {
    $$status_ref{'NdbTransactionCreated'} = $1;
    $$status_ref{'NdbTransactionFree'}    = $2;
  }
  else {
    $$status_ref{'NdbTransactionCreated'} = 0;
    $$status_ref{'NdbTransactionFree'}    = 0;
  }

  if ( $result{'NdbOperation'} =~ m/^created=(\d+),\s+free=(\d+),/ ) {
    $$status_ref{'NdbOperationCreated'} = $1;
    $$status_ref{'NdbOperationFree'}    = $2;
  }
  else {
    $$status_ref{'NdbOperationCreated'} = 0;
    $$status_ref{'NdbOperationFree'}    = 0;
  }

  if ( $result{'NdbIndexScanOperation'} =~ m/^created=(\d+),\s+free=(\d+),/ ) {
    $$status_ref{'NdbIndexScanOperationCreated'} = $1;
    $$status_ref{'NdbIndexScanOperationFree'}    = $2;
  }
  else {
    $$status_ref{'NdbIndexScanOperationCreated'} = 0;
    $$status_ref{'NdbIndexScanOperationFree'}    = 0;
  }

  if ( $result{'NdbIndexOperation'} =~ m/^created=(\d+),\s+free=(\d+),/ ) {
    $$status_ref{'NdbIndexOperationCreated'} = $1;
    $$status_ref{'NdbIndexOperationFree'}    = $2;
  }
  else {
    $$status_ref{'NdbIndexOperationCreated'} = 0;
    $$status_ref{'NdbIndexOperationFree'}    = 0;
  }

  if ( $result{'NdbRecAttr'} =~ m/^created=(\d+),\s+free=(\d+),/ ) {
    $$status_ref{'NdbRecAttrCreated'} = $1;
    $$status_ref{'NdbRecAttrFree'}    = $2;
  }
  else {
    $$status_ref{'NdbRecAttrCreated'} = 0;
    $$status_ref{'NdbRecAttrFree'}    = 0;
  }

  if ( $result{'NdbApiSignal'} =~ m/^created=(\d+),\s+free=(\d+),/ ) {
    $$status_ref{'NdbApiSignalCreated'} = $1;
    $$status_ref{'NdbApiSignalFree'}    = $2;
  }
  else {
    $$status_ref{'NdbApiSignalCreated'} = 0;
    $$status_ref{'NdbApiSignalFree'}    = 0;
  }

  if ( $result{'NdbLabel'} =~ m/^created=(\d+),\s+free=(\d+),/ ) {
    $$status_ref{'NdbLabelCreated'} = $1;
    $$status_ref{'NdbLabelFree'}    = $2;
  }
  else {
    $$status_ref{'NdbLabelCreated'} = 0;
    $$status_ref{'NdbLabelFree'}    = 0;
  }

  if ( $result{'NdbApiSignal'} =~ m/^created=(\d+),\s+free=(\d+),/ ) {
    $$status_ref{'NdbApiSignalCreated'} = $1;
    $$status_ref{'NdbApiSignalFree'}    = $2;
  }
  else {
    $$status_ref{'NdbApiSignalCreated'} = 0;
    $$status_ref{'NdbApiSignalFree'}    = 0;
  }

  if ( $result{'NdbBranch'} =~ m/^created=(\d+),\s+free=(\d+),/ ) {
    $$status_ref{'NdbBranchCreated'} = $1;
    $$status_ref{'NdbBranchFree'}    = $2;
  }
  else {
    $$status_ref{'NdbBranchCreated'} = 0;
    $$status_ref{'NdbBranchFree'}    = 0;
  }

  if ( $result{'NdbSubroutine'} =~ m/^created=(\d+),\s+free=(\d+),/ ) {
    $$status_ref{'NdbSubroutineCreated'} = $1;
    $$status_ref{'NdbSubroutineFree'}    = $2;
  }
  else {
    $$status_ref{'NdbSubroutineCreated'} = 0;
    $$status_ref{'NdbSubroutineFree'}    = 0;
  }

  if ( $result{'NdbCall'} =~ m/^created=(\d+),\s+free=(\d+),/ ) {
    $$status_ref{'NdbCallCreated'} = $1;
    $$status_ref{'NdbCallFree'}    = $2;
  }
  else {
    $$status_ref{'NdbCallCreated'} = 0;
    $$status_ref{'NdbCallFree'}    = 0;
  }

  if ( $result{'NdbBlob'} =~ m/^created=(\d+),\s+free=(\d+),/ ) {
    $$status_ref{'NdbBlobCreated'} = $1;
    $$status_ref{'NdbBlobFree'}    = $2;
  }
  else {
    $$status_ref{'NdbBlobCreated'} = 0;
    $$status_ref{'NdbBlobFree'}    = 0;
  }

  if ( $result{'NdbReceiver'} =~ m/^created=(\d+),\s+free=(\d+),/ ) {
    $$status_ref{'NdbReceiverCreated'} = $1;
    $$status_ref{'NdbReceiverFree'}    = $2;
  }
  else {
    $$status_ref{'NdbReceiverCreated'} = 0;
    $$status_ref{'NdbReceiverFree'}    = 0;
  }

# Does not make sense on 32-bit system!
#   if ( $result{'binlog'} =~ m/^latest_epoch=(\d+),\s+latest_trans_epoch=(\d+),\s+latest_received_binlog_epoch=(\d+),\s+latest_handled_binlog_epoch=(\d+),\s+latest_applied_binlog_epoch=(\d+)/ ) {
#     $$status_ref{'latest_epoch'}                 = substr($1, -9);
#     $$status_ref{'latest_trans_epoch'}           = substr($2, -9);
#     $$status_ref{'latest_received_binlog_epoch'} = substr($3, -9);
#     $$status_ref{'latest_handled_binlog_epoch'}  = substr($4, -9);
#     $$status_ref{'latest_applied_binlog_epoch'}  = substr($5, -9);
#   }
#   else {
#     $$status_ref{'latest_epoch'}                 = 0;
#     $$status_ref{'latest_trans_epoch'}           = 0;
#     $$status_ref{'latest_received_binlog_epoch'} = 0;
#     $$status_ref{'latest_handled_binlog_epoch'}  = 0;
#     $$status_ref{'latest_applied_binlog_epoch'}  = 0;
#   }

  if ( $main::gParameter{'Debug'} == DBG )
  {
    &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, DBG, $sql);
    foreach my $key ( keys %$status_ref )
    {
      &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, DBG, "key: $key, value: $$status_ref{$key}");
    }
  }
}

sub parseClusterLog
{
  my $info_ref = shift;

  my $rc = 0;

  if ( ! -r $main::gParameter{'ClusterLog'} ) {
    $rc = 2301;
    &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, ERR, "Cannot read cluster log: " . $main::gParameter{'ClusterLog'} . " (rc=$rc).");
    return $rc;
  }
  if ( $main::gParameter{'Debug'} == DBG ) {
    &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, DBG, "Reading from cluster log: " . $main::gParameter{'ClusterLog'});
  }

  my @stdout = `tail -n 1000 $main::gParameter{'ClusterLog'} 2>&1`;
  my $ret = $?;

  if ( $ret ) {
    foreach my $line ( @stdout ) {
      &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, DBG, $line);
    }
    return 0;
  }

  if ( $ret || ($main::gParameter{'Debug'} == DBG) ) {
    foreach my $line ( @stdout ) {
      &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, DBG, $line);
    }
  }

  my (%tempDMU, %tempIMU, %tempDMT, %tempIMT) ;
  my (%tempOperations, %tempTransCount, %tempCommitCount, %tempReadCount, %tempSimpleReadCount, %tempWriteCount, %tempAttrInfoCount, %tempConcurrentOperations, %tempAbortCount, %tempScans, %tempRangeScans);
  foreach my $line ( @stdout ) {

    # Search for memory
    # ... -- Node 10: Data usage is 34%(895 32K pages of total 2560)
    # ... -- Node 10: Index usage is 26%(611 8K pages of total 2336)
    # the clue is: we read from old to new. So at the end we should have the newest data in the array.
    if ( $line =~ m/-- Node (\d+): (\w+) usage is \d+%\((\d+) (\d+)K pages of total (\d+)\)$/ ) {

      if ( "$2" eq 'Data' ) {
        $tempDMU{$1} = $3 * $4 * 1024;
        $tempDMT{$1} = $5 * $4 * 1024;
      }
      elsif ( "$2" eq 'Index' ) {
        $tempIMU{$1} = $3 * $4 * 1024;
        $tempIMT{$1} = $5 * $4 * 1024;
      }
      next;
    }

    # Search for operations
    # ... -- Node 10: Operations=0
    if ( $line =~ m/-- Node (\d+): Operations=(\d+)$/ ) {
      $tempOperations{$1} = $2;
      next;
    }

    # ... -- Node 10: Trans. Count = 0, Commit Count = 0, Read Count = 0, Simple Read Count = 0, Write Count = 0, AttrInfo Count = 0, Concurrent Operations = 0, Abort Count = 0 Scans = 0 Range scans = 0
    if ( $line =~ m/-- Node (\d+): Trans. Count = (\d+), Commit Count = (\d+), Read Count = (\d+), Simple Read Count = (\d+), Write Count = (\d+), AttrInfo Count = (\d+), Concurrent Operations = (\d+), Abort Count = (\d+) Scans = (\d+) Range scans = (\d+)$/ ) {
      $tempTransCount{$1} = $2;
      $tempCommitCount{$1} = $3;
      $tempReadCount{$1} = $4;
      $tempSimpleReadCount{$1} = $5;
      $tempWriteCount{$1} = $6;
      $tempAttrInfoCount{$1} = $7;
      $tempConcurrentOperations{$1} = $8;
      $tempAbortCount{$1} = $9;
      $tempScans{$1} = $10;
      $tempRangeScans{$1} = $11;
      next;
    }
  }

  # INFO     -- Node 10: Local checkpoint 1222 started.
  # INFO     -- Node 10: Local checkpoint 1222 completed.

  $$info_ref{"Ndb_data_memory_used"} = 0;
  $$info_ref{"Ndb_index_memory_used"} = 0;
  $$info_ref{"Ndb_data_memory_total"} = 0;
  $$info_ref{"Ndb_index_memory_total"} = 0;

  $$info_ref{"Ndb_operations_old"} = 0;

  $$info_ref{"Ndb_trans_count_old"} = 0;
  $$info_ref{"Ndb_commit_count_old"} = 0;
  $$info_ref{"Ndb_read_count_old"} = 0;
  $$info_ref{"Ndb_simple_read_count_old"} = 0;
  $$info_ref{"Ndb_write_count_old"} = 0;
  $$info_ref{"Ndb_attr_info_count_old"} = 0;
  $$info_ref{"Ndb_concurrent_operations_old"} = 0;
  $$info_ref{"Ndb_abort_count_old"} = 0;
  $$info_ref{"Ndb_scans_old"} = 0;
  $$info_ref{"Ndb_range_scans_old"} = 0;

  my $id = 1;
  foreach my $nodeid ( sort keys %tempDMU ) {
    $$info_ref{"Ndb_data_memory_used_node_" . sprintf("%02s", $id)} = $tempDMU{$nodeid};
    $$info_ref{"Ndb_data_memory_used"} += $tempDMU{$nodeid};
    $$info_ref{"Ndb_index_memory_used_node_" . sprintf("%02s", $id)} = $tempIMU{$nodeid};
    $$info_ref{"Ndb_index_memory_used"} += $tempIMU{$nodeid};
    $$info_ref{"Ndb_data_memory_total_node_" . sprintf("%02s", $id)} = $tempDMT{$nodeid};
    $$info_ref{"Ndb_data_memory_total"} += $tempDMT{$nodeid};
    $$info_ref{"Ndb_index_memory_total_node_" . sprintf("%02s", $id)} = $tempIMT{$nodeid};
    $$info_ref{"Ndb_index_memory_total"} += $tempIMT{$nodeid};

    $$info_ref{"Ndb_operations_old_node_" . sprintf("%02s", $id)} = $tempOperations{$nodeid};
    $$info_ref{"Ndb_operations_old"} += defined $tempOperations{$nodeid} ? $tempOperations{$nodeid} : 0;

    $$info_ref{"Ndb_trans_count_old_node_" . sprintf("%02s", $id)} = defined $tempTransCount{$nodeid} ? $tempTransCount{$nodeid} : 0;
    $$info_ref{"Ndb_trans_count_old"} += defined $tempTransCount{$nodeid} ? $tempTransCount{$nodeid} : 0;
    $$info_ref{"Ndb_commit_count_old_node_" . sprintf("%02s", $id)} = defined $tempCommitCount{$nodeid} ? $tempCommitCount{$nodeid} : 0;
    $$info_ref{"Ndb_commit_count_old"} += defined $tempCommitCount{$nodeid} ? $tempCommitCount{$nodeid} : 0;
    $$info_ref{"Ndb_read_count_old_node_" . sprintf("%02s", $id)} = defined $tempReadCount{$nodeid} ? $tempReadCount{$nodeid} : 0;
    $$info_ref{"Ndb_read_count_old"} += defined $tempReadCount{$nodeid} ? $tempReadCount{$nodeid} : 0;
    $$info_ref{"Ndb_simple_read_count_old_node_" . sprintf("%02s", $id)} = defined $tempSimpleReadCount{$nodeid} ? $tempSimpleReadCount{$nodeid} : 0;
    $$info_ref{"Ndb_simple_read_count_old"} += defined $tempSimpleReadCount{$nodeid} ? $tempSimpleReadCount{$nodeid} : 0;
    $$info_ref{"Ndb_write_count_old_node_" . sprintf("%02s", $id)} = defined $tempWriteCount{$nodeid} ? $tempWriteCount{$nodeid} : 0;
    $$info_ref{"Ndb_write_count_old"} += defined $tempWriteCount{$nodeid} ? $tempWriteCount{$nodeid} : 0;
    $$info_ref{"Ndb_attr_info_count_old_node_" . sprintf("%02s", $id)} = defined $tempAttrInfoCount{$nodeid} ? $tempAttrInfoCount{$nodeid} : 0;
    $$info_ref{"Ndb_attr_info_count_old"} += defined $tempAttrInfoCount{$nodeid} ? $tempAttrInfoCount{$nodeid} : 0;
    $$info_ref{"Ndb_concurrent_operations_old_node_" . sprintf("%02s", $id)} = defined $tempConcurrentOperations{$nodeid} ? $tempConcurrentOperations{$nodeid} : 0;
    $$info_ref{"Ndb_concurrent_operations_old"} += defined $tempConcurrentOperations{$nodeid} ? $tempConcurrentOperations{$nodeid} : 0;
    $$info_ref{"Ndb_abort_count_old_node_" . sprintf("%02s", $id)} = defined $tempAbortCount{$nodeid} ? $tempAbortCount{$nodeid} : 0;
    $$info_ref{"Ndb_abort_count_old"} += defined $tempAbortCount{$nodeid} ? $tempAbortCount{$nodeid} : 0;
    $$info_ref{"Ndb_scans_old_node_" . sprintf("%02s", $id)} = defined $tempScans{$nodeid} ? $tempScans{$nodeid} : 0;
    $$info_ref{"Ndb_scans_old"} += defined $tempScans{$nodeid} ? $tempScans{$nodeid} : 0;
    $$info_ref{"Ndb_range_scans_old_node_" . sprintf("%02s", $id)} = defined $tempRangeScans{$nodeid} ? $tempRangeScans{$nodeid} : 0;
    $$info_ref{"Ndb_range_scans_old"} += defined $tempRangeScans{$nodeid} ? $tempRangeScans{$nodeid} : 0;

    $id++;
  }

  if ( $main::gParameter{'Debug'} == DBG ) {

    &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, DBG, 'Cluster Info:');
    foreach my $key ( keys %$info_ref ) {

      &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, DBG, "key: $key, value: $$info_ref{$key}");
    }
  }
}

sub processNdbInformation
{
  my $rc = 0;

  if ( $main::gParameter{'Debug'} >= INFO ) { &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, INFO, '    ' . (caller(0))[3] . " with type " . $main::gParameter{'Type'}); }

  my %gGlobalVariables;
  my %gGlobalStatus;
  my %gClusterInfo;
  my %gEngineNdbStatus;

  if ( $main::gParameter{'Type'} eq 'mysqld' ) {

    my @aGlobalStatusToSend = (
      'Ndb_connect_count'
    , 'Ndb_execute_count'
    , 'Ndb_number_of_data_nodes'
    , 'Ndb_number_of_ready_data_nodes'
    , 'Ndb_number_of_down_data_nodes'
    , 'Ndb_scan_count'
    , 'Ndb_pruned_scan_count'
    );

    my @aGlobalVariablesToSend = (
      'ndb_cluster_connection_pool'
    );

    my @aEngineNdbStatusToSend = (
      'NdbTransactionCreated'
    , 'NdbOperationCreated'
    , 'NdbIndexScanOperationCreated'
    , 'NdbIndexOperationCreated'
    , 'NdbRecAttrCreated'
    , 'NdbApiSignalCreated'
    , 'NdbLabelCreated'
    , 'NdbBranchCreated'
    , 'NdbSubroutineCreated'
    , 'NdbCallCreated'
    , 'NdbBlobCreated'
    , 'NdbReceiverCreated'
    );

    &FromDualMySQLagent::initValues(\%gGlobalVariables, \@aGlobalVariablesToSend);
    &FromDualMySQLagent::initValues(\%gGlobalStatus, \@aGlobalStatusToSend);
    &FromDualMySQLagent::initValues(\%gEngineNdbStatus, \@aEngineNdbStatusToSend);

    my $dbh = &FromDualMySQLagent::getDatabaseConnection(%main::gParameter);

    if ( ! defined($dbh) ) {
      $rc = 2300;
      if ( $main::gParameter{'Debug'} >= ERR ) { &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, DBG, "    Database connection failed (rc=$rc)."); }
      return $rc;
    }

    &FromDualMySQLagent::getGlobalVariables($dbh, \%gGlobalVariables);
    &FromDualMySQLagent::getGlobalStatus($dbh, \%gGlobalStatus);
    &getShowEngineNdbStatus($dbh, \%gEngineNdbStatus);

    &FromDualMySQLagent::releaseDatabaseConnection($dbh);

    # Do some post calculations
    $gGlobalStatus{'Ndb_number_of_down_data_nodes'} = $gGlobalStatus{'Ndb_number_of_data_nodes'} - $gGlobalStatus{'Ndb_number_of_ready_data_nodes'};

    &sendData::sendData(\%gGlobalVariables, \@aGlobalVariablesToSend);
    &sendData::sendData(\%gGlobalStatus, \@aGlobalStatusToSend);
    &sendData::sendData(\%gEngineNdbStatus, \@aEngineNdbStatusToSend);
  }
  elsif ( $main::gParameter{'Type'} eq 'ndbd' ) {

    my @aGlobalVariablesToSend = (
    );

    my @aClusterInfoToSend = (
      'Ndb_data_memory_used'
    , 'Ndb_index_memory_used'
    , 'Ndb_index_memory_total'
    , 'Ndb_data_memory_total'
    , 'Ndb_operations'
    , 'Ndb_trans_count'
    , 'Ndb_attr_info_count'
    , 'Ndb_concurrent_operations'
    , 'Ndb_abort_count'
    , 'Ndb_write_count'
    , 'Ndb_commit_count'
    , 'Ndb_read_count'
    , 'Ndb_simple_read_count'
    , 'Ndb_range_scans'
    , 'Ndb_scans'
    , 'Ndb_operations_old'
    , 'Ndb_trans_count_old'
    , 'Ndb_attr_info_count_old'
    , 'Ndb_concurrent_operations_old'
    , 'Ndb_abort_count_old'
    , 'Ndb_write_count_old'
    , 'Ndb_commit_count_old'
    , 'Ndb_read_count_old'
    , 'Ndb_simple_read_count_old'
    , 'Ndb_range_scans_old'
    , 'Ndb_scans_old'
    );

    &FromDualMySQLagent::initValues(\%gGlobalVariables, \@aGlobalVariablesToSend);
    &FromDualMySQLagent::initValues(\%gClusterInfo, \@aClusterInfoToSend);

    my $dbh = &FromDualMySQLagent::getDatabaseConnection(%main::gParameter);

    if ( ! defined($dbh) ) {
      $rc = 2303;
      if ( $main::gParameter{'Debug'} >= ERR ) { &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, DBG, "    Database connection failed (rc=$rc)."); }
      return $rc;
    }

    &FromDualMySQLagent::getGlobalVariables($dbh, \%gGlobalVariables);

    # New style: gather data over ndbinfo database
    if ( defined($gGlobalVariables{'ndbinfo_database'}) && ($gGlobalVariables{'ndbinfo_database'} eq 'ndbinfo') ) {

      if ( $main::gParameter{'Debug'} >= INFO ) {
        &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, INFO, 'Using ndbinfo');
      }
      &getNdbInfo($dbh, \%gClusterInfo);
    }
    # Old style: parse the cluster log.
    else {
      if ( $main::gParameter{'Debug'} >= INFO ) {
        &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, INFO, 'Using cluster log');
      }
      &parseClusterLog(\%gClusterInfo);
    }

    &FromDualMySQLagent::releaseDatabaseConnection($dbh);
    &sendData::sendData(\%gClusterInfo, \@aClusterInfoToSend);
  }
  else {
    &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, WARN, "Unknown section type " . $main::gParameter{'Type'});
  }
  return $rc;
}

1;
__END__

