package FromDualMySQLmysql;

#
# Copyright (C) 2010, 2011, 2012 FromDual GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 2 of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.
# If not, see <http://www.gnu.org/licenses/>.
#

use strict;
use warnings;

use FromDualMySQLagent ':stooges';
use sendData;

sub processMysqlInformation
{
  if ( $main::gParameter{'Debug'} >= INFO ) { &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, INFO, '    ' . (caller(0))[3]); }

  my $rc = 0;

  my %hGlobalVariables;
  my %hGlobalStatus;

  my @aGlobalVariablesToSend = (
    'alive'
  , 'character_set_server'
  , 'datadir'
  , 'default_storage_engine'
  , 'event_scheduler'
  , 'foreign_key_checks'
  , 'general_log'
  , 'log_output'
  , 'log_queries_not_using_indexes'
  , 'log_slave_updates'
  , 'log_warnings'
  , 'long_query_time'
  , 'max_allowed_packet'
  , 'max_connections'
  , 'max_user_connections'
  , 'max_heap_table_size'
  , 'mr_version'
  , 'open_files_limit'
  , 'query_cache_size'
  , 'query_cache_type'
  , 'read_buffer_size'
  , 'skip_networking'
  , 'slow_query_log'
  , 'sort_buffer_size'
  , 'sql_mode'
  , 'table_cache'
  , 'table_definition_cache'
  , 'table_open_cache'
  , 'thread_cache_size'
  , 'thread_stack'
  , 'tx_isolation'
  , 'tmp_table_size'
  , 'version'
  );

  my @aGlobalStatusToSend = (
    'Aborted_clients'
  , 'Access_denied_errors'
  , 'Aborted_connects'
  , 'Binlog_bytes_written'   # MariaDB
  , 'Binlog_cache_disk_use'
  , 'Binlog_cache_use'
  , 'Binlog_stmt_cache_disk_use'
  , 'Binlog_stmt_cache_use'
  , 'Bytes_received'
  , 'Bytes_sent'
  , 'Com_call_proc'
  , 'Com_delete'
  , 'Com_delete_multi'
  , 'Com_insert'
  , 'Com_insert_select'
  , 'Com_replace'
  , 'Com_replace_select'
  , 'Com_select'
  , 'Com_update'
  , 'Com_update_multi'
  , 'Connections'
  , 'Created_tmp_disk_tables'
  , 'Created_tmp_files'
  , 'Created_tmp_tables'
  , 'Handler_delete'
  , 'Handler_read_first'
  , 'Handler_read_key'
  , 'Handler_read_last'
  , 'Handler_read_next'
  , 'Handler_read_prev'
  , 'Handler_read_rnd'
  , 'Handler_read_rnd_next'
  , 'Handler_update'
  , 'Handler_write'
  , 'Max_used_connections'
  , 'Opened_files'
  , 'Opened_tables'
  , 'Opened_table_definitions'
  , 'Open_files'
  , 'Open_tables'
  , 'Open_table_definitions'
  , 'Qcache_block_per_query'
  , 'Qcache_byte_per_block'
  , 'Qcache_free_blocks'
  , 'Qcache_free_memory'
  , 'Qcache_hits'
  , 'Qcache_inserts'
  , 'Qcache_lowmem_prunes'
  , 'Qcache_not_cached'
  , 'Qcache_queries_in_cache'
  , 'Qcache_total_blocks'
  , 'Qcache_used_blocks'
  , 'Qcache_used_memory'
  , 'Queries'
  , 'Questions'
  , 'Select_full_join'
  , 'Select_full_range_join'
  , 'Select_range_check'
  , 'Select_scan'
  , 'Slow_queries'
  , 'Sort_merge_passes'
  , 'Sort_range'
  , 'Sort_rows'
  , 'Sort_scan'
  , 'Table_locks_immediate'
  , 'Table_locks_waited'
  , 'Threads_cached'
  , 'Threads_connected'
  , 'Threads_created'
  , 'Threads_running'
  , 'Uptime'
  );

  &FromDualMySQLagent::initValues(\%hGlobalVariables, \@aGlobalVariablesToSend);
  &FromDualMySQLagent::initValues(\%hGlobalStatus, \@aGlobalStatusToSend);

  # This should be done automatically by initValues
  # $hGlobalVariables{'alive'} = 0;
  my $dbh = &FromDualMySQLagent::getDatabaseConnection(%main::gParameter);

  if ( ! defined($dbh) ) {
    $rc = 2400;
    if ( $main::gParameter{'Debug'} >= ERR ) { &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, DBG, "    Database connection failed (rc=$rc)."); }
    return $rc;
  }

  # &FromDualMySQLagent::getGlobalVariables(\%main::gParameter, $dbh, \%hGlobalVariables);
  &FromDualMySQLagent::getGlobalVariables($dbh, \%hGlobalVariables);
  &FromDualMySQLagent::getGlobalStatus($dbh, \%hGlobalStatus);

  &FromDualMySQLagent::releaseDatabaseConnection($dbh);

  # Do some post calculations

  my $count = keys %hGlobalVariables;
  if ( $count > 0 ) {
    $hGlobalVariables{'alive'} = 1;

    # Set it to a value otherwise we get an error message!
    if ( $hGlobalVariables{'sql_mode'} eq '' ) {
      $hGlobalVariables{'sql_mode'} = 'none';
    }
  }
  if ( $hGlobalVariables{'version'} =~ /([0-9]{1,2}).([0-9]{1,2}).([0-9]{1,2})/ ) {
    $hGlobalVariables{'mr_version'} = sprintf("%02d%02d%02d", $1, $2, $3);
  }
  else {
    $hGlobalVariables{'mr_version'} = 'error';
  }
  $hGlobalStatus{'Qcache_used_blocks'}     = $hGlobalStatus{'Qcache_total_blocks'} - $hGlobalStatus{'Qcache_free_blocks'};
  $hGlobalStatus{'Qcache_used_memory'}     = $hGlobalVariables{'query_cache_size'} - $hGlobalStatus{'Qcache_free_memory'};
  if ( $hGlobalStatus{'Qcache_used_blocks'} == 0 ) {
    $hGlobalStatus{'Qcache_byte_per_block'}  = 0;
  }
  else {
    $hGlobalStatus{'Qcache_byte_per_block'}  = int($hGlobalStatus{'Qcache_used_memory'} / $hGlobalStatus{'Qcache_used_blocks'});
  }
  if ( $hGlobalStatus{'Qcache_queries_in_cache'} == 0 ) {
    $hGlobalStatus{'Qcache_block_per_query'} = 0;
  }
  else {
    $hGlobalStatus{'Qcache_block_per_query'} = int($hGlobalStatus{'Qcache_used_blocks'} / $hGlobalStatus{'Qcache_queries_in_cache'});
  }
  $hGlobalVariables{'default_storage_engine'} = $hGlobalVariables{'default_storage_engine'} eq '0' ? $hGlobalVariables{'storage_engine'} : $hGlobalVariables{'default_storage_engine'};
  $hGlobalVariables{'log_output'} = $hGlobalVariables{'log_output'} eq '0' ? 'FILE' : $hGlobalVariables{'log_output'};

  &sendData::sendData(\%hGlobalVariables, \@aGlobalVariablesToSend);
  &sendData::sendData(\%hGlobalStatus, \@aGlobalStatusToSend);

  return $rc;
}

1;
__END__

