package FromDualMySQLmyisam;

#
# Copyright (C) 2010, 2011, 2012 FromDual GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 2 of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.
# If not, see <http://www.gnu.org/licenses/>.
#

use strict;
use warnings;

use FromDualMySQLagent ':stooges';
use POSIX qw(floor);
use sendData;

sub processMyisamInformation
{
  if ( $main::gParameter{'Debug'} >= INFO ) { &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, INFO, '    ' . (caller(0))[3]); }

  my $rc = 0;

  my %hGlobalVariables;
  my %hGlobalStatus;

  my @aGlobalVariablesToSend = (
    'key_buffer_size'
  , 'key_buffer_blocks'
  , 'key_cache_block_size'
  , 'flush_time'
  );

  my @aGlobalStatusToSend = (
    'Key_blocks_not_flushed'
  , 'Key_blocks_unused'
  , 'Key_blocks_not_flushed'
  , 'Key_blocks_unused'
  , 'Key_blocks_used'
  , 'Key_blocks_used_now'
  , 'Key_blocks_warm'
  , 'Key_blocks_not_flushed_b'
  , 'Key_blocks_unused_b'
  , 'Key_blocks_not_flushed_b'
  , 'Key_blocks_unused_b'
  , 'Key_blocks_used_b'
  , 'Key_blocks_used_now_b'
  , 'Key_blocks_warm_b'
  , 'Key_buffer_hit_rate'
  , 'Key_read_requests'
  , 'Key_reads'
  , 'Key_write_requests'
  , 'Key_writes'
  );

  &FromDualMySQLagent::initValues(\%hGlobalVariables, \@aGlobalVariablesToSend);
  &FromDualMySQLagent::initValues(\%hGlobalStatus, \@aGlobalStatusToSend);

  my $dbh = &FromDualMySQLagent::getDatabaseConnection(%main::gParameter);

  if ( ! defined($dbh) ) {
    $rc = 2500;
    if ( $main::gParameter{'Debug'} >= ERR ) { &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, DBG, "    Database connection failed (rc=$rc)."); }
    return $rc;
  }

  &FromDualMySQLagent::getGlobalVariables($dbh, \%hGlobalVariables);
  &FromDualMySQLagent::getGlobalStatus($dbh, \%hGlobalStatus);

  &FromDualMySQLagent::releaseDatabaseConnection($dbh);

  # Do some post calculations
  $hGlobalVariables{'key_buffer_blocks'} = $hGlobalVariables{'key_cache_block_size'} == 0 ? 0 : floor($hGlobalVariables{'key_buffer_size'} / $hGlobalVariables{'key_cache_block_size'});
  $hGlobalStatus{'Key_blocks_used_now'}  = $hGlobalVariables{'key_buffer_blocks'} - $hGlobalStatus{'Key_blocks_unused'};
  $hGlobalStatus{'Key_blocks_not_flushed_b'} = $hGlobalVariables{'key_cache_block_size'} * $hGlobalStatus{'Key_blocks_not_flushed'};
  $hGlobalStatus{'Key_blocks_unused_b'} = $hGlobalVariables{'key_cache_block_size'} * $hGlobalStatus{'Key_blocks_unused'};
  $hGlobalStatus{'Key_blocks_used_b'} = $hGlobalVariables{'key_cache_block_size'} * $hGlobalStatus{'Key_blocks_used'};
  $hGlobalStatus{'Key_blocks_used_now_b'} = $hGlobalVariables{'key_cache_block_size'} * $hGlobalStatus{'Key_blocks_used_now'};
  $hGlobalStatus{'Key_blocks_warm_b'} = $hGlobalVariables{'key_cache_block_size'} * $hGlobalStatus{'Key_blocks_warm'};

  if ( ($hGlobalStatus{'Key_read_requests'} + $hGlobalStatus{'Key_reads'}) == 0 ) {
    $hGlobalStatus{'Key_buffer_hit_rate'} = 0.0;
  }
  else {
    $hGlobalStatus{'Key_buffer_hit_rate'} = $hGlobalStatus{'Key_read_requests'} / ($hGlobalStatus{'Key_read_requests'} + $hGlobalStatus{'Key_reads'}) * 100.0;
  }

  &sendData::sendData(\%hGlobalVariables, \@aGlobalVariablesToSend);
  &sendData::sendData(\%hGlobalStatus, \@aGlobalStatusToSend);

  return $rc;
}

1;
__END__
