package FromDualMySQLmpm;

#
# Copyright (C) 2010, 2011, 2012 FromDual GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 2 of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.
# If not, see <http://www.gnu.org/licenses/>.
#

use strict;
use warnings;

use FromDualMySQLagent ':stooges';
use sendData;

sub processMpmInformation
{
  if ( $main::gParameter{'Debug'} >= INFO ) { &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, INFO, '    ' . (caller(0))[3]); }

  my %hGlobalVariables;

  my @aGlobalVariablesToSend = (
    'mpm_version'
  , 'mpm_mr_version'
  );

  &FromDualMySQLagent::initValues(\%hGlobalVariables, \@aGlobalVariablesToSend);

  # Do some post calculations

  $hGlobalVariables{'mpm_version'} = '0.9.2';

  if ( $hGlobalVariables{'mpm_version'} =~ /([0-9]{1,2}).([0-9]{1,2})(.([0-9]{1,2}))?/ ) {

    if ( defined($3) ) {
      $hGlobalVariables{'mpm_mr_version'} = sprintf("%02d%02d%02d", $1, $2, $4);
    }
    else {
      $hGlobalVariables{'mpm_mr_version'} = sprintf("%02d%02d%02d", $1, $2, 0);
    }
  }
  else {
    $hGlobalVariables{'mpm_mr_version'} = 'error: ' . $hGlobalVariables{'mpm_version'};
  }

  &sendData::sendData(\%hGlobalVariables, \@aGlobalVariablesToSend);
}

1;
__END__
