package FromDualMySQLmaster;

#
# Copyright (C) 2010, 2011, 2012 FromDual GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 2 of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.
# If not, see <http://www.gnu.org/licenses/>.
#

use strict;
use warnings;

use FromDualMySQLagent ':stooges';
use sendData;

sub getMasterStatus
{
  my $dbh = shift;
  my $status_ref = shift;

  if ( $main::gParameter{'Debug'} >= INFO ) { &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, INFO, '    ' . (caller(0))[3]); }

  # +----------------+----------+--------------+------------------+
  # | File           | Position | Binlog_Do_DB | Binlog_Ignore_DB |
  # +----------------+----------+--------------+------------------+
  # | bin-log.000001 |     1676 |              |                  |
  # +----------------+----------+--------------+------------------+

  $$status_ref{'Binlog_position'} = '0';
  $$status_ref{'Binlog_file'} = '';
  $$status_ref{'Binlog_number'} = '0';
  $$status_ref{'Binlog_do_filter'} = '';
  $$status_ref{'Binlog_ignore_filter'} = '';

  my $sql = 'SHOW MASTER STATUS';
  my $sth = $dbh->prepare($sql);
  if ( $sth->execute() )
  {
    if ( my $ref = $sth->fetchrow_hashref() )
    {
      $$status_ref{'Binlog_position'} = $ref->{'Position'};
      $$status_ref{'Binlog_file'} = $ref->{'File'};
      if ( $$status_ref{'Binlog_file'} =~ m/^.*\.(\d{4,6})$/ )
      {
        $$status_ref{'Binlog_number'} = $1+0;
      }
      $$status_ref{'Binlog_do_filter'} = $ref->{'Binlog_Do_DB'};
      $$status_ref{'Binlog_ignore_filter'} = $ref->{'Binlog_Ignore_DB'};
    }
    $sth->finish();
  }

  if ( $main::gParameter{'Debug'} == DBG )
  {
    &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, DBG, '    Master status:');
    foreach my $key ( keys %$status_ref )
    {
      &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, DBG, "      key: $key, value: $$status_ref{$key}");
    }
  }
}

sub getBinaryLogs
{
  my $dbh = shift;
  my $status_ref = shift;

  if ( $main::gParameter{'Debug'} >= INFO ) { &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, INFO, '    ' . (caller(0))[3]); }

  # +----------------+-----------+
  # | Log_name       | File_size |
  # +----------------+-----------+
  # | bin-log.000001 |      1717 |
  # | bin-log.000002 |       107 |
  # +----------------+-----------+

  $$status_ref{'Binlog_count'} = '0';
  $$status_ref{'Binlog_total_size'} = '0';

  my $sql = 'SHOW BINARY LOGS';
  my $sth = $dbh->prepare($sql);
  if ( $sth->execute() )
  {
    while ( my $ref = $sth->fetchrow_hashref() )
    {
      $$status_ref{'Binlog_count'} += 1;
      $$status_ref{'Binlog_total_size'} += $ref->{'File_size'};
    }
    $sth->finish();
  }

  if ( $main::gParameter{'Debug'} == DBG )
  {
    &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, DBG, '    Master status:');
    foreach my $key ( keys %$status_ref )
    {
      &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, DBG, "      key: $key, value: $$status_ref{$key}");
    }
  }
}

sub getSlaveCount
{
  my $dbh = shift;
  my $status_ref = shift;

  if ( $main::gParameter{'Debug'} >= INFO ) { &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, INFO, '    ' . (caller(0))[3]); }

  # +------------+-----------+------+-----------+
  # | Server_id  | Host      | Port | Master_id |
  # +------------+-----------+------+-----------+
  # |  192168010 | iconnect2 | 3306 | 192168011 |
  # | 1921680101 | athena    | 3306 | 192168011 |
  # +------------+-----------+------+-----------+

  $$status_ref{'Slave_count'} = '0';

  my $sql = 'SHOW SLAVE HOSTS';
  my $sth = $dbh->prepare($sql);
  if ( $sth->execute() )
  {
    while ( my $ref = $sth->fetchrow_hashref() )
    {
      $$status_ref{'Slave_count'} += 1;
    }
    $sth->finish();
  }

  if ( $main::gParameter{'Debug'} == DBG )
  {
    &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, DBG, '    Master status:');
    foreach my $key ( keys %$status_ref )
    {
      &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, DBG, "      key: $key, value: $$status_ref{$key}");
    }
  }
}

sub processMasterInformation
{
  my $rc = 0;
  if ( $main::gParameter{'Debug'} >= INFO ) { &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, INFO, '    ' . (caller(0))[3]); }

  my %hMasterStatus;
  my %hGlobalVariables;

  my @aMasterStatusToSend = (
    'Binlog_avg_event_size'
  , 'Binlog_count'
  , 'Binlog_do_filter'
  , 'Binlog_ignore_filter'
  , 'Binlog_event_count'
  , 'Binlog_file'
  , 'Binlog_number'
  , 'Binlog_position'
  , 'Binlog_total_size'
  , 'Slave_count'
  );

  my @aGlobalVariablesToSend = (
    'auto_increment_increment'
  , 'auto_increment_offset'
  , 'binlog_row_image'
  , 'binlog_format'
  , 'binlog_cache_size'
  , 'binlog_stmt_cache_size'
  , 'expire_logs_days'
  , 'log_bin'
  , 'sync_binlog'
  , 'sync_master_info'
  );

  &FromDualMySQLagent::initValues(\%hMasterStatus, \@aMasterStatusToSend);
  &FromDualMySQLagent::initValues(\%hGlobalVariables, \@aGlobalVariablesToSend);

  # Set default values

  $hGlobalVariables{'binlog_row_image'} = 'FULL';
  $hGlobalVariables{'binlog_format'}    = 'STATEMENT';

  my $dbh = &FromDualMySQLagent::getDatabaseConnection(%main::gParameter);

  if ( ! defined($dbh) ) {
    $rc = 1802;
    if ( $main::gParameter{'Debug'} >= ERR ) { &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, DBG, "    Database connection failed (rc=$rc)."); }
    return $rc;
  }

  &getMasterStatus($dbh, \%hMasterStatus);
  &getBinaryLogs($dbh, \%hMasterStatus);
  &getSlaveCount($dbh, \%hMasterStatus);

  &FromDualMySQLagent::getGlobalVariables($dbh, \%hGlobalVariables);

  &FromDualMySQLagent::releaseDatabaseConnection($dbh);

  # Do some post calculations
  if ( $hMasterStatus{'Binlog_file'} eq '' ) {
    $hMasterStatus{'Binlog_file'} = 'none';
  }

  &sendData::sendData(\%hMasterStatus, \@aMasterStatusToSend);
  &sendData::sendData(\%hGlobalVariables, \@aGlobalVariablesToSend);
  return $rc;
}

1;
__END__
