package FromDualMySQLgalera;

#
# Copyright (C) 2010, 2011, 2012 FromDual GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 2 of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.
# If not, see <http://www.gnu.org/licenses/>.
#

use strict;
use warnings;

use FromDualMySQLagent ':stooges';
use sendData;

sub processGaleraInformation
{
  if ( $main::gParameter{'Debug'} >= INFO ) { &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, INFO, '    ' . (caller(0))[3]); }

  my $rc = 0;

  my %hGlobalVariables;
  my %hGlobalStatus;

  my @aGlobalVariablesToSend = (
    'wsrep_auto_increment_control'
  , 'wsrep_causal_reads'
  , 'wsrep_cluster_address'
  , 'wsrep_cluster_name'
  , 'wsrep_node_name'
  , 'wsrep_on'
  , 'wsrep_provider'
  , 'wsrep_provider_options'
  , 'wsrep_slave_threads'
  , 'wsrep_sst_method'
  , 'wsrep_sst_receive_address'
  );

  my @aGlobalStatusToSend = (
    'wsrep_apply_oooe'
  , 'wsrep_apply_oool'
  , 'wsrep_apply_window'
  , 'wsrep_cert_deps_distance'
  , 'wsrep_cert_index_size'
  , 'wsrep_cluster_conf_id'
  , 'wsrep_cluster_size'
  , 'wsrep_cluster_status'
  , 'wsrep_commit_oooe'
  , 'wsrep_commit_oool'
  , 'wsrep_commit_window'
  , 'wsrep_connected'
  , 'wsrep_flow_control_paused'
  , 'wsrep_flow_control_recv'
  , 'wsrep_flow_control_sent'
  , 'wsrep_flow_control_waits'
  , 'wsrep_last_committed'
  , 'wsrep_local_bf_aborts'
  , 'wsrep_local_cert_failures'
  , 'wsrep_local_commits'
  , 'wsrep_local_recv_queue'
  , 'wsrep_local_recv_queue_avg'
  , 'wsrep_local_send_queue'
  , 'wsrep_local_send_queue_avg'
  , 'wsrep_local_state'
  , 'wsrep_local_state_comment'
  , 'wsrep_local_status'
  , 'wsrep_protocol_version'
  , 'wsrep_provider_version'
  , 'wsrep_provider_version_mr'
  , 'wsrep_ready'
  , 'wsrep_received'
  , 'wsrep_received_bytes'
  , 'wsrep_replicated'
  , 'wsrep_replicated_bytes'
  );

  &FromDualMySQLagent::initValues(\%hGlobalVariables, \@aGlobalVariablesToSend);
  &FromDualMySQLagent::initValues(\%hGlobalStatus, \@aGlobalStatusToSend);

  my $dbh = &FromDualMySQLagent::getDatabaseConnection(%main::gParameter);

  if ( ! defined($dbh) ) {
    $rc = 2700;
    if ( $main::gParameter{'Debug'} >= ERR ) { &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, DBG, "    Database connection failed (rc=$rc)."); }
    return $rc;
  }

  &FromDualMySQLagent::getGlobalVariables($dbh, \%hGlobalVariables);
  &FromDualMySQLagent::getGlobalStatus($dbh, \%hGlobalStatus);

  &FromDualMySQLagent::releaseDatabaseConnection($dbh);

  # Do some post calculations

  if ( $hGlobalStatus{'wsrep_provider_version'} =~ /([0-9]{1,2}).([0-9]{1,2}).([0-9]{1,2})/ ) {
    $hGlobalStatus{'wsrep_provider_version_mr'} = sprintf("%02d%02d%02d", $1, $2, $3);
  }
  else {
    $hGlobalStatus{'wsrep_provider_version_mr'} = 'error';
  }

  &sendData::sendData(\%hGlobalVariables, \@aGlobalVariablesToSend);
  &sendData::sendData(\%hGlobalStatus, \@aGlobalStatusToSend);

  return $rc;
}

1;
__END__

