package FromDualMySQLdrbd;

#
# Copyright (C) 2010, 2011, 2012 FromDual GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 2 of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.
# If not, see <http://www.gnu.org/licenses/>.
#

use strict;
use warnings;

use FromDualMySQLagent ':stooges';
use File::Which;
use sendData;

our @drbdData;
our @drbdDevices;
our $gVersion;

sub getDrbdOverview
{
  if ( $main::gParameter{'Debug'} >= DBG ) { &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, DBG, "getDrbdOverview"); }

  my $rc = 0;

  # 0:drbd_r1  Connected Secondary/Secondary UpToDate/UpToDate C r----
  # if not as root
  # 0:??not-found??  Connected Primary/Secondary UpToDate/UpToDate C r---- /mnt ext3 2.0G 350M 1.6G 19% 

  my @cmd = `which drbd-overview`;
  if ( @cmd == 0 ) {
    $rc = 2800;
    &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, ERR, "drbd-overview does not exist (rc=$rc).");
    return $rc;
  }
  chomp $cmd[0];

  my @stdout = `$cmd[0]`;

  foreach ( @stdout ) {

    chomp $_;
    if ( $main::gParameter{'Debug'} >= DBG ) {
      &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, DBG, $_);
    }

    if ( $_ =~ /^\s+(\d+):(\w+)\s+(\w+)\s+(\w+\/\w+)\s+(\w+\/\w+)\s+(\w)/ ||
         $_ =~ /^\s+(\d+):(\?\?not-found\?\?)\s+(\w+)\s+(\w+\/\w+)\s+(\w+\/\w+)\s+(\w)/ ) {

      push(@drbdDevices, $1);

      $drbdData[$1]{'name'} = $2;
      $drbdData[$1]{'cstate'} = $3;
      $drbdData[$1]{'role'} = $4;
      $drbdData[$1]{'dstate'} = $5;
      $drbdData[$1]{'protocol'} = $6;
      if ( $main::gParameter{'Debug'} >= DBG ) {
        &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, DBG, 'name   ' . $drbdData[$1]{'name'});
        &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, DBG, 'cstate ' . $drbdData[$1]{'cstate'});
        &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, DBG, 'role   ' . $drbdData[$1]{'role'});
        &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, DBG, 'dstate ' . $drbdData[$1]{'dstate'});
        &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, DBG, 'protocol ' . $drbdData[$1]{'protocol'});
      }
    }
  }
  return $rc;
}

sub getDrbdDetail
{
  if ( $main::gParameter{'Debug'} >= DBG ) { &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, DBG, "getDrbdDetail"); }

  my $rc = 0;

  # version: 8.3.8 (api:88/proto:86-94)GIT-hash: d78846e52224fd00562f7c225bcc25b2d422321d build by mockbuild@builder10.centos.org, 2010-06-04 08:04:09
  #  0: cs:Connected ro:Secondary/Secondary ds:UpToDate/UpToDate C r----
  #     ns:0 nr:0 dw:0 dr:0 al:0 bm:0 lo:0 pe:0 ua:0 ap:0 ep:1 wo:b oos:0

  my $file = '/proc/drbd';
  if ( ! -r $file ) {
    $rc = 2801;
    &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, ERR, "Cannot read on $file (rc=$rc).");
    return $rc;
  }

  my @stdout = `cat $file`;

  $_= $stdout[0];
  chomp;
  $gVersion = $_;

  my $device;

  for ( my $i = 1; $i < $#stdout; $i += 2 ) {

    # We are not intersted in 1st line because we got it already
    # with the drbd-overview command

    $_ = $stdout[$i+1];
    chomp;
    if ( $_ =~ /^\s+(\d+):/ ) {
      $device = $1;
    }
    else {
      &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, ERR, "$_");
    }

    # Parse the 2nd line now
    $_ = $stdout[$i+2];
    chomp;

    if ( $_ =~ /^\s+ns:(\d+)\s+nr:(\d+)\s+dw:(\d+)\s+dr:(\d+)\s+al:(\d+)\s+bm:(\d+)\s+lo:(\d+)\s+pe:(\d+)\s+ua:(\d+)\s+ap:(\d+)\s+ep:(\d+)\s+wo:(\w+)\s+oos:(\d+)/ ) {

      $drbdData[$device]{'ns'}  =  $1;
      $drbdData[$device]{'nr'}  =  $2;
      $drbdData[$device]{'dw'}  =  $3;
      $drbdData[$device]{'dr'}  =  $4;
      $drbdData[$device]{'al'}  =  $5;
      $drbdData[$device]{'bm'}  =  $6;
      $drbdData[$device]{'lo'}  =  $7;
      $drbdData[$device]{'pe'}  =  $8;
      $drbdData[$device]{'ua'}  =  $9;
      $drbdData[$device]{'ap'}  = $10;
      $drbdData[$device]{'ep'}  = $11;
      $drbdData[$device]{'wo'}  = $12;
      $drbdData[$device]{'oos'} = $13;

      if ( $main::gParameter{'Debug'} >= DBG ) {
        &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, DBG, 'ns  ' . $drbdData[$device]{'ns'});
        &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, DBG, 'nr  ' . $drbdData[$device]{'nr'});
        &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, DBG, 'dw  ' . $drbdData[$device]{'dw'});
        &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, DBG, 'dr  ' . $drbdData[$device]{'dr'});
        &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, DBG, 'al  ' . $drbdData[$device]{'al'});
        &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, DBG, 'bm  ' . $drbdData[$device]{'bm'});
        &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, DBG, 'lo  ' . $drbdData[$device]{'lo'});
        &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, DBG, 'pe  ' . $drbdData[$device]{'pe'});
        &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, DBG, 'ua  ' . $drbdData[$device]{'ua'});
        &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, DBG, 'ap  ' . $drbdData[$device]{'ap'});
        &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, DBG, 'ep  ' . $drbdData[$device]{'ep'});
        &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, DBG, 'wo  ' . $drbdData[$device]{'wo'});
        &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, DBG, 'oos ' . $drbdData[$device]{'oos'});
      }
    }
  }
  return $rc;
}

sub processDrbdInformation
{
  if ( $main::gParameter{'Debug'} >= INFO ) { &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, INFO, '    ' . (caller(0))[3]); }

  my $rc = 0;

  my %hDrbdStatus;
  my $ret = 0;

  $ret = &getDrbdOverview();
  if ( $ret != 0 ) {
    $rc = 2802;
    &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, ERR, "Error in getDrbdOverview (rc=$rc).");
    return $rc;
  }
  $ret = &getDrbdDetail();
  if ( $ret != 0 ) {
    $rc = 2803;
    &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, ERR, "Error in getDrbdDetail (rc=$rc).");
    return $rc;
  }

  my @aDrbdStatusToSend = (
    'version'
  );

  $hDrbdStatus{'version'} = $gVersion ;

  foreach my $device ( @drbdDevices ) {

    push(@aDrbdStatusToSend, 'name[' . $device . ']');
    $hDrbdStatus{'name[' . $device . ']'} = $drbdData[$device]{'name'};

    push(@aDrbdStatusToSend, 'cstate[' . $device . ']');
    $hDrbdStatus{'cstate[' . $device . ']'} = $drbdData[$device]{'cstate'};

    push(@aDrbdStatusToSend, 'role[' . $device . ']');
    $hDrbdStatus{'role[' . $device . ']'} = $drbdData[$device]{'role'};

    push(@aDrbdStatusToSend, 'dstate[' . $device . ']');
    $hDrbdStatus{'dstate[' . $device . ']'} = $drbdData[$device]{'dstate'};

    push(@aDrbdStatusToSend, 'protocol[' . $device . ']');
    $hDrbdStatus{'protocol[' . $device . ']'} = $drbdData[$device]{'protocol'};

    push(@aDrbdStatusToSend, 'ns[' . $device . ']');
    $hDrbdStatus{'ns[' . $device . ']'} = $drbdData[$device]{'ns'};

    push(@aDrbdStatusToSend, 'nr[' . $device . ']');
    $hDrbdStatus{'nr[' . $device . ']'} = $drbdData[$device]{'nr'};

    push(@aDrbdStatusToSend, 'dw[' . $device . ']');
    $hDrbdStatus{'dw[' . $device . ']'} = $drbdData[$device]{'dw'};

    push(@aDrbdStatusToSend, 'dr[' . $device . ']');
    $hDrbdStatus{'dr[' . $device . ']'} = $drbdData[$device]{'dr'};

    push(@aDrbdStatusToSend, 'al[' . $device . ']');
    $hDrbdStatus{'al[' . $device . ']'} = $drbdData[$device]{'al'};

    push(@aDrbdStatusToSend, 'bm[' . $device . ']');
    $hDrbdStatus{'bm[' . $device . ']'} = $drbdData[$device]{'bm'};

    push(@aDrbdStatusToSend, 'lo[' . $device . ']');
    $hDrbdStatus{'lo[' . $device . ']'} = $drbdData[$device]{'lo'};

    push(@aDrbdStatusToSend, 'pe[' . $device . ']');
    $hDrbdStatus{'pe[' . $device . ']'} = $drbdData[$device]{'pe'};

    push(@aDrbdStatusToSend, 'ua[' . $device . ']');
    $hDrbdStatus{'ua[' . $device . ']'} = $drbdData[$device]{'ua'};

    push(@aDrbdStatusToSend, 'ap[' . $device . ']');
    $hDrbdStatus{'ap[' . $device . ']'} = $drbdData[$device]{'ap'};

    push(@aDrbdStatusToSend, 'ep[' . $device . ']');
    $hDrbdStatus{'ep[' . $device . ']'} = $drbdData[$device]{'ep'};

    push(@aDrbdStatusToSend, 'wo[' . $device . ']');
    $hDrbdStatus{'wo[' . $device . ']'} = $drbdData[$device]{'wo'};

    push(@aDrbdStatusToSend, 'oos[' . $device . ']');
    $hDrbdStatus{'oos[' . $device . ']'} = $drbdData[$device]{'oos'};
  }

  &sendData::sendData(\%hDrbdStatus, \@aDrbdStatusToSend);
  return $rc;
}

1;
__END__

