package FromDualMySQLaria;

#
# Copyright (C) 2010, 2011, 2012 FromDual GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 2 of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.
# If not, see <http://www.gnu.org/licenses/>.
#

use strict;
use warnings;

use FromDualMySQLagent ':stooges';
use sendData;

sub processAriaInformation
{
  my $parameter_ref = shift;
  if ( $main::gParameter{'Debug'} >= INFO ) { &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, INFO, '    ' . (caller(0))[3]); }

  my $rc;

  my %hGlobalVariables;
  my %hGlobalStatus;

  my @aGlobalVariablesToSend = (
    'maria_pagecache_buffer_size'
  , 'maria_block_size'
  , 'maria_pagecache_blocks'
  , 'aria_pagecache_buffer_size'
  , 'aria_block_size'
  , 'aria_pagecache_blocks'
  );

  my @aGlobalStatusToSend = (
    'Maria_pagecache_blocks_not_flushed'
  , 'Maria_pagecache_blocks_unused'
  , 'Maria_pagecache_blocks_used'
  , 'Maria_pagecache_reads'
  , 'Maria_pagecache_read_requests'
  , 'Maria_pagecache_writes'
  , 'Maria_pagecache_write_requests'
  , 'Maria_transaction_log_syncs'
  , 'Aria_pagecache_blocks_not_flushed'
  , 'Aria_pagecache_blocks_unused'
  , 'Aria_pagecache_blocks_used'
  , 'Aria_pagecache_reads'
  , 'Aria_pagecache_read_requests'
  , 'Aria_pagecache_writes'
  , 'Aria_pagecache_write_requests'
  , 'Aria_transaction_log_syncs'
  );

  &FromDualMySQLagent::initValues(\%hGlobalVariables, \@aGlobalVariablesToSend);
  &FromDualMySQLagent::initValues(\%hGlobalStatus, \@aGlobalStatusToSend);

  my $dbh = &FromDualMySQLagent::getDatabaseConnection(%main::gParameter);

  if ( ! defined($dbh) ) {
    $rc = 2900;
    if ( $main::gParameter{'Debug'} >= ERR ) { &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, DBG, "    Database connection failed (rc=$rc)."); }
    return $rc;
  }

  &FromDualMySQLagent::getGlobalVariables($dbh, \%hGlobalVariables);
  &FromDualMySQLagent::getGlobalStatus($dbh, \%hGlobalStatus);

  &FromDualMySQLagent::releaseDatabaseConnection($dbh);

  # Do some post calculations

  $hGlobalVariables{'maria_pagecache_blocks'} = $hGlobalVariables{'maria_block_size'} == 0 ? 0 : int($hGlobalVariables{'maria_pagecache_buffer_size'} / $hGlobalVariables{'maria_block_size'});
  $hGlobalVariables{'aria_pagecache_blocks'}  = $hGlobalVariables{'aria_block_size'} == 0 ? 0 : int($hGlobalVariables{'aria_pagecache_buffer_size'} / $hGlobalVariables{'aria_block_size'});

  &sendData::sendData(\%hGlobalVariables, \@aGlobalVariablesToSend);
  &sendData::sendData(\%hGlobalStatus, \@aGlobalStatusToSend);

  return $rc;
}

1;
__END__
