#!/usr/bin/php
<?php -w

// $LICENSE$


// check if HTTP::Request::Common and LWP::Simple; exists and if not do a warning!!!

// http://www.perl.com/pub/2002/08/20/perlandlwp.html
// http://perl.active-venture.com/lib/HTTP/Request/Common.html
// http://stackoverflow.com/questions/3836526/how-do-i-send-post-data-with-lwp

use LWP 5.64;
use HTTP::Request::Common qw{ POST };
use Getopt::Long;
use File::Basename;

$MyName = basename($0);

// ---- Functions ----

sub Usage
{
    print("
SYNOPSIS

  $MyName flags

DESCRIPTION

  Sends MySQL Performance Monitor Agent cache file to remote Server via https

FLAGS

  file, f  Data file to send.
  hash     Hash value to authenticate.
  help, h  Print this help.
  url, u   URL where to upload.

PARAMETERS

  none

EXAMPLES

  $MyName --url=https://localhost/maas/receiver.php --hash=5499c0397021d002e0e3150944e53459 \\
          --file=/home/oli/fromdual_devel/support/test.cache

");
}

// ---- Start ----

$rc = 0;

$optHelp = 0;
$optFile = '';
$optHash = '';
$optUrl  = 'https://support.fromdual.com/maas/receiver.php';


$argc = $argv;

if( $argc == 0 ) {
  &Usage();
  exit $rc;
}

$ret = GetOptions( 'help|h|?' => $optHelp
                    , 'hash=s'   => $optHash
                    , 'file|f=s' => $optFile
                    , 'url|u=s'  => $optUrl
                    );

if ( ! $ret ) {
  $rc = 2005;
  &Usage();
  exit $rc;
}

if ( $optHelp ) {
  $rc = 0;
  &Usage();
  exit $rc;
}

if( $argv != 0 ) {
  $rc = 2006;
  &Usage();
  exit $rc;
}

if ( ($optHash == '') || (length($optHash) != 32) ) {
  $rc = 2008;
  print "ERROR: Hash value ($optHash) is empty or wrong (rc=$rc).\n";
  exit $rc;
}

if ( ($optFile == '') || (! -r $optFile) ) {
  $rc = 2007;
  print "ERROR: File ($optFile) does NOT exist or is not readable (rc=$rc).\n";
  exit $rc;
}

// ---- MAIN ----

$browser = LWP::UserAgent->new;    

if ( ! -r $optFile ) {
  $rc = 2004;
  print "ERROR: Cannot read file $optFile (rc=$rc).\n";
  exit $rc;
}

$response = $browser->request(POST $optUrl,
  Content_Type => 'form-data',
  Content      => [ hash  => $optHash,
                    data  => [$optFile],
                  ]); // ->as_string()

if ( ! $response->is_success ) {
  $rc = 2001;
  print "ERROR: $optUrl error: " . $response->status_line . " (rc=$rc)\n";
  exit $rc;
}
if ( $response->content_type != 'text/html' ) {
  $rc = 2002;
  print "ERROR: Weird content type at $optUrl: " . $response->content_type . " (rc=$rc)\n";
  exit $rc;
}

// Data loaded
if ( $response->content =~ /Data loaded successfully/ ) {
  // print "Data loaded.\n";
}
// Data load failed
else {
  $rc = 2003;
  print "ERROR: Data load failed. (rc=$rc)\n";
  print $response->content . "\n";
  exit $rc;
}

print "INFO: Data loaded successfully (rc=$rc).\n";
exit $rc;
