#!/usr/bin/perl

#
# Copyright (C) 2010, 2011, 2012 FromDual GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 2 of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.
# If not, see <http://www.gnu.org/licenses/>.
#

use strict;
use warnings;

require v5.6.0;

use Cwd 'abs_path';
use POSIX();

my $rc = 0;

my $lMyName = Cwd::abs_path(__FILE__);
my $lMyNameBase = basename($lMyName, '.pl');
my $basedir = dirname($lMyName);

# This is needed to find zabbix_sender!
$ENV{PATH} .= $ENV{PATH} . ':/usr/local/bin';

BEGIN {
  use File::Basename;
  unshift(@INC, dirname($0). '/lib');
}

use FromDualMySQLagent ':stooges';
use uploadData;

my $file = $ARGV[0];
my $lConfFile = '';
if ( defined($file) && ($file ne '') ) {
  $lConfFile = $file;
}
else {
  $lConfFile = $basedir . '/etc/' . $lMyNameBase . '.conf';
}

our $gDomain = 'FromDual.MySQL';
our $gRemoveLockFile = 0;

# POSIX unmasks the sigprocmask properly
$SIG{TERM} = sub {
  $rc = 1;
  print "got TERM signal.\n";
  print "Cleaning up stuff an exit.\n";
  &FromDualMySQLagent::cleanAndQuit($rc);
};

my @configuration = &FromDualMySQLagent::readConfigurationFile($lConfFile);
my @sections = &FromDualMySQLagent::getSections(@configuration);
# Read the default section here
my %defaults = &FromDualMySQLagent::getDefaultParameter(\@configuration, 'default');

our %gParameter = %defaults;

my $lDefaultsLogFile = $defaults{'LogFile'};
my $lDefaultsDebug   = $defaults{'Debug'};

# Touch logfile
if ( ! open(LOG, ">>", $lDefaultsLogFile) ) {
  $rc = 900;
  print "Open of file $lDefaultsLogFile failed (rc=$rc).\n$!\n";
  print "Possibly I cannot create this file because of missing privileges?\n";
  &FromDualMySQLagent::cleanAndQuit($rc);
}
close(LOG);

&FromDualMySQLagent::mylog($lDefaultsLogFile, INFO, "FromDual Performance Monitor for MySQL (0.9.2) run started.");
# Set Lock file here
&FromDualMySQLagent::setAgentLock($lDefaultsDebug, $lDefaultsLogFile);

### Check for required modules
# Exclude this to a separate function?
eval {
  # possibly require needed?
  use LWP 5.64;
  use HTTP::Request::Common qw{ POST };
  use File::Which;
};
if ( $@ ) {
  $rc = 901;
  &FromDualMySQLagent::mylog($main::gParameter{'LogFile'}, ERR, "Error some of the required perl modules are missing. Please look at the installation documentation to see which one is required (rc=$rc).");
  foreach my $key ( $@ ) {
    &FromDualMySQLagent::mylog($lDefaultsLogFile, ERR, $key);
  }
  &FromDualMySQLagent::removeAgentLock($lDefaultsDebug, $main::gParameter{'LogFile'});
  &FromDualMySQLagent::cleanAndQuit($rc);
}

###

if ( $lDefaultsDebug >= INFO ) {
  &FromDualMySQLagent::mylog($lDefaultsLogFile, INFO, "Read configuration from $lConfFile");
  &FromDualMySQLagent::mylog($lDefaultsLogFile, INFO, 'Sections found: ' . join(', ', @sections));
  &FromDualMySQLagent::mylog($lDefaultsLogFile, INFO, "Reading default section");
}
if ( $lDefaultsDebug >= DBG ) {

  foreach my $p ( keys %defaults) {

    # This would be possibly a security problem...
    if ( $p eq 'Password' ) {
      &FromDualMySQLagent::mylog($lDefaultsLogFile, DBG, "  $p - ********");
    }
    else {
      &FromDualMySQLagent::mylog($lDefaultsLogFile, DBG, "  $p - $defaults{$p}");
    }
  }
}

foreach my $section ( @sections ) {

  if ( $lDefaultsDebug >= INFO ) { &FromDualMySQLagent::mylog($lDefaultsLogFile, INFO, "Processing section $section now"); }

  # skip default section, we read it already above
  if ( $section eq 'default' ) {
    next;
  }

  my %parameter = &FromDualMySQLagent::getParameter(\@configuration, $section);

  if ( $parameter{'Debug'} == DBG ) {

    &FromDualMySQLagent::mylog($parameter{'LogFile'}, DBG, "The combined (default + section) parameters for section $section are:");
    foreach my $p ( keys %parameter ) {

      # This would be possibly a security problem...
      if ( $p eq 'Password' ) {
        &FromDualMySQLagent::mylog($parameter{'LogFile'}, DBG, "  $p - ********");
      }
      else {
        &FromDualMySQLagent::mylog($parameter{'LogFile'}, DBG, "  $p - $parameter{$p}");
      }
    }
  }

  # Skip section if it is disabled
  if ( $parameter{'Disabled'} eq 'true' ) {

    if ( $parameter{'Debug'} >= INFO ) {
      &FromDualMySQLagent::mylog($parameter{'LogFile'}, INFO, "  Skipping section: $section because it is disabled.");
    }
    next;
  }

  if ( $parameter{'Debug'} >= INFO ) { &FromDualMySQLagent::mylog($parameter{'LogFile'}, INFO, "Modules for section $section: " . $parameter{'Modules'}); }

  my @modules = split(/\s+/, $parameter{'Modules'});
  foreach my $module ( @modules ) {

    # FromDual.MySQL.xxx
    $parameter{'Domain'} = $gDomain . '.' . $module;

    if ( ($parameter{'Debug'} >= INFO) ) { &FromDualMySQLagent::mylog($parameter{'LogFile'}, INFO, "  Processing module $module for section $section now..."); }

    if ( ($module eq 'aria')
      || ($module eq 'drbd')
      || ($module eq 'galera')
      || ($module eq 'innodb')
      || ($module eq 'master')
      || ($module eq 'memcache')
      || ($module eq 'mpm')
      || ($module eq 'myisam')
      || ($module eq 'mysql')
      || ($module eq 'ndb')
      || ($module eq 'pbxt')
      || ($module eq 'process')
      || ($module eq 'security')
      || ($module eq 'server')
      || ($module eq 'slave')
        ) {

      my $class = 'FromDualMySQL' . $module;
      eval "require $class";
      if ( $@ ) {
        &FromDualMySQLagent::mylog($parameter{'LogFile'}, ERR, "Module FromDualMySQL" . $module . " does not exist.");
        foreach my $key ( $@ ) {
          &FromDualMySQLagent::mylog($parameter{'LogFile'}, ERR, $key);
        }
      }
      else {

        %gParameter = %parameter;
        # &FromDualMySQLmysql::processMysqlInformation(\%parameter);
        my $cmd = "&FromDualMySQL" . $module . "::process". ucfirst($module) . "Information(\%parameter);";
        # print "$cmd\n";
        eval $cmd;
        if ( $@ ) {
          $rc = 9998;
          &FromDualMySQLagent::mylog($parameter{'LogFile'}, ERR, "Module FromDualMySQL" . $module . " got a warning (rc=$rc):");
          foreach my $key ( $@ ) {
            &FromDualMySQLagent::mylog($parameter{'LogFile'}, ERR, $key);
          }
        }
        if ( $lDefaultsDebug >= INFO ) { &FromDualMySQLagent::mylog($parameter{'LogFile'}, INFO, "  Processing module $module for secion $section finished."); }
      }
    }   # call module
    else {
      $rc = 9999;
      &FromDualMySQLagent::mylog($parameter{'LogFile'}, ERR, "Module $module does not exist (rc=$rc).");
    }
  }   # module loop
}   # sections loop

&FromDualMySQLagent::removeAgentLock($lDefaultsDebug, $lDefaultsLogFile);
&FromDualMySQLagent::cleanAndQuit($rc);
