<?php

//
// Copyright (C) 2013, 2014 FromDual GmbH
//
// This program is commercial software. Use of this software is governed
// by your applicable license agreement with FromDual GmbH
//

logMessage(LOG_NOTICE, 'Begin page: ' . basename(__FILE__));
$gIndention += 2;

$hVipId = isset($_REQUEST['vip_id']) ? intval($_REQUEST['vip_id']) : 0;

list($ret, $aVips) = getVipsWithFilter($dbh, array('vip_id' => $hVipId));
$aVip = array_pop($aVips);
list($rc, $aServers) = getAllServers($dbh);

?>
<h2>Operations <?php print $aVip['ip_address']; ?></h2>
<?php

// print "<pre>"; print_r($aVips); print "</pre>";

?>
<table border="" cellpadding="3" cellspacing="0">
	<tr>
		<th>IP address</th>
		<th>interface</th>
		<th>type</th>
		<th>status</th>
		<th>primary</th>
		<th>failover</th>
		<th>location</th>
		<th>Operations</th>
	</tr>

	<tr>
		<td><?php print $aVip['ip_address']; ?></td>
		<td><?php print $aVip['interface'] . ':' . $aVip['alias']; ?></td>
		<?php

		if ( $aVip['ipaddr_type'] == OLD_VIP ) {
			$t = 'old';
		}
		else {
			$t = 'new';
		}

		?>
		<td><?php print $t; ?></td>
		<?php

		list($ret, $msg) = checkPing($aVip['ip_address']);
		if ( $ret == OK ) {
			$lVipStatus = 'UP';
			$color = 'green';
		}
		else {
			$lVipStatus = 'DOWN';
			$color = 'red';
		}
		
		?>
		<td><span style="color:<?php print $color; ?>;"><strong><?php print $lVipStatus; ?></strong></span></td>
		<td><?php print $aServers[$aVip['primary_id']]['name']; ?></td>
		<?php

		if ( $aVip['failover_id'] == 0 ) {
			$server = 'none'; 
		}
		else {
			$server = $aServers[$aVip['failover_id']]['name'];
		}
		?>
		<td><?php print $server; ?></td>
		<td><?php print $aServers[$aVip['location_id']]['name']; ?></td>
		<td>
			<select>
				<option>Please choose...</option>
				<?php
				
				// stop VIP

				$js = 'location.href="index.php?f=stop&amp;o=vip&amp;vip_id=' . $aVip['vip_id'] . '";';
				$disabled = '';
				if ( $lVipStatus == 'DOWN' ) {
					$disabled = 'disabled="disabled"';
				}
				?>
				<option <?php print $disabled; ?> onClick='<?php print $js; ?>'>Stop VIP</option>
				<?php

				// edit VIP
				// In case there is an IP outside of our access we have to
				// delete the VIP again. Thus never disable this button!

				$js = "location.href='index.php?f=edit&amp;o=vip&amp;vip_id=" . $aVip['vip_id'] . "';";
				?>
				<option onClick="<?php print $js; ?>">Edit VIP</option>
				<?php

				// start VIP

				$js = 'location.href="index.php?f=start&amp;o=vip&amp;vip_id=' . $aVip['vip_id'] . '";';
				$disabled = '';
				if ( $lVipStatus == 'UP' ) {
					$disabled = 'disabled="disabled"';
				}
				?>
				<option <?php print $disabled; ?> onClick='<?php print $js; ?>'>Start VIP</option>
				<?php

				// failover VIP

				$js = 'location.href="index.php?f=failover&amp;o=vip&amp;vip_id=' . $aVip['vip_id'] . '";';
				?>
				<option onClick='<?php print $js; ?>'>Failover VIP</option>
			</select>
		</td>
	</tr>
</table>
<?php

$gIndention -= 2;
logMessage(LOG_NOTICE, 'End page: ' . basename(__FILE__));

?>
