<?php

//
// Copyright (C) 2013, 2014 FromDual GmbH
//
// This program is commercial software. Use of this software is governed
// by your applicable license agreement with FromDual GmbH
//

logMessage(LOG_NOTICE, 'Begin page: ' . basename(__FILE__));
$gIndention += 2;

list($rc, $dbh) = openRepositoryDatabase();
list($rc, $aVips) = getVipsWithFilter($dbh, array('vip_id' => $hVipId));
$aVip = array_shift($aVips);
// print "<pre>"; print_r($aVip); print "</pre>";
closeRepositoryDatabase($dbh);


?>
<h1>Checks for VIP <?php print $aVip['ip_address'] . ' / ' . $aVip['name']; ?></h1>

<table border="1" cellpadding="3" cellspacing="0">
  <tr>
    <th align="left">Last Check</th>
    <th align="center">Status</th>
    <th align="left">Comment</th>
	</tr>
	<tr>
		<td>Service name</td>
		<?php

		$state = 'OK';
		$msg   = '';
		$color = 'green';

		list($ret, $ip) = checkHostname(array('name' => $aVip['name'], 'server_id' => 0));
		if ( $ret != OK ) {
			$state = 'ERR';
			$color = 'red';
			$msg = $ip;
		}

		?>
		<td align="center"><span style="color:<?php print $color; ?>; font-weight:bold;"><?php print $state; ?></style></td>
		<td><?php print $msg; ?></td>
	</tr>
	<tr>
		<td>VIP ping</td>
		<?php
		
		$state = 'OK';
		$msg   = '';
		$color = 'green';

		list($ret, $msg) = checkPing($aVip['ip_address']);
		if ( $ret != OK ) {
			$state = 'ERR';
			$color = 'red';
		}
		else {
			$msg = '';
		}
		
		?>
		<td align="center"><span style="color:<?php print $color; ?>; font-weight:bold;"><?php print $state; ?></style></td>
		<td><?php print $msg; ?></td>
	</tr>
	<tr>
		<td>ssh connect primary</td>
		<?php

		$state = 'OK';
		$msg   = '';
		$color = 'green';
		
		list($ret, $aPrimaryServer) = getServerById($dbh, $aVip['primary_id']);
		list($ret, $stdout) = checkSshConnect($aPrimaryServer);
		if ( $ret != OK ) {
			$state = 'ERR';
			$color = 'red';
			$msg   = "Cannot reach primary server via ssh: $stdout";
		}

		?>
		<td align="center"><span style="color:<?php print $color; ?>; font-weight:bold;"><?php print $state; ?></span></td>
		<td><?php print $msg; ?></td>
	</tr>
	<tr>
		<td>ssh connect failover</td>
		<?php

		$state = 'OK';
		$msg   = '';
		$color = 'green';
		
		list($ret, $aFailoverServer) = getServerById($dbh, $aVip['failover_id']);
		list($ret, $stdout) = checkSshConnect($aFailoverServer);
		if ( $ret != OK ) {
			$state = 'ERR';
			$color = 'red';
			$msg   = "Cannot reach failover server via ssh: $stdout";
		}

		?>
		<td align="center"><span style="color:<?php print $color; ?>; font-weight:bold;"><?php print $state; ?></style></td>
		<td><?php print $msg; ?></td>
	</tr>
	<tr>
		<td>DB connect over VIP</td>
		<?php

		$state = 'OK';
		$msg   = '';
		$color = 'green';
		
		// Get masters from cluster

		list($ret, $aNodes) = getNodesWithFilter($dbh, array('cluster_id' => $aVip['cluster_id'], 'role_id' => MASTER));
		// We only need one for connect check
		$aNode = array_shift($aNodes);
		$aNode['hostname'] = $aVip['ip_address'];

		list($ret, $msg) = checkDatabaseConnect($aNode);
		
		if ( $ret != OK ) {
			$state = 'ERR';
			$color = 'red';
		}
		else {
			$msg = '';
		}

		?>
		<td align="center"><span style="color:<?php print $color; ?>; font-weight:bold;"><?php print $state; ?></style></td>
		<td><?php print $msg; ?></td>
	</tr>
</table>

<?php

$gIndention -= 2;
logMessage(LOG_NOTICE, 'End page: ' . basename(__FILE__));

?>
