<?php

//
// Copyright (C) 2013, 2014 FromDual GmbH
//
// This program is commercial software. Use of this software is governed
// by your applicable license agreement with FromDual GmbH
//

logMessage(LOG_NOTICE, 'Begin page: ' . basename(__FILE__));
$gIndention += 2;

?>
<h1>Save VIP <?php print $aVip['ip_address']; ?></h1>
<?php

// print "<pre>"; print_r($aVip); print "</pre>";

$rc = OK;

// Do different checks here before saving...

// VIP does NOT have to belong to a Cluster!

// Is IP addr already in use?
list($ret, $aVips) = getVipsWithFilter($dbh, array('ip_address' => $aVip['ip_address']));
// remove our own:
foreach ( $aVips as $vip ) {
	if ( $vip['vip_id'] == $aVip['vip_id'] ) {
		unset($aVips[$vip['ip_address']]);
	}
}
if ( count($aVips) > 0 ) {
  $rc = 683;
  print "<p>VIP with IP address " . $aVip['ip_address'] . " already exists (rc=$rc).</p>\n";
}

// Is primary_id set?
if ( $aVip['primary_id'] == 0 ) {
  $rc = 692;
  print "<p>Please choose a primary location for this VIP (rc=$rc).</p>\n";
}

// If it is not a Cluster: Is Interface + Alias already in use on primary?
if ( $aVip['cluster_id'] == 0 ) {
	list($ret, $aVips) = getVipsWithFilter($dbh
											, array('primary_id' => $aVip['primary_id']
														, 'interface'  => $aVip['interface']
														, 'alias'      => $aVip['alias']
														 ));
	// remove our own:
	foreach ( $aVips as $vip ) {
		if ( $vip['vip_id'] == $aVip['vip_id'] ) {
			unset($aVips[$vip['ip_address']]);
		}
  }
  if ( count($aVips) > 0 ) {
		$rc = 686;
		print "<p>Interface and alias " . $aVip['interface'] . ':' . $aVip['alias'] . " already exists on this server (" . $aVip['primary_id'] . ") (rc=$rc).</p>\n";
  }
}
// If it is a Cluster: Is Interface + Alias on this cluster already in use?
else {
	list($ret, $aVips) = getVipsWithFilter($dbh
											, array('primary_id' => $aVip['cluster_id']
														, 'interface'  => $aVip['interface']
														, 'alias'      => $aVip['alias']
														 ));

  // remove our own:
	foreach ( $aVips as $vip ) {
		if ( $vip['vip_id'] == $aVip['vip_id'] ) {
      unset($aVips[$vip['ip_address']]);
    }
	}

  if ( count($aVips) > 0 ) {
		$rc = 680;
		print "<p>Interface and alias " . $aVip['interface'] . ':' . $aVip['alias'] . " already exists on this cluster (" . $aVip['cluster_id'] . ") (rc=$rc).</p>\n";
  }
}

// Is failover_id set? Only need on Cluster
if ( $aVip['cluster_id'] != 0 ) {
	if ( $aVip['failover_id'] == 0 ) {
		$rc = 695;
		print "<p>Please choose a failover location for this VIP (rc=$rc).</p>\n";
	}
}


if ( $rc == OK ) {

	list($rc, $dbh) = openRepositoryDatabase();
	if ( $aVip['vip_id'] == 0 ) {
		list($ret, $cnt) = addVip($dbh, $aVip);
	}
	else {
		list($ret, $cnt) = setVip($dbh, $aVip);
	}
	closeRepositoryDatabase($dbh);

	if ( $ret != 0 ) {
		$rc = 891;
		$msg = "ERROR: " . $e->getMessage() . " (rc=$rc)</p>";
    logMessage(LOG_ERR, $msg);
		print "<p>" . $msg . "</p>\n";
		?>
		<p><input type='button' value='Back' onClick='window.history.back();' /></p>
		<?php
	}
	else {
		?>
		<p>Vip safed succsessfully.</p>
		<input type="button" value="Continue" onclick="window.location='index.php?f=show&amp;o=vip&amp;s=overview';" />
    <?php
	}
}
// Error in variables check
else {
	?>
  <p><input type='button' value='Back' onClick='window.history.back();' /></p>
	<?php
}

$gIndention -= 2;
logMessage(LOG_NOTICE, 'End page: ' . basename(__FILE__));

?>
