<?php

//
// Copyright (C) 2013, 2014 FromDual GmbH
//
// This program is commercial software. Use of this software is governed
// by your applicable license agreement with FromDual GmbH
//

// print "<pre>"; print_r($_REQUEST); print "</pre>";

$hVipId = isset($_REQUEST['vip_id']) ? intval($_REQUEST['vip_id']) : 0;
// print "<pre>"; print_r($aVip); print "</pre>";


// Print Submenu
if ( ($hVipId == 0) || ($hSubMenu == 'overview') ) {
  // print overview withou submenu
}
else {

  ?>
  <table width="100%" border="1" cellpadding="3" cellspacing="0">
    <tr>
      <?php
      foreach ( $gMenuStructure['vip']['submenu'] as $submenu => $values ) {

        if ( $values['active'] === true ) {
          $url = "index.php?f=show&o=vip&s=" . $submenu . "&vip_id=" . $hVipId;
          print '<td align="center"><a href="' . $url . '">' . $values['title'] . "</a></td>\n";
        }
      }
      ?>
    </tr>
  </table>
  <?php
}

switch ( $hFunction ) {
case 'safe':
  $aVip = array();
  $aVip['vip_id']       = isset($_REQUEST['vip_id']) ? intval($_REQUEST['vip_id']) : 0;
  $aVip['ip_address']   = isset($_REQUEST['ip_address']) ? substr(strval($_REQUEST['ip_address']), 0, 32) : '';
  $aVip['name']         = isset($_REQUEST['name']) ? substr(strval($_REQUEST['name']), 0, 32) : '';
  $aVip['interface']    = isset($_REQUEST['interface']) ? substr(strval($_REQUEST['interface']), 0, 8) : '';
  $aVip['alias']        = isset($_REQUEST['alias']) ? intval($_REQUEST['alias']) : 0;
  $aVip['ipaddr_type']  = isset($_REQUEST['ipaddr_type']) ? intval($_REQUEST['ipaddr_type']) : 0;
  $aVip['primary_id']   = isset($_REQUEST['primary_id']) ? intval($_REQUEST['primary_id']) : 0;
  $aVip['failover_id']  = isset($_REQUEST['failover_id']) ? intval($_REQUEST['failover_id']) : 0;
  $aVip['location_id']  = isset($_REQUEST['location_id']) ? intval($_REQUEST['location_id']) : 0;
  $aVip['cluster_id']   = isset($_REQUEST['cluster_id']) ? intval($_REQUEST['cluster_id']) : 0;
  $aVip['fo_sync_only'] = isset($_REQUEST['fo_sync_only']) ? 1 : 0;
  $aVip['fo_wait_sync'] = isset($_REQUEST['fo_wait_sync']) ? 1 : 0;
  $hClusterId           = isset($_REQUEST['cluster_id']) ? intval($_REQUEST['cluster_id']) : 0;
  include('vip.safe.php');
break;
case 'add':
  include('vip.add.php');
break;
case 'edit':
  list($ret, $dbh) = openRepositoryDatabase();
  list($ret, $aVip) = getVipById($dbh, $hVipId);
  closeRepositoryDatabase($dbh);
  include('vip.edit.php');
break;
case 'start':
  list($ret, $dbh) = openRepositoryDatabase();
  list($ret, $aVip) = getVipById($dbh, $hVipId);
  closeRepositoryDatabase($dbh);
  $hClusterId = isset($_REQUEST['cluster_id']) ? intval($_REQUEST['cluster_id']) : 0;
  include('vip.start.php');
break;
case 'delete':
  list($ret, $dbh) = openRepositoryDatabase();
  list($ret, $aVip) = getVipById($dbh, $hVipId);
  closeRepositoryDatabase($dbh);
  include('vip.delete.php');
break;
case 'failover':
  list($ret, $dbh) = openRepositoryDatabase();
  list($ret, $aVip) = getVipById($dbh, $hVipId);
  closeRepositoryDatabase($dbh);
  $hClusterId = isset($_REQUEST['cluster_id']) ? intval($_REQUEST['cluster_id']) : 0;
  include('vip.failover.php');
break;
case 'stop':
  list($ret, $dbh) = openRepositoryDatabase();
  list($ret, $aVip) = getVipById($dbh, $hVipId);
  closeRepositoryDatabase($dbh);
  $hClusterId = isset($_REQUEST['cluster_id']) ? intval($_REQUEST['cluster_id']) : 0;
  include('vip.stop.php');
break;
case 'show':
  list($ret, $dbh) = openRepositoryDatabase();
  list($ret, $aVip) = getVipById($dbh, $hVipId);
  closeRepositoryDatabase($dbh);
  $hClusterId = isset($_REQUEST['cluster_id']) ? intval($_REQUEST['cluster_id']) : 0;

  // Set default
  if ( $hSubMenu == '' ) {
    $hSubMenu = 'overview';
  }

  if ( $hSubMenu == 'overview' ) {
    include('vip.show.overview.php');
  }
  elseif ( $hSubMenu == 'add' ) {
    include("vip.show.add.php");
  }
  elseif ( $hSubMenu == 'configuration' ) {
    include("vip.show.configuration.php");
  }
  elseif ( $hSubMenu == 'checks' ) {
    include("vip.show.checks.php");
  }
  elseif ( $hSubMenu == 'operations' ) {
    include("vip.show.operations.php");
  }
  else {
		$rc = 681;
    logMessage(LOG_ERR, "SubMenu $hSubMenu is not implemented (rc=$rc).");
  }

break;
default:
  $rc = 682;
	logMessage(LOG_ERR, "Function $hFunction is not implemented (rc=$rc).");
}

?>
