<?php

//
// Copyright (C) 2013, 2014 FromDual GmbH
//
// This program is commercial software. Use of this software is governed
// by your applicable license agreement with FromDual GmbH
//

logMessage(LOG_NOTICE, 'Begin page: ' . basename(__FILE__));
$gIndention += 2;

// print "<pre>"; print_r($aVip); print "</pre>";

require_once("lib/Vip.inc");
require_once("lib/Ssh.inc");

$rc = OK;

?>
<h1>Failover VIP <?php print $aVip['ip_address']; ?></h1>
<?php

// Check if VIP is started

list($ret, $msg) = checkPing($aVip['ip_address']);
$rc = $ret;

// VIP is stopped
if ( $ret != 0 ) {

  // Change location_id
  if ( $aVip['location_id'] == $aVip['primary_id'] ) {
    $aVip['location_id'] = $aVip['failover_id'];
  }
  else {
    $aVip['location_id'] = $aVip['primary_id'];
  }
  list($ret, $msg) = setVip($dbh, $aVip);
  $rc = $ret;
}
// VIP is started
else {

	try {

		// Only failover VIP if source and destination are in sync

		if ( $aVip['fo_sync_only'] != 0 ) {

			// Get failover machine

			if ( $aVip['location_id'] == $aVip['primary_id'] ) {
				$target = $aVip['failover_id'];
			}
			else {
				$target = $aVip['primary_id'];
			}

			// Get node on target

			list($ret, $aNodes) = getNodesWithFilter($dbh, array('cluster_id' => $aVip['cluster_id'], 'server_id' => $target));
			if ( $ret != OK ) {
				$rc = 916;
				$error = "Cannot get node (rc=$rc).";
				throw new Exception($error);
			}

			$aNode = array_shift($aNodes);
			list($ret, $mysqli) = openDatabaseConnection($aNode['database_user'], $aNode['database_user_password'], $aNode['hostname'], $aNode['port']);
			if ( $ret != OK ) {
				$rc = 912;
				$error = "Cannot connect to target (rc=$rc).";
				throw new Exception($error);
			}
			list($ret, $aStatus) = getShowSlaveStatus($mysqli);
			if ( $ret != OK ) {
				$rc = 911;
				$error = "Cannot get SHOW SLAVE STATUS (rc=$rc).";
				throw new Exception($error);
			}
			closeDatabaseConnection($mysqli);
			
			if ( ($aStatus['Slave_IO_Running'] != 'Yes')
				|| ($aStatus['Slave_SQL_Running'] != 'Yes')
				|| ($aStatus['Seconds_Behind_Master'] != '0')
				) {
				$rc = 910;
				$error = "Target is not in sync with master (rc=$rc).";
				logMessage(LOG_DEBUG, print_r($aStatus, true));
				throw new Exception($error);
			}
		}


		// Target seems to be in sync with master

		list($ret, $msg) = stopVip($aVip);


		// Change location_id

		if ( $aVip['location_id'] == $aVip['primary_id'] ) {
			$aVip['location_id'] = $aVip['failover_id'];
		}
		else {
			$aVip['location_id'] = $aVip['primary_id'];
		}
		list($ret, $msg) = setVip($dbh, $aVip);


		// Only start VIP if destination is in sync
		
		if ( $aVip['fo_wait_sync'] != 0 ) {
		
			$target = $aVip['location_id'];

			// Get node on target

			list($ret, $aNodes) = getNodesWithFilter($dbh, array('cluster_id' => $aVip['cluster_id'], 'server_id' => $target));
			if ( $ret != OK ) {
				$rc = 908;
				$error = "Cannot get node (rc=$rc).";
				throw new Exception($error);
			}

			$aNode = array_shift($aNodes);
			list($ret, $mysqli) = openDatabaseConnection($aNode['database_user'], $aNode['database_user_password'], $aNode['hostname'], $aNode['port']);
			if ( $ret != OK ) {
				$rc = 909;
				$error = "Cannot connect to target (rc=$rc).";
				throw new Exception($error);
			}
			list($ret, $aStatus) = getShowSlaveStatus($mysqli);
			if ( $ret != OK ) {
				$rc = 873;
				$error = "Cannot get SHOW SLAVE STATUS (rc=$rc).";
				throw new Exception($error);
			}
			
			if ( $aStatus['Seconds_Behind_Master'] > 60 ) {
				$rc = 872;
				$error = "Target is more than 60 seconds behind. Giving up. Please start VIP manually (rc=$rc).";
				throw new Exception($error);
			}

			if ( ($aStatus['Slave_IO_Running'] != 'Yes')
				|| ($aStatus['Slave_SQL_Running'] != 'Yes')
				) {
				$rc = 871;
				$error = "Target is not in sync with master. Giving up. Please start VIP manually (rc=$rc).";
				throw new Exception($error);
			}

			// retry 5 times (approx. 30 seconds = 1 + 2 + 4 + 8 + 16)

			for ( $i = 0 ; $i < 5 ; $i++ ) {


				list($ret, $aStatus) = getShowSlaveStatus($mysqli);
				if ( $ret != OK ) {
					break;
				}

				if ( $aStatus['Seconds_Behind_Master'] == 0 ) {
					break;
				}
				else {
					// Retry after 1, 2, 4, 8, 16s
					sleep(pow(2, $i));
				}
			}

			closeDatabaseConnection($mysqli);

			if ( ($aStatus['Slave_IO_Running'] != 'Yes')
				|| ($aStatus['Slave_SQL_Running'] != 'Yes')
				|| ($aStatus['Seconds_Behind_Master'] != '0')
				) {
				$rc = 870;
				$error = "Target is not in sync with master (rc=$rc).";
				throw new Exception($error);
			}
		}

		// Start VIP

		list($ret, $msg) = startVip($aVip);
		if ( $ret != OK ) {
			$rc = 761;
			$error = $msg . " (rc=$rc).";
			throw new Exception($error);
		}


		// Check if VIP is started again

		list($ret, $msg) = checkPing($aVip['ip_address']);
		if ( $ret != 0 ) {
			$rc = 763;
			$error = "VIP did not start again: " . $msg . " (rc=$rc).";
			throw new Exception($error);
		}
	}
	catch (Exception $e) {
		logMessage(LOG_ERR, $e->getMessage());
		print "<p>ERROR: " . $e->getMessage() . "</p>\n";
	}
}

// No error happened during failover
if ( $rc == OK ) {
  print "<p>Vip failovered succsessfully.</p>\n";
}

?>
<input type="button" value="Continue" onclick="window.location='index.php?f=show&amp;o=vip&amp;s=operations&amp;vip_id=<?php print $aVip['vip_id']; ?>';" />
<?php

$gIndention -= 2;
logMessage(LOG_NOTICE, 'End page: ' . basename(__FILE__));

?>
