<?php

//
// Copyright (C) 2013, 2014 FromDual GmbH
//
// This program is commercial software. Use of this software is governed
// by your applicable license agreement with FromDual GmbH
//

logMessage(LOG_NOTICE, 'Begin page: ' . basename(__FILE__));
$gIndention += 2;

list($rc, $dbh) = openRepositoryDatabase();
list($rc, $aServers) = getAllServers($dbh);
list($rc, $aClusters) = getAllClusters($dbh);

// New VIP
if ( $hVipId == 0 ) {

  ?>
  <h2>Add Virtual IP (VIP)</h2>
  <?php

  // Check what is possible or already there and make good guesses/suggestions

  // defaults
	$aVip = array();
  $aVip['vip_id']       = 0;
  $aVip['ip_address']   = '192.168.1.99';
  $aVip['name']         = '';
  $aVip['interface']    = 'eth0';
  $aVip['alias']        = 0;
  // old = 1
  // new = 2
  $aVip['ipaddr_type']  = 2;
  $aVip['primary_id']   = 0;
  $aVip['failover_id']  = 0;
  $aVip['location_id']  = 0;
  $aVip['fo_sync_only'] = 1;
  $aVip['fo_wait_sync'] = 1;
  $aVip['cluster_id']   = isset($_REQUEST['cluster_id']) ? intval($_REQUEST['cluster_id']) : 0;
}
// Edit VIP
else {

  ?>
  <h2>Edit Virtual IP (VIP)</h2>
  <?php

  list($rc, $aCluster) = getClusterOfVipById($dbh, $aVip['vip_id']);
}

closeRepositoryDatabase($dbh);

// print "<pre>"; print_r($aVip); print "</pre>";

// Check if VIP is still up
// then a VIP should ne be changed!
list($ret, $msg) = checkPing($aVip['ip_address']);
if ( $ret == OK ) {
	$vipup = '<span style="color:red; text-decoration:blink;"">VIP is still up. Please stop first!</span>';
}
else {
	$vipup = '';
}

?>

<form action="index.php" method="post">

<table border="1" cellpadding="3" cellspacing="0" width="75%">
  <tr>
		<th></th>
		<th align="left"><?php print $vipup; ?></th>
		<th align="left">Example</th>
	</tr>
  <tr>
    <td align="left">Cluster</td>
    <td>
      <select name="cluster_id">
        <option id="0">no Cluster</option>
        <?php
        foreach ( $aClusters as $cluster ) {
          $selected = '';
          if ( $cluster['cluster_id'] == $aVip['cluster_id'] ) {
            $selected = ' selected="selected"';
          }
          print "<option value='" . $cluster['cluster_id'] . "'" . $selected . ">" . $cluster['name'] . "</option>\n";
        }
        ?>
      </select>
    </td>
    <td></td>
  </tr>
  <tr>
    <td align="left">IP address</td>
    <td><input type="text" name="ip_address" value="<?php print $aVip['ip_address']; ?>" maxlength="15" size="8" /></td>
    <td>192.168.1.99</td>
  </tr>
  <tr>
    <td align="left">Service name</td>
    <td><input type="text" name="name" value="<?php print $aVip['name']; ?>" /></td>
    <td>prod_if</td>
  </tr>
  <tr>
    <td align="left">Interface</td>
    <td><input type="text" name="interface" value="<?php print $aVip['interface']; ?>" maxlength="8" size="4" /></td>
    <td>eth0</td>
  </tr>
  <tr>
    <td align="left">Alias</td>
    <td><input type="text" name="alias" value="<?php print $aVip['alias']; ?>" maxlength="2" size="1" /></td>
    <td>0</td>
  </tr>
  <tr>
    <td align="left">IPaddr type</td>
    <td>
      <?php
      $checked = '';
      if ( $aVip['ipaddr_type'] == 1 ) {
        $checked = ' checked="checked"';
      }
      ?>
      <input type="radio" name="ipaddr_type" value="1" <?php print $checked; ?> />old
      <?php
      $checked = '';
      if ( $aVip['ipaddr_type'] == 2 ) {
        $checked = ' checked="checked"';
      }
      ?>
      <input type="radio" name="ipaddr_type" value="2" <?php print $checked; ?> />new
    </td>
    <td></td>
  </tr>
  <tr>
    <td align="left">Primary</td>
    <td>
      <select name="primary_id">
        <option id="0">Please choose...</option>
        <?php
        foreach ( $aServers as $server ) {
          $selected = '';
          if ( $server['server_id'] == $aVip['primary_id'] ) {
            $selected = ' selected="selected"';
          }
          print "<option value='" . $server['server_id'] . "'" . $selected . ">" . $server['name'] . "</option>\n";
        }
        ?>
      </select>
    </td>
    <td></td>
  </tr>
  <tr>
    <td align="left">Failover</td>
    <td>
      <select name="failover_id">
        <option id="0">Please choose...</option>
        <?php
        foreach ( $aServers as $server ) {
          $selected = '';
          if ( $server['server_id'] == $aVip['failover_id'] ) {
            $selected = ' selected="selected"';
          }
          print "<option value='" . $server['server_id'] . "'" . $selected . ">" . $server['name'] . "</option>\n";
        }
        ?>
      </select>
    </td>
    <td></td>
  </tr>
  <tr>
    <td align="left">Failover only when sync</td>
    <?php
    $checked = '';
    if ( $aVip['fo_sync_only'] != 0 ) {
			$checked = 'checked="checked"';
    }
    ?>
    <td><input type="checkbox" name="fo_sync_only" <?php print $checked; ?> /></td>
    <td></td>
  </tr>
  <tr>
    <td align="left">Start VIP only when sync</td>
    <?php
    $checked = '';
    if ( $aVip['fo_wait_sync'] != 0 ) {
			$checked = 'checked="checked"';
    }
    ?>
    <td><input type="checkbox" name="fo_wait_sync" <?php print $checked; ?> /></td>
    <td></td>
  </tr>
  <tr><td></td><td>&nbsp;</td><td></td></tr>
  <tr>
    <td align="center"></td>
    <td>
      <?php
      if ( $aVip['vip_id'] == 0 ) {
        ?><input type="submit" value="Add VIP" /><?php
      }
      else {
        ?><input type="submit" value="Safe VIP" /><?php
      }
      ?>
			&nbsp;
      <input type="button" value="Back" onClick="window.history.back();" /></td>
    <td></td>
  </tr>
</table>

<input type="hidden" name="o" value="vip" />
<input type="hidden" name="f" value="safe" />
<input type="hidden" name="location_id" value="<?php print $aVip['location_id']; ?>" />
<input type="hidden" id="vip_id" name="vip_id" value="<?php print $aVip['vip_id']; ?>" />

</form>
<?php

$gIndention -= 2;
logMessage(LOG_NOTICE, 'End page: ' . basename(__FILE__));

?>
