<?php

//
// Copyright (C) 2013, 2014 FromDual GmbH
//
// This program is commercial software. Use of this software is governed
// by your applicable license agreement with FromDual GmbH
//

logMessage(LOG_NOTICE, 'Begin page: ' . basename(__FILE__));
$gIndention += 2;


if ( $hNodeId > 0 ) {
  list($rc, $aNode) = readNodeById($hNodeId);
}
else {
  $rc = 110;
  print "<p>There went something terribly wrong. Node ID is 0 (rc=$rc).</p>\n";
  exit($rc);
}

list($rc, $mysqli) = openDatabaseConnection($aNode['database_user'], $aNode['database_user_password'], $aNode['hostname'], $aNode['port']);
if ( $rc != 0 ) {
  $rc = 117;
  print "<p>Open database " . $aNode['name'] . " failed (rc=$rc)\n";
}

?>

<h1>Slave <?php print $aNode['name']; ?></h1>

<?php

// ---------------------------------------------------------------------
if ( $hType == '' )
// ---------------------------------------------------------------------
{
  ?><p>Stopping Slave...</p><?php

  print "<p>&nbsp;&nbsp;Stop SQL Thread...</p>\n";
  list($rc, $value) = stopSqlThread($mysqli);
  $color = 'green';
  if ( $rc != 0 ) {
    $color = 'red';
  }
  print "<p style='color:" . $color . ";'>&nbsp;&nbsp;" . $value ."</p>\n";


  print "<p>&nbsp;&nbsp;Check open temp tables...</p>\n";
  list($rc, $value) = getGlobalStatus($mysqli, 'Slave_open_temp_tables');
  if ( ($rc == OK) && ($value == 0) ) {
    $color = 'green';
    print "<p style='color:" . $color . ";'>&nbsp;&nbsp;No open temp table found.</p>\n";
  }
  else {
    $color = 'red';
    print "<p style='color:" . $color . ";'>&nbsp;&nbsp;" . $value . " open temp table(s) found.</p>\n";
  }


  $cnt = 1;
  while ( $value != 0 ) {

    if ( $cnt >= 10 ) {
      break;
    }

    print "<p>&nbsp;&nbsp;Start SQL Thread...</p>\n";
    list($rc, $value) = startSqlThread($mysqli);
    sleep($cnt);
    print "<p>&nbsp;&nbsp;Stop SQL Thread...</p>\n";
    list($rc, $value) = stopSqlThread($mysqli);
    print "<p>&nbsp;&nbsp;Check open temp tables...</p>\n";
    list($rc, $value) = getGlobalStatus($mysqli, 'Slave_open_temp_tables');
    $cnt++;
  }

  print "<p>We needed $cnt tries to stop SQL thread!</p>";

  // We gave up
  if ( $value > 1 ) {
    print "<p>We gave up stopping the slave after $cnt tries!</p>";
    print "<p>&nbsp;&nbsp;Starting SQL thread again!</p>";
    list($rc, $value) = startSqlThread($mysqli);
  }
  else {
    print "<p&nbsp;&nbsp;>Stopping IO tread as well...</p>";
    list($rc, $value) = stopIoThread($mysqli);
    $color = 'green';
    if ( $rc != 0 ) {
      $color = 'red';
    }
    print "<p style='color:" . $color . ";'>&nbsp;&nbsp;" . $value ."</p>\n";
  }

	?><p><code>SHOW SLAVE STATUS</code></p><?php

	list($rc, $aSlaveStatus) = getShowSlaveStatus($mysqli);
	// print "<pre>"; print_r($aSlaveStatus); print "</pre>\n";

	?>
	<table border="1" width="100%" cellpadding="3" cellspacing="0">
		<tr>
			<th align="left">Status</th>
			<th align="left">Value</th>
		</tr>
		<?php
		$aFields = array('Slave_IO_State', 'Slave_IO_Running', 'Slave_SQL_Running'
										, 'Last_Errno', 'Last_Error', 'Skip_Counter', 'Seconds_Behind_Master'
										, 'Last_IO_Errno', 'Last_IO_Error', 'Last_SQL_Errno', 'Last_SQL_Error');

		foreach ( $aFields as $key ) {
			?>
			<tr><td><?php print $key; ?></td><td><?php print $aSlaveStatus[$key]; ?></td></tr>
			<?php
		}
		?>
	</table>
	<?php
}
// ---------------------------------------------------------------------
elseif ( $hType == 'io_thread' )
// ---------------------------------------------------------------------
{
  ?><p>Stopping IO Thread...</p><?php
  print "<p&nbsp;&nbsp;>Stopping IO tread...</p>";
  list($rc, $value) = stopIoThread($mysqli);
  $color = 'green';
  if ( $rc != 0 ) {
    $color = 'red';
  }
  print "<p style='color:" . $color . ";'>&nbsp;&nbsp;" . $value ."</p>\n";

  print "<pre>SHOW SLAVE STATUS</pre>\n";
  list($rc, $aStatus) = getShowSlaveStatus($mysqli);
  print "<pre>"; print_r($aStatus); print "</pre>\n";
}
// ---------------------------------------------------------------------
elseif ( $hType == 'sql_thread' )
// ---------------------------------------------------------------------
{
  ?><p>Stopping SQL Thread...</p><?php

  print "<p>&nbsp;&nbsp;Stop SQL Thread...</p>\n";
  list($rc, $value) = stopSqlThread($mysqli);
  $color = 'green';
  if ( $rc != 0 ) {
    $color = 'red';
  }
  print "<p style='color:" . $color . ";'>&nbsp;&nbsp;" . $value ."</p>\n";

  // print "<pre>SHOW SLAVE STATUS</pre>\n";
  // list($rc, $aStatus) = getShowSlaveStatus($mysqli);
  // print "<pre>"; print_r($aStatus); print "</pre>\n";
}
// ---------------------------------------------------------------------
else
// ---------------------------------------------------------------------
{
  $rc = 119;
  print "<p>ERROR (rc=$rc).</p>\n";
}

closeDatabaseConnection($mysqli);

list($rc, $dbh) = openRepositoryDatabase();
if ( $rc != 0 ) {
  $rc = 131;
  print "<p>Cannot open configuration database (rc=$rc).</p>\n";
  return array($rc, $aNode);
}
list($rc, $aCluster) = getClusterOfNode($dbh, $aNode['node_id']);

closeRepositoryDatabase($dbh);

?>

<p><input type="button" value="Continue" onclick="location.href='index.php?f=show&amp;o=replication&amp;s=operations&amp;cluster_id=<?php print $aCluster['cluster_id']; ?>';" /></p>

<?php

$gIndention -= 2;
logMessage(LOG_NOTICE, 'End page: ' . basename(__FILE__));

?>
