<?php

//
// Copyright (C) 2013, 2014 FromDual GmbH
//
// This program is commercial software. Use of this software is governed
// by your applicable license agreement with FromDual GmbH
//

// require_once('lib/Database.inc');

if ( $hNodeId > 0 ) {
  list($rc, $aNode) = readNodeById($hNodeId);
}
else {
  $rc = 139;
  print "<p>There went something terribly wrong. Node ID is 0 (rc=$rc).</p>\n";
  exit($rc);
}

list($rc, $mysqli) = openDatabaseConnection($aNode['database_user'], $aNode['database_user_password'], $aNode['hostname'], $aNode['port']);
if ( $rc != 0 ) {
  $rc = 140;
  print "<p>Open database " . $aNode['name'] . " failed (rc=$rc)\n";
}

?>

<h1>Slave <?php print $aNode['name']; ?></h1>

<?php

// ---------------------------------------------------------------------
if ( $hType == '' )
// ---------------------------------------------------------------------
{
  ?>
  <p>Starting Slave...</p>
  <p>&nbsp;&nbsp;Start Slave...</p>
  <?php
  list($rc, $value) = startSlave($mysqli);
  $color = 'green';
  if ( $rc != 0 ) {
    $color = 'red';
  }
  ?>
  <p style="color:'<?php print $color; ?>;'">&nbsp;&nbsp;<?php print $value; ?></p>
  <?php

  // Sleep some time otherwiese SHOW SLAVE STATUS command is too fast!
  sleep(1);

  ?>
  <p><code>SHOW SLAVE STATUS</code></p>
  <?php
  list($rc, $aSlaveStatus) = getShowSlaveStatus($mysqli);
  // print "<pre>"; print_r($aSlaveStatus); print "</pre>\n";
  ?>
  <table border='1' width='100%' cellpadding='3' cellspacing='0'>
  <tr>
    <th align='left'>Status</th>
    <th align='left'>Value</th>
  </tr>
  <?php
  $aFields = array('Slave_IO_State', 'Slave_IO_Running', 'Slave_SQL_Running'
                 , 'Last_Errno', 'Last_Error', 'Skip_Counter', 'Seconds_Behind_Master'
                 , 'Last_IO_Errno', 'Last_IO_Error', 'Last_SQL_Errno', 'Last_SQL_Error');

  foreach ( $aFields as $key ) {
    ?>
    <tr>
      <td><?php print $key; ?></td>
      <td><?php print $aSlaveStatus[$key]; ?></td>
    </tr>
    <?php
  }
  ?>
  </table>
  <?php
}
// ---------------------------------------------------------------------
elseif ( $hType == 'io_thread' )
// ---------------------------------------------------------------------
{
  ?><p>Starting IO Thread...</p><?php

  list($ret, $value) = startIoThread($mysqli);

  $color = 'green';
  if ( $ret != 0 ) {
    $color = 'red';
  }
  ?><p style="color:'<?php print $color; ?>;'">&nbsp;&nbsp;<?php print $value; ?></p><?php

  // Sleep some time otherwiese SHOW SLAVE STATUS command is too fast!
  sleep(1);

  list($rc, $aSlaveStatus) = getShowSlaveStatus($mysqli);
  // print "<pre>"; print_r($aSlaveStatus); print "</pre>\n";
  ?>
  <table border='1' width='100%' cellpadding='3' cellspacing='0'>
    <tr>
      <th align='left'>Status</th>
      <th align='left'>Value</th>
    </tr>
    <?php
  $aFields = array('Slave_IO_State', 'Slave_IO_Running', 'Slave_SQL_Running'
                 , 'Last_Errno', 'Last_Error', 'Skip_Counter', 'Seconds_Behind_Master'
                 , 'Last_IO_Errno', 'Last_IO_Error', 'Last_SQL_Errno', 'Last_SQL_Error');

  foreach ( $aFields as $key ) {
    ?>
    <tr>
      <td><?php print $key; ?></td>
      <td><?php print $aSlaveStatus[$key]; ?></td>
    </tr>
    <?php
  }
  ?>
  </table>
  <?php
}
// ---------------------------------------------------------------------
elseif ( $hType == 'sql_thread' )
// ---------------------------------------------------------------------
{
  ?><p>Starting SQL Thread...</p>

  <p>&nbsp;&nbsp;Start SQL Thread...</p><?php
  list($rc, $value) = startSqlThread($mysqli);
  $color = 'green';
  if ( $rc != 0 ) {
    $color = 'red';
  }
  ?>
  <p style="color:'<?php print $color; ?>;'">&nbsp;&nbsp;<?php print $value; ?></p>
  <?php

  // Sleep some time otherwiese SHOW SLAVE STATUS command is too fast!
  sleep(1);

  ?>
  <p><code>SHOW SLAVE STATUS</code></p>
  <?php
  list($rc, $aSlaveStatus) = getShowSlaveStatus($mysqli);
  // print "<pre>"; print_r($aSlaveStatus); print "</pre>\n";
  ?><table border='1' width='100%' cellpadding='3' cellspacing='0'>
  <tr>
    <th align='left'>Status</th>
    <th align='left'>Value</th>
  </tr>
  <?php
  $aFields = array('Slave_IO_State', 'Slave_IO_Running', 'Slave_SQL_Running'
                 , 'Last_Errno', 'Last_Error', 'Skip_Counter', 'Seconds_Behind_Master'
                 , 'Last_IO_Errno', 'Last_IO_Error', 'Last_SQL_Errno', 'Last_SQL_Error');

  foreach ( $aFields as $key ) {
    ?>
    <tr>
      <td><?php print $key; ?></td>
      <td><?php print $aSlaveStatus[$key]; ?></td>
    </tr>
    <?php
  }
  ?>
  </table>
  <?php
}
// ---------------------------------------------------------------------
else
// ---------------------------------------------------------------------
{
  $rc = 141;
  print "<p>ERROR (rc=$rc).</p>\n";
}


// Do check and suggestions if Slave does not connect to master:

// print "<pre>"; print_r($aSlaveStatus); print "</pre>";

if ( $aSlaveStatus['Slave_IO_Running'] != 'Yes' ) {

  // todo:
  // getMasterInfo($mysqli, $aNode)
	// 		- check if user exits,
	// 
	// 		- probe password,
	//     // getReplicationUsers
	// 
	//   - if slave cannot connect to master:
	// 		- if user has correct rights and host try if it is possibly to connect from slave to master in the same way!
}

closeDatabaseConnection($mysqli);

list($rc, $dbh) = openRepositoryDatabase();
if ( $rc != 0 ) {
  $rc = 111;
  print "<p>Cannot open configuration database (rc=$rc).</p>\n";
  return array($rc, $aNode);
}
list($rc, $aCluster) = getClusterOfNode($dbh, $aNode['node_id']);
closeRepositoryDatabase($dbh);

?>

<p><input type="button" value="Continue" onclick="location.href='index.php?f=show&amp;o=replication&amp;s=operations&amp;cluster_id=<?php print $aCluster['cluster_id']; ?>';" /></p>
