<?php

//
// Copyright (C) 2013, 2014 FromDual GmbH
//
// This program is commercial software. Use of this software is governed
// by your applicable license agreement with FromDual GmbH
//

// require_once('lib/Database.inc');

if ( $hNodeId > 0 ) {
  list($rc, $aNode) = readNodeById($hNodeId);
}
else {
  $rc = 107;
  print "<p>There went something terribly wrong. Node ID is 0 (rc=$rc).</p>\n";
  exit($rc);
}

list($rc, $mysqli) = openDatabaseConnection($aNode['database_user'], $aNode['database_user_password'], $aNode['hostname'], $aNode['port']);
if ( $rc != 0 ) {
  $rc = 108;
  print "<p>Open database " . $aNode['name'] . " failed (rc=$rc)\n";
}

?>

<h1>Slave <?php print $aNode['name']; ?></h1>

<?php

// ---------------------------------------------------------------------
if ( $hType == 'event' )
// ---------------------------------------------------------------------
{
  ?><p>Skip Event...</p><?php

  print "<p>&nbsp;&nbsp;Stopt Slave...</p>\n";
  list($rc, $value) = stopSlaveDirect($mysqli);
  $color = 'green';
  if ( $rc != 0 ) {
    $color = 'red';
  }
  print "<p style='color:" . $color . ";'>&nbsp;&nbsp;" . $value ."</p>\n";

  // Sleep some time otherwiese SHOW SLAVE STATUS command is too fast!
  sleep(1);

  print "<p><code>SHOW SLAVE STATUS</code></p>\n";
  list($rc, $aSlaveStatus) = getShowSlaveStatus($mysqli);
  // print "<pre>"; print_r($aSlaveStatus); print "</pre>\n";
  print "<table border='1' width='100%' cellpadding='3' cellspacing='0'>\n";
  print "<tr><th align='left'>Status</th><th align='left'>Value</th></tr>\n";
  $aFields = array('Slave_IO_Running', 'Slave_SQL_Running'
                 , 'Last_Errno', 'Last_Error', 'Skip_Counter', 'Seconds_Behind_Master'
                 , 'Last_IO_Errno', 'Last_IO_Error', 'Last_SQL_Errno', 'Last_SQL_Error');

  foreach ( $aFields as $key ) {
    print "<tr><td>" . $key . "</td><td>" . $aSlaveStatus[$key] . "</td></tr>\n";
  }
  print "</table>\n";


  print "<p>&nbsp;&nbsp;Skip 1 event...</p>\n";
  list($rc, $value) = skipSlaveEvent($mysqli, 1);
  $color = 'green';
  if ( $rc != 0 ) {
    $color = 'red';
  }
  print "<p style='color:" . $color . ";'>&nbsp;&nbsp;" . $value ."</p>\n";

  // Sleep some time otherwiese SHOW SLAVE STATUS command is too fast!
  sleep(1);

  print "<p><code>SHOW SLAVE STATUS</code></p>\n";
  list($rc, $aSlaveStatus) = getShowSlaveStatus($mysqli);
  // print "<pre>"; print_r($aSlaveStatus); print "</pre>\n";
  print "<table border='1' width='100%' cellpadding='3' cellspacing='0'>\n";
  print "<tr><th align='left'>Status</th><th align='left'>Value</th></tr>\n";
  $aFields = array('Slave_IO_Running', 'Slave_SQL_Running'
                 , 'Last_Errno', 'Last_Error', 'Skip_Counter', 'Seconds_Behind_Master'
                 , 'Last_IO_Errno', 'Last_IO_Error', 'Last_SQL_Errno', 'Last_SQL_Error');

  foreach ( $aFields as $key ) {
    print "<tr><td>" . $key . "</td><td>" . $aSlaveStatus[$key] . "</td></tr>\n";
  }
  print "</table>\n";


  print "<p>&nbsp;&nbsp;Start Slave...</p>\n";
  list($rc, $value) = startSlave($mysqli);
  $color = 'green';
  if ( $rc != 0 ) {
    $color = 'red';
  }
  print "<p style='color:" . $color . ";'>&nbsp;&nbsp;" . $value ."</p>\n";

  // Sleep some time otherwiese SHOW SLAVE STATUS command is too fast!
  sleep(1);

  print "<p><code>SHOW SLAVE STATUS</code></p>\n";
  list($rc, $aSlaveStatus) = getShowSlaveStatus($mysqli);
  // print "<pre>"; print_r($aSlaveStatus); print "</pre>\n";
  print "<table border='1' width='100%' cellpadding='3' cellspacing='0'>\n";
  print "<tr><th align='left'>Status</th><th align='left'>Value</th></tr>\n";
  $aFields = array('Slave_IO_Running', 'Slave_SQL_Running'
                 , 'Last_Errno', 'Last_Error', 'Skip_Counter', 'Seconds_Behind_Master'
                 , 'Last_IO_Errno', 'Last_IO_Error', 'Last_SQL_Errno', 'Last_SQL_Error');

  foreach ( $aFields as $key ) {
    print "<tr><td>" . $key . "</td><td>" . $aSlaveStatus[$key] . "</td></tr>\n";
  }
  print "</table>\n";
}
// ---------------------------------------------------------------------
else
// ---------------------------------------------------------------------
{
  $rc = 109;
  print "<p>ERROR (rc=$rc).</p>\n";
}

closeDatabaseConnection($mysqli);

list($rc, $dbh) = openRepositoryDatabase();
if ( $rc != 0 ) {
  $rc = 106;
  print "<p>Cannot open configuration database (rc=$rc).</p>\n";
  return array($rc, $aNode);
}
list($rc, $aCluster) = getClusterOfNode($dbh, $aNode['node_id']);
closeRepositoryDatabase($dbh);

?>

<p><input type="button" value="Continue" onclick="location.href='index.php?f=show&amp;o=replication&amp;s=operations&amp;cluster_id=<?php print $aCluster['cluster_id']; ?>';" /></p>
